/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAggregateCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.AggregateDimension;
import com.ibm.cognos.fmeng.fmmd.model.AggregateHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.AggregateMeasure;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregateCubeAnalyser
extends AnalyserBase<FmAggregateCube> {
    private FmAggregateCube m_aggCube = null;

    public AggregateCubeAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public AggregateCubeAnalyser(AnalyserConfig obj) {
        super(obj);
    }

    @Override
    protected void doAnalysis(FmAggregateCube obj) {
        this.m_aggCube = obj;
        this.validateDimensions(obj);
        this.validateMeasure(obj);
    }

    private void validateDimensions(FmAggregateCube aggCube) {
        if (aggCube.getAggregateDimensions().size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_AGGREGATE_CUBE_NO_DIMENSION, FeedbackMessage.FeedbackSeverity.ERROR, this.m_aggCube.getName(), this.m_aggCube));
        }
        for (AggregateDimension aggDim : aggCube.getAggregateDimensions()) {
            if (aggDim.getDimension().getParentChild()) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DELETE_AGGREGATE_PARENT_CHILD_DIMENSION, FeedbackMessage.FeedbackSeverity.ERROR, aggDim.getName(), this.m_aggCube.getName(), this.m_aggCube));
            }
            if (aggDim.getAggregateHierarchies().size() > 0) {
                for (AggregateHierarchy aggHier : aggDim.getAggregateHierarchies()) {
                    if (aggHier.getLevels().size() != 0) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_AGGREGATE_CUBE_NO_LEVEL_SELECTION, FeedbackMessage.FeedbackSeverity.ERROR, aggDim.getName(), this.m_aggCube.getName(), this.m_aggCube));
                }
                continue;
            }
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_AGGREGATE_CUBE_NO_LEVEL_SELECTION, FeedbackMessage.FeedbackSeverity.ERROR, aggDim.getName(), this.m_aggCube.getName(), this.m_aggCube));
        }
    }

    private void validateMeasure(FmAggregateCube aggCube) {
        if (aggCube.getAggregateMeasures().size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_AGGREGATE_CUBE_NO_MEASURE, FeedbackMessage.FeedbackSeverity.ERROR, this.m_aggCube.getName(), this.m_aggCube));
        }
        for (AggregateMeasure aggMeasure : aggCube.getAggregateMeasures()) {
            BaseObject measure = aggMeasure.getRef();
            if (measure instanceof FmMeasure) {
                List<AggregateRule> aggRules = ((FmMeasure)measure).getAggregateRules();
                if (aggRules.size() <= 0) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DELETE_SEMI_ADDITIVE_AGGREGATE_MEASURE, FeedbackMessage.FeedbackSeverity.ERROR, measure.getName(), this.m_aggCube.getName(), this.m_aggCube));
                continue;
            }
            if (!(measure instanceof FmCalculatedMember)) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DELETE_CALC_AGGREGATE_MEASURE, FeedbackMessage.FeedbackSeverity.ERROR, measure.getName(), this.m_aggCube.getName(), this.m_aggCube));
        }
    }
}

