/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCollector;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.CalculatedMemberAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.MeasureAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.MeasureFolderAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualMeasureAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualMeasureFolderAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.CubeBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionHandler;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LocalizedValue;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.MeasureFolder;
import com.ibm.cognos.fmeng.fmmd.model.Property;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.Status;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureFolder;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutesCache;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProgressCallbackHandler;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnalyserBase<T extends FmBaseObject> {
    protected AnalyserConfig m_Config;

    public AnalyserBase(AnalyserConfig config) {
        this.m_Config = config;
    }

    public AnalyserBase(AnalyserBase<?> obj) {
        this.m_Config = obj.m_Config;
    }

    public void addMessage(FeedbackMessage msg) {
        this.m_Config.m_Feedback.add(msg);
    }

    public FmRoutesCache<FmTable, FmJoin> getRoutesCache() {
        return this.m_Config.m_RoutesCache;
    }

    public void analyse(T obj) {
        ProgressCallbackHandler callback = ((FmBaseObject)obj).getSession().getProgressCallbackHandler();
        if (callback != null && callback.isCancelRequested()) {
            throw new FmMDException("BMT_MD_CANCELED");
        }
        if (this.m_Config.isAnalysed((FmBaseObject)obj)) {
            return;
        }
        this.m_Config.setAnalysed((FmBaseObject)obj);
        if (obj instanceof Status) {
            Status statObj = (Status)obj;
            statObj.setStatus(Status.EStatus.valid);
        }
        this.doAnalysis(obj);
    }

    public void analysePerformance(T obj) {
        if (this.m_Config.isAnalysed((FmBaseObject)obj)) {
            return;
        }
        this.m_Config.setAnalysed((FmBaseObject)obj);
        this.doAnalysis(obj);
    }

    protected void checkForInvalidROLAPCharacter(FmBaseObject obj) {
        if (obj.getSession().getClientType().equals((Object)FMMDSession.ClientType.CubeDesigner)) {
            Cube cube = obj.getAncestorCube();
            if (cube != null && cube.isAggregateCube()) {
                return;
            }
            String name = obj.getName();
            if (name.contains("]")) {
                String path = obj.getParent().getID();
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_NAME_ROLAP, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
            }
        }
    }

    protected void setContextPackage(FmPackage pack) {
        this.m_Config.m_ContextPackage = pack;
    }

    protected void setContextCube(FmCube cube) {
        this.m_Config.m_ContextCube = cube;
    }

    protected boolean isCubingServicesCompatible() {
        FmCube cube = this.m_Config.m_ContextCube;
        if (cube == null) {
            return false;
        }
        Property prop = cube.getCustomProperty("cubingServicesCompatibility");
        if (prop == null) {
            return false;
        }
        return prop.getValue().equals("true");
    }

    protected FmCube getContextCube() {
        return this.m_Config.m_ContextCube;
    }

    protected FmPackage getContextPackage() {
        return this.m_Config.m_ContextPackage;
    }

    protected boolean isAggregateCube() {
        FmCube cube = this.m_Config.m_ContextCube;
        if (cube == null) {
            return false;
        }
        return cube.isAggregateCube();
    }

    protected boolean isRegularCube() {
        FmCube cube = this.m_Config.m_ContextCube;
        if (cube == null) {
            return false;
        }
        return cube.getCubeStyle() == CubeBase.CubeStyle.regular;
    }

    protected abstract void doAnalysis(T var1);

    public void validateMultilingualNames(ReportObject obj) {
        FmRelationalHierarchy hier;
        BaseObject baseObj = obj;
        while (baseObj != null) {
            if (baseObj instanceof Cube) {
                Cube cube = (Cube)baseObj;
                if (cube.getCubeStyle() != CubeBase.CubeStyle.aggregate) break;
                return;
            }
            baseObj = baseObj.getParent();
        }
        FmProject m_ProjectObj = (FmProject)obj.getProject();
        List<String> projectLocales = m_ProjectObj.getSupportedLocales();
        List<String> localLocales = obj.getSupportedLocales();
        if (obj instanceof FmRelationalHierarchy && !(hier = (FmRelationalHierarchy)obj).isMultiRoot()) {
            for (String localLocale : projectLocales) {
                if (hier.getRootCaption(localLocale) != null) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_LOCALE_FOR_ROOT_CAP, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), obj.getParent().getID(), (FmBaseObject)((Object)obj)));
                break;
            }
        }
        if (obj instanceof FmQueryItem) {
            RelationalObject ro;
            FmQueryItem queryItem = (FmQueryItem)obj;
            if (!(queryItem.getHidden() || (ro = queryItem.getRelationalParent()) != null && ro instanceof RelationalParameterMap)) {
                this.checkMissingLocales(localLocales, projectLocales, obj);
            }
        } else if (obj instanceof FmCalculatedMember) {
            FmCalculatedMember calcMem = (FmCalculatedMember)obj;
            if (!calcMem.getHidden()) {
                this.checkMissingLocales(localLocales, projectLocales, obj);
            }
        } else if (obj instanceof FmMeasure) {
            FmMeasure measure = (FmMeasure)obj;
            if (!measure.getHidden()) {
                this.checkMissingLocales(localLocales, projectLocales, obj);
            }
        } else if (!(obj instanceof FmRelationalParameterMap)) {
            this.checkMissingLocales(localLocales, projectLocales, obj);
        }
    }

    private void checkMissingLocales(List<String> localLocales, List<String> projectLocales, ReportObject obj) {
        if (localLocales.size() != projectLocales.size()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_LOCALE, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), obj.getParent().getID(), (FmBaseObject)((Object)obj)));
        }
    }

    public void checkSourceObjects(FmVirtualObject obj) {
        List<SourceObject> sources = obj.getSourceObjects();
        if (sources == null || sources.size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_SOURCE_OBJECTS, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj.getID(), obj));
        }
        for (SourceObject source : sources) {
            Object src;
            if (source.isModelSource()) {
                src = source.getModelSource();
                if (src != null) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNKNOWN_SOURCE_OBJECT, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), source.getID(), obj));
                continue;
            }
            src = source.getMetadataSource();
            if (src != null) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNKNOWN_SOURCE_METADATA_OBJECT, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), source.getName(), source.getCubeSource().getName(), (FmBaseObject)obj));
        }
    }

    protected boolean checkEmptyExpression(FmBaseObject obj, Expression expr) {
        if (expr == null || expr.getComponents().isEmpty()) {
            String path = obj.getParent() instanceof FmCollector ? obj.getParent().getParent().getID() : obj.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.EMPTY_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
            return true;
        }
        return false;
    }

    protected boolean checkMDXExpression(FmBaseObject obj, Expression expr) {
        boolean isEmpty = this.checkEmptyExpression(obj, expr);
        if (!isEmpty) {
            MDXExpressionValidator validator = new MDXExpressionValidator(obj);
            expr.evaluateComponents(validator);
        }
        return isEmpty;
    }

    protected void analyseChildren(BaseObject parent) {
        AnalyserBase virtualMeasureFolderAnalyser = null;
        AnalyserBase virtualMeasureAnalyser = null;
        AnalyserBase calcMeasureAnalyser = null;
        AnalyserBase measureAnalyser = null;
        AnalyserBase measureFolderAnalyser = null;
        for (BaseObject child : parent.getChildObjects()) {
            if (child instanceof VirtualMeasureFolder) {
                if (virtualMeasureFolderAnalyser == null) {
                    virtualMeasureFolderAnalyser = new VirtualMeasureFolderAnalyser(this);
                }
                virtualMeasureFolderAnalyser.analyse((FmVirtualMeasureFolder)child);
            }
            if (child instanceof VirtualMeasure) {
                if (virtualMeasureAnalyser == null) {
                    virtualMeasureAnalyser = new VirtualMeasureAnalyser(this);
                }
                virtualMeasureAnalyser.analyse((FmVirtualMeasure)child);
            }
            if (child instanceof MeasureFolder) {
                if (measureFolderAnalyser == null) {
                    measureFolderAnalyser = new MeasureFolderAnalyser(this);
                }
                measureFolderAnalyser.analyse((FmMeasureFolder)child);
            }
            if (child instanceof Measure) {
                if (measureAnalyser == null) {
                    measureAnalyser = new MeasureAnalyser(this);
                }
                measureAnalyser.analyse((FmMeasure)child);
            }
            if (!(child instanceof CalculatedMember)) continue;
            if (calcMeasureAnalyser == null) {
                calcMeasureAnalyser = new CalculatedMemberAnalyser(this);
            }
            calcMeasureAnalyser.analyse((FmCalculatedMember)child);
        }
    }

    protected void checkForMemberDefinitionFromOptionalTable(List<QueryItemBase> invalidQIs, FmRelationalDimension dim, FmReportObject obj) {
        List<Join> joins = dim.getJoins();
        if (joins.size() == 0) {
            return;
        }
        ArrayList<Table> zeroSide = new ArrayList<Table>();
        for (Join join : joins) {
            if (join.getLeftMincard().equals((Object)Cardinality.ECardinality.zero)) {
                zeroSide.add(join.getLeftTable());
                continue;
            }
            if (!join.getRightMincard().equals((Object)Cardinality.ECardinality.zero)) continue;
            zeroSide.add(join.getRightTable());
        }
        if (zeroSide.size() == 0) {
            return;
        }
        List<QueryItemMapping> mappings = dim.getQueryItemMappings(invalidQIs);
        for (QueryItemMapping mapping : mappings) {
            for (Table table : zeroSide) {
                if (!mapping.getTable().equals(table)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.BAD_QUERY_ITEM_IN_JOINED_TABLE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), table.getName(), obj));
            }
        }
    }

    protected void checkForBadCubeName(FmReportObject cube) {
        for (LocalizedValue name : cube.getNames()) {
            if (!cube.validateName(name.getValue(), false)) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.BAD_CUBE_NAME, FeedbackMessage.FeedbackSeverity.ERROR, cube.getName(), name.getLocale(), cube));
        }
    }

    protected void checkIfStandaloneFilterOrCalculationHasReferencesToItemsFromACube(BaseObject obj, HashSet<BaseObject> parts) {
        for (BaseObject bObj : parts) {
            FmMeasure m;
            FmMeasureDimension dim;
            Cube cube;
            if (bObj instanceof QueryItem) {
                FmQueryItem qi = (FmQueryItem)bObj;
                FmRelationalHierarchy hierar = (FmRelationalHierarchy)qi.getHierarchy();
                if (hierar == null) continue;
                FmRelationalDimension dim2 = (FmRelationalDimension)hierar.getDimension();
                for (Relationship r : dim2.getRelationships()) {
                    BaseObject parent = r.getParent();
                    if (!(parent instanceof Cube)) continue;
                    if (obj instanceof FmFilter) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.QUERY_ITEM_USED_IN_FILTER_PART_OF_CUBE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), qi.getName(), parent.getName(), (FmBaseObject)obj));
                        continue;
                    }
                    if (!(obj instanceof FmCalculation)) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.QUERY_ITEM_USED_IN_CALCULATION_PART_OF_CUBE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), qi.getName(), parent.getName(), (FmBaseObject)obj));
                }
                continue;
            }
            if (!(bObj instanceof Measure) || (cube = (dim = (FmMeasureDimension)(m = (FmMeasure)bObj).getParentMeasureDimension()).getAncestorCube()) == null) continue;
            if (obj instanceof FmFilter) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MEASURE_USED_IN_FILTER_PART_OF_CUBE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), m.getName(), cube.getName(), (FmBaseObject)obj));
                continue;
            }
            if (!(obj instanceof FmCalculation)) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MEASURE_USED_IN_CALCULATION_PART_OF_CUBE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), m.getName(), cube.getName(), (FmBaseObject)obj));
        }
    }

    class MDXExpressionValidator
    extends ExpressionHandler {
        private FmBaseObject m_calcMemOrAccessRule;
        Pattern MUNPattern = Pattern.compile(FmMemberUniqueName.MUN);

        public MDXExpressionValidator(FmBaseObject obj) {
            this.m_calcMemOrAccessRule = obj;
        }

        public void doString(String value) {
            Matcher munMatch = this.MUNPattern.matcher(value);
            while (munMatch.find()) {
                AnalyserBase.this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_UNIQUE_NAME, FeedbackMessage.FeedbackSeverity.ERROR, munMatch.group(), this.m_calcMemOrAccessRule.getName(), this.getPath(this.m_calcMemOrAccessRule), this.m_calcMemOrAccessRule));
            }
        }

        public void doFmUnresolvedReference(FmUnresolvedReference value) {
            AnalyserBase.this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.EXPRESSION_HAS_UNRESOLVED_REFERENCE, FeedbackMessage.FeedbackSeverity.ERROR, value.getReference(), this.m_calcMemOrAccessRule.getName(), this.getPath(this.m_calcMemOrAccessRule), this.m_calcMemOrAccessRule));
        }

        public void doFmQueryItem(FmQueryItem value) {
            BaseObject parent = value.getParent();
            if (parent instanceof Level) {
                FmBaseObject calcContainer = null;
                BaseObject calcParent = this.m_calcMemOrAccessRule;
                while (calcParent != null) {
                    if (calcParent instanceof RelationalHierarchy) {
                        calcContainer = calcParent;
                        break;
                    }
                    if (calcParent instanceof MeasureDimension) {
                        calcContainer = calcParent;
                        break;
                    }
                    calcParent = calcParent.getParent();
                }
                FmMDException.ASSERT(calcContainer != null, "Unknown container for " + this.m_calcMemOrAccessRule.getID());
                AnalyserBase.this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNKNOWN_ATTRIBUTE_REFERENCE, FeedbackMessage.FeedbackSeverity.ERROR, this.m_calcMemOrAccessRule.getName(), calcContainer.getID(), value.getName(), this.m_calcMemOrAccessRule, (FmBaseObject)value));
            }
        }

        public String getPath(FmBaseObject obj) {
            String path = obj.getParent().getID();
            return path;
        }
    }
}

