/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAttributeReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.HierarchyBase;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CalculatedMemberAnalyser
extends AnalyserBase<FmCalculatedMember> {
    public CalculatedMemberAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public CalculatedMemberAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmCalculatedMember obj) {
        this.checkForInvalidROLAPCharacter(obj);
        Cube parentCube = obj.getAncestorCube();
        if (parentCube != null && parentCube.isAggregateCube()) {
            return;
        }
        if (this.m_Config.getContext() != TaskAnalyseObject.AnalysisContext.memberbrowse) {
            this.checkParentMember(obj);
            this.checkMDXExpression(obj, obj.getExpression());
        }
        this.validateMultilingualNames(obj);
        this.checkCalculatedMemberExpressionForCaptionAndBusinessKeyAttributes(obj);
    }

    private void checkParentMember(FmCalculatedMember obj) {
        int needsParent = 1;
        HierarchyBase parentBase = obj.getHierarchy();
        if (parentBase != null && parentBase instanceof RelationalHierarchy) {
            RelationalHierarchy parent = (RelationalHierarchy)parentBase;
            if (parent.getParentChild()) {
                String rootMember = parent.getRootMember();
                if (rootMember != null && !"".equals(rootMember)) {
                    needsParent = 0;
                }
            } else {
                Level allLevel = parent.getAllLevel();
                if (allLevel != null) {
                    needsParent = 0;
                }
            }
        } else {
            needsParent = 2;
        }
        MemberUniqueName parentMun = obj.getParentMember();
        String path = obj.getParent().getID();
        if (parentMun == null) {
            switch (needsParent) {
                case 0: {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_CALC_MEM_PARENT, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), path, obj));
                    break;
                }
                case 1: {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_CALC_MEM_PARENT_ROOTED, FeedbackMessage.FeedbackSeverity.INFORMATION, obj.getName(), path, obj));
                }
            }
        } else {
            switch (needsParent) {
                case 0: 
                case 1: {
                    if (((FmMemberUniqueName)parentMun).isValid()) break;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_PARENT_MUN, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
                    break;
                }
                case 2: {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.IGNORED_CALC_MEAS_PARENT, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), path, obj));
                }
            }
        }
    }

    private void checkCalculatedMemberExpressionForCaptionAndBusinessKeyAttributes(FmCalculatedMember obj) {
        if (obj.getExpression() != null) {
            List<Object> expComponents = obj.getExpression().getComponents();
            for (Object ref : expComponents) {
                FmAttributeReference attributeRef;
                BaseObject parent;
                if (!(ref instanceof FmAttributeReference) || !((parent = (attributeRef = (FmAttributeReference)ref).getParent()) instanceof FmLevelReference)) continue;
                FmLevelReference parentLevelRef = (FmLevelReference)parent;
                FmLevel parentLevel = (FmLevel)parentLevelRef.getLevel();
                QueryItem businessKey = parentLevel.getLevelKeys().get(0);
                QueryItemBase caption = parentLevel.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption);
                if (caption != null && attributeRef.getAttribute().getInternal() == caption.getInternal()) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MEMBER_EXPRESSION_HAS_MEMBER_CAPTION, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj.getParent().getID(), attributeRef.getName(), parentLevel.getName(), (FmBaseObject)obj));
                }
                if (businessKey == null || attributeRef.getAttribute().getInternal() != businessKey.getInternal()) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MEMBER_EXPRESSION_HAS_BUSINESS_KEY, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj.getParent().getID(), attributeRef.getName(), parentLevel.getName(), (FmBaseObject)obj));
            }
        }
    }
}

