/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAggregateCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmAttributeReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevelReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamedSetFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AggregateCubeAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.DatasourceAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.DimensionAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.MeasureDimensionAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.NamedSetFolderAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalParameterMapAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationshipAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.AccessView;
import com.ibm.cognos.fmeng.fmmd.model.AggregateCube;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.NamedSetFolder;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskAnalyseObject;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubeAnalyser
extends AnalyserBase<FmCube> {
    private FmCube m_Obj;

    public CubeAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public CubeAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmCube cube) {
        AnalyserBase analyser;
        NamedSetFolder nsfolder;
        this.checkForInvalidROLAPCharacter(cube);
        this.setContextCube(cube);
        this.m_Obj = cube;
        DimensionAnalyser dimAnalyser = new DimensionAnalyser(this);
        MeasureDimensionAnalyser measAnalyser = new MeasureDimensionAnalyser(this);
        List<RelationalDimensionBase> dimensions = cube.getReferencedDimensions();
        this.checkForMeasureDimension(cube, dimensions);
        this.checkForRegularDimension(cube, dimensions);
        this.checkRelationships(cube, dimensions);
        this.checkDataSources(cube);
        this.checkFilterScope(dimensions);
        this.checkForFilterAndAggregates(cube, dimensions);
        this.checkForBadCubeName(cube);
        this.checkDimensionForBlobDataType(cube);
        RelationshipAnalyser relAnalyser = new RelationshipAnalyser(this);
        for (Relationship rel : cube.getRelationships()) {
            relAnalyser.analyse((FmRelationship)rel);
        }
        this.validateMultilingualNames(cube);
        this.checkForSecuredAttributesWithMemCaptionAndLevelUniqueKey();
        this.checkRoleBasedSecurityFiltersMDXExprInHier();
        this.checkForEmptySecurityViews();
        for (RelationalDimensionBase dim : dimensions) {
            if (dim instanceof FmMeasureDimension) {
                measAnalyser.analyse((FmMeasureDimension)dim);
            } else {
                dimAnalyser.analyse((FmRelationalDimension)dim);
            }
            this.checkCalculatedMemberExpressionForSecuredObjects(dim);
        }
        if (!cube.isAggregateCube() && (nsfolder = cube.getNamedSetFolder()) != null) {
            Iterator<AggregateCube> analyser2 = new NamedSetFolderAnalyser(this);
            ((AnalyserBase)((Object)analyser2)).analyse((FmNamedSetFolder)((FmNamedSetFolder)nsfolder));
        }
        for (Cube subCube : cube.getAggregateCubes()) {
            analyser = new CubeAnalyser(this);
            analyser.analyse((FmCube)subCube);
        }
        for (AggregateCube aggCube : cube.getAggregateCubes2()) {
            analyser = new AggregateCubeAnalyser(this);
            analyser.analyse((FmAggregateCube)aggCube);
        }
        RelationalParameterMapAnalyser analyser3 = new RelationalParameterMapAnalyser(this);
        for (ParameterMapBase pmap : cube.getSession().getProject().getParameterMaps()) {
            if (!(pmap instanceof RelationalParameterMap)) continue;
            analyser3.analyse((FmRelationalParameterMap)pmap);
        }
        this.setContextCube(null);
    }

    private void checkForFilterAndAggregates(FmCube cube, List<RelationalDimensionBase> dimensions) {
        if (cube.getAggregateCubes().size() == 0) {
            return;
        }
        StringBuilder dimensionNames = new StringBuilder();
        for (RelationalDimensionBase dim : dimensions) {
            if (dim.getAllFilters().size() <= 0) continue;
            dimensionNames.append("<div class=\"sub_list\">");
            dimensionNames.append(dim.getName());
            dimensionNames.append("</div>");
        }
        if (dimensionNames.length() > 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.FILTER_AND_AGGREGATE_CUBE, FeedbackMessage.FeedbackSeverity.WARNING, cube.getName(), dimensionNames.toString(), cube));
        }
    }

    private void checkFilterScope(List<RelationalDimensionBase> dimensions) {
        if (this.m_Config.getContext() == TaskAnalyseObject.AnalysisContext.publish && !this.m_Obj.isAggregateCube()) {
            ArrayList<RelationalObject> ros = new ArrayList<RelationalObject>();
            for (RelationalDimensionBase dim : dimensions) {
                ros.add(dim);
            }
            for (RelationalDimensionBase dim : dimensions) {
                for (RelationalFilter filter : dim.getAllFilters()) {
                    if (filter.isInScope(ros)) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.FILTER_OUT_OF_SCOPE, FeedbackMessage.FeedbackSeverity.WARNING, filter.getName(), dim.getName(), this.m_Obj.getName(), (FmBaseObject)((Object)filter)));
                }
            }
        }
    }

    private void checkForEmptySecurityViews() {
        List<AccessView> views = this.m_Obj.getAccessViews();
        for (AccessView view : views) {
            if (view.getAccessRules().size() != 0) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.EMPTY_SECURITY_VIEWS_IN_CUBE, FeedbackMessage.FeedbackSeverity.ERROR, ((FmBaseObject)this.m_Obj).getName(), view.getName(), this.m_Obj));
        }
    }

    private void checkCalculatedMemberExpressionForSecuredObjects(RelationalDimensionBase dim) {
        ArrayList<CalculatedMember> calcMems = new ArrayList<CalculatedMember>();
        if (dim instanceof FmMeasureDimension) {
            calcMems.addAll(((FmMeasureDimension)dim).getCalculatedMeasures());
        } else {
            for (RelationalHierarchy hier : ((FmRelationalDimension)dim).getAllHierarchies()) {
                calcMems.addAll(hier.getCalculatedMembers());
            }
        }
        for (CalculatedMember calcMem : calcMems) {
            Expression expr = calcMem.getExpression();
            if (expr == null) continue;
            this.validateForSecureObjects(expr, calcMem);
        }
    }

    private void checkRoleBasedSecurityFiltersMDXExprInHier() {
        for (AccessRule accessRule : this.getAllAccessRules()) {
            if (!accessRule.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.member) || !accessRule.getRuleStyle().equals((Object)AccessRule.RuleStyle.roleBased) || accessRule.getExpression() == null) continue;
            this.validateForSecureObjects(accessRule.getExpression(), accessRule);
        }
    }

    public void validateForSecureObjects(Expression expr, Object obj2) {
        for (Object obj : expr.getComponents()) {
            if (obj instanceof FmRelationalDimension || obj instanceof FmRelationalHierarchy || obj instanceof FmLevelReference || obj instanceof FmAttributeReference || obj instanceof FmQueryItem || obj instanceof FmCalculatedMember) {
                if (this.checkForSecuredDimensions((BaseObject)obj)) {
                    if (obj2 instanceof FmAccessRule) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_DIMENSION_IN_MEMBER_EXPR, FeedbackMessage.FeedbackSeverity.WARNING, ((FmBaseObject)obj).getName(), this.getAccessView((FmAccessRule)obj2), (FmBaseObject)obj));
                        break;
                    }
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_DIMENSION, FeedbackMessage.FeedbackSeverity.WARNING, ((FmBaseObject)obj).getName(), ((FmBaseObject)obj2).getName(), (FmBaseObject)obj));
                    break;
                }
                if ((obj instanceof FmAttributeReference || obj instanceof FmQueryItem) && this.checkForSecuredAttributes((BaseObject)obj)) {
                    if (obj2 instanceof FmAccessRule) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_ATTRIBUTE_EXP, FeedbackMessage.FeedbackSeverity.WARNING, ((FmBaseObject)obj).getName(), this.getAccessView((FmAccessRule)obj2), (FmBaseObject)obj));
                        break;
                    }
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_ATTRIBUTE_W, FeedbackMessage.FeedbackSeverity.WARNING, ((FmBaseObject)obj).getName(), ((FmBaseObject)obj2).getName(), (FmBaseObject)obj));
                    break;
                }
            }
            if (!(obj instanceof FmMeasure) || !this.checkForSecuredMeasure((BaseObject)obj)) continue;
            if (obj2 instanceof FmAccessRule) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_MEASURE_EXP, FeedbackMessage.FeedbackSeverity.WARNING, ((FmBaseObject)obj).getName(), this.getAccessView((FmAccessRule)obj2), (FmBaseObject)obj));
                break;
            }
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_MEASURE, FeedbackMessage.FeedbackSeverity.WARNING, ((FmBaseObject)obj).getName(), ((FmBaseObject)obj2).getName(), (FmBaseObject)obj));
            break;
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean checkForSecuredDimensions(BaseObject obj) {
        if (!(obj instanceof FmCalculatedMember)) ** GOTO lbl7
        if (((FmCalculatedMember)obj).getRelationalParent() instanceof FmRelationalDimension) {
            obj = ((FmCalculatedMember)obj).getRelationalParent();
        } else {
            return false;
lbl-1000:
            // 1 sources

            {
                obj = obj.getParent();
lbl7:
                // 2 sources

                ** while (!(obj instanceof FmRelationalDimension) && obj != null)
            }
        }
lbl8:
        // 2 sources

        if (obj == null) {
            return false;
        }
        dim = (FmRelationalDimension)obj;
        for (AccessRule accessRule : this.getAllAccessRules()) {
            if (accessRule.getDimension() == null || !accessRule.getDimension().equals(dim)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForSecuredMeasure(BaseObject obj) {
        for (AccessRule accessRule : this.getAllAccessRules()) {
            if (!accessRule.getRestrictObjectType().equals((Object)AccessRule.RestrictObjectType.measure) || accessRule.getMeasure() == null || !accessRule.getMeasure().equals((FmMeasure)obj)) continue;
            return true;
        }
        return false;
    }

    private boolean checkForSecuredAttributes(BaseObject obj) {
        QueryItem uniqueLevelKey = null;
        QueryItem qi = null;
        List<QueryItem> levelKeys = null;
        qi = obj instanceof FmQueryItem ? (FmQueryItem)obj : ((FmAttributeReference)obj).getAttribute();
        for (AccessRule accessRule : this.getAllAccessRules()) {
            if (accessRule.getQueryItem() == null || !accessRule.getQueryItem().equals(qi)) continue;
            if (accessRule.getQueryItem().getLevel() != null) {
                levelKeys = accessRule.getQueryItem().getLevel().getLevelKeys();
            } else if (accessRule.getQueryItem().getHierarchy() != null) {
                levelKeys = accessRule.getQueryItem().getHierarchy().getLevelKeys();
            } else {
                FmMDException.ASSERT(false, "Found query item " + qi.getName() + " that doesn't belong to a level or hierarchy.");
            }
            if (levelKeys.isEmpty() || (uniqueLevelKey = levelKeys.get(0)).equals(accessRule.getQueryItem())) continue;
            if (qi.getRoles().isEmpty()) {
                return true;
            }
            for (Role role : qi.getRoles()) {
                if (role.getDefaultRole().equals((Object)Role.EDefaultRoles.kRoleMemberCaption)) continue;
                return true;
            }
        }
        return false;
    }

    private void checkForSecuredAttributesWithMemCaptionAndLevelUniqueKey() {
        QueryItem uniqueLevelKey = null;
        List<QueryItem> levelKeys = null;
        block0: for (AccessRule accessRule : this.getAllAccessRules()) {
            if (accessRule.getQueryItem() == null) continue;
            if (accessRule.getQueryItem().getLevel() != null) {
                levelKeys = accessRule.getQueryItem().getLevel().getLevelKeys();
            } else if (accessRule.getQueryItem().getHierarchy() != null) {
                levelKeys = accessRule.getQueryItem().getHierarchy().getLevelKeys();
            } else {
                FmMDException.ASSERT(false, "Found query item " + accessRule.getQueryItem().getName() + " that doesn't belong to a level or hierarchy.");
            }
            if (!levelKeys.isEmpty() && (uniqueLevelKey = levelKeys.get(0)).equals(accessRule.getQueryItem())) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_ATTRIBUTE, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getQueryItem().getName(), this.getAccessView(accessRule), this.m_Obj));
                break;
            }
            for (Role role : accessRule.getQueryItem().getRoles()) {
                if (!role.getDefaultRole().equals((Object)Role.EDefaultRoles.kRoleMemberCaption)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SECURED_ATTRIBUTE, FeedbackMessage.FeedbackSeverity.ERROR, accessRule.getQueryItem().getName(), this.getAccessView(accessRule), this.m_Obj));
                continue block0;
            }
        }
    }

    private String getAccessView(AccessRule accessRule) {
        List<AccessView> accessViews = this.m_Obj.getAccessViews();
        if (!accessViews.isEmpty()) {
            for (AccessView accessView : accessViews) {
                for (AccessRule avAccessRule : accessView.getAccessRules()) {
                    if (!avAccessRule.equals(accessRule)) continue;
                    return accessView.getName();
                }
            }
        }
        return null;
    }

    public List<AccessRule> getAllAccessRules() {
        HashSet<AccessRule> hs = new HashSet<AccessRule>();
        List<AccessView> accessViews = this.m_Obj.getAccessViews();
        if (!accessViews.isEmpty()) {
            for (AccessView accessView : accessViews) {
                for (AccessRule accessRule : accessView.getAccessRules()) {
                    hs.add(accessRule);
                }
            }
        }
        ArrayList<AccessRule> accessRules = new ArrayList<AccessRule>(hs);
        return accessRules;
    }

    private void checkDataSources(FmCube cube) {
        HashSet<DataSource> dses = new HashSet<DataSource>();
        for (RelationalDimensionBase dim : cube.getAllReferencedDimensions()) {
            for (Table table : dim.getTables()) {
                dses.add(table.getDataSource());
            }
        }
        DatasourceAnalyser analyser = new DatasourceAnalyser(this);
        for (DataSource ds : dses) {
            analyser.analyse((FmDataSource)ds);
        }
    }

    private void checkRelationships(FmCube cube, List<RelationalDimensionBase> dimensions) {
        FmRelationalDimensionBase dim;
        FmMeasureDimension measDim = (FmMeasureDimension)cube.getMeasureDimension();
        List<Relationship> allRelationships = cube.getRelationships();
        if (measDim != null) {
            for (RelationalDimensionBase foo : dimensions) {
                dim = (FmRelationalDimensionBase)foo;
                if (dim.equals(measDim)) continue;
                ArrayList<FmRelationship> dimRelationships = new ArrayList<FmRelationship>();
                for (Relationship someRel : allRelationships) {
                    FmRelationship rel = (FmRelationship)someRel;
                    FmRelationalDimensionBase left = (FmRelationalDimensionBase)rel.getLeftEnd();
                    FmRelationalDimensionBase right = (FmRelationalDimensionBase)rel.getRightEnd();
                    if (left.equals(dim) && right.equals(measDim)) {
                        dimRelationships.add(rel);
                    }
                    if (!left.equals(measDim) || !right.equals(dim)) continue;
                    dimRelationships.add(rel);
                }
                String measDimPath = measDim.getParent().getID();
                String dimPath = dim.getParent().getID();
                if (dimRelationships.size() < 1) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNJOINED_DIMENSIONS, FeedbackMessage.FeedbackSeverity.ERROR, dim.getName(), measDim.getName(), dimPath, measDimPath, cube.getName(), dim, measDim));
                    continue;
                }
                if (dimRelationships.size() <= 1) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_JOINED_DIMENSIONS, FeedbackMessage.FeedbackSeverity.ERROR, dim.getName(), measDim.getName(), dimPath, measDimPath, cube.getName(), dim, measDim));
            }
        }
        for (RelationalDimensionBase foo : dimensions) {
            dim = (FmRelationalDimensionBase)foo;
            if (dim.equals(measDim)) continue;
            for (RelationalDimensionBase foo2 : dimensions) {
                FmRelationalDimensionBase dim2 = (FmRelationalDimensionBase)foo2;
                if (dim2.equals(measDim) || dim2.equals(dim)) continue;
                for (Relationship someRel : allRelationships) {
                    FmRelationship rel = (FmRelationship)someRel;
                    FmRelationalDimensionBase left = (FmRelationalDimensionBase)rel.getLeftEnd();
                    FmRelationalDimensionBase right = (FmRelationalDimensionBase)rel.getRightEnd();
                    if (left.equals(dim) && right.equals(dim2)) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.BAD_DIMENSION_JOIN, FeedbackMessage.FeedbackSeverity.ERROR, rel.getName(), cube.getName(), rel));
                    }
                    if (!left.equals(dim2) || !right.equals(dim)) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.BAD_DIMENSION_JOIN, FeedbackMessage.FeedbackSeverity.ERROR, rel.getName(), cube.getName(), rel));
                }
            }
        }
    }

    private void checkForRegularDimension(FmCube cube, List<RelationalDimensionBase> dimensions) {
        for (RelationalDimensionBase dim : dimensions) {
            if (!(dim instanceof FmRelationalDimension)) continue;
            return;
        }
        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_REGULAR_DIMENSIONS_FOUND, FeedbackMessage.FeedbackSeverity.ERROR, cube.getName(), cube));
    }

    private void checkForMeasureDimension(FmCube cube, List<RelationalDimensionBase> dimensions) {
        MeasureDimension measDim = cube.getMeasureDimension();
        if (measDim != null) {
            return;
        }
        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_MEASURE_DIMENSIONS_FOUND, FeedbackMessage.FeedbackSeverity.ERROR, cube.getName(), cube));
    }

    protected void checkDimensionForBlobDataType(FmCube cube) {
        for (RelationalDimensionBase dimension1 : cube.getReferencedDimensions()) {
            if (!(dimension1 instanceof FmRelationalDimension)) continue;
            for (QueryItem qi : dimension1.getAllQueryItems()) {
                if (!FmDatatype.isBlobType(qi.getDatatype()).booleanValue()) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_BLOB_DT_FOR_DIM_IN_CUBES, FeedbackMessage.FeedbackSeverity.ERROR, dimension1.getName(), cube.getName(), qi.getName(), (FmBaseObject)cube));
            }
        }
    }
}

