/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.HierarchyAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.LevelAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionAnalyser
extends RelationalAnalyserBase<FmRelationalDimension> {
    public DimensionAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public DimensionAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmRelationalDimension dimension) {
        this.checkForInvalidROLAPCharacter(dimension);
        this.init(dimension);
        this.checkJoinAssociations();
        this.checkForUnjoinedTables();
        this.checkForMultipleJoins();
        this.checkForCircularJoins();
        this.checkAmbiguousJoinPath();
        this.validateMultilingualNames(dimension);
        this.checkForDuplicateAttributes();
        this.checkForMultipleJoinsWithOuterJoin();
        LevelAnalyser lvlAnalyser = new LevelAnalyser(this);
        List<Level> allLevels = dimension.getAllLevels();
        HashSet<Object> usedLevels = new HashSet<Object>();
        List<RelationalHierarchy> hierarchies = dimension.getAllHierarchies();
        if (hierarchies.size() > 0) {
            HierarchyAnalyser hierAnalyser = new HierarchyAnalyser(this);
            for (RelationalHierarchy hier : hierarchies) {
                hierAnalyser.analyse((FmRelationalHierarchy)hier);
                for (LevelReference levelRef : hier.getLevelReferences()) {
                    usedLevels.add(levelRef.getLevel().getInternal());
                }
                Level allLev = hier.getAllLevel();
                if (allLev == null) continue;
                usedLevels.add(allLev.getInternal());
            }
        } else {
            String path = dimension.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_HIERARCHIES, FeedbackMessage.FeedbackSeverity.ERROR, dimension.getName(), path, dimension));
        }
        for (Level level : allLevels) {
            if (usedLevels.contains(level.getInternal()) || dimension.isRollupDimension()) {
                lvlAnalyser.analyse((FmLevel)level);
                continue;
            }
            String path = level.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNUSED_LEVEL, FeedbackMessage.FeedbackSeverity.WARNING, level.getName(), path, dimension));
        }
        this.checkForWrongLevelTypes(dimension, allLevels);
        this.checkDefaultHierarchyForCubingServicesCompatibility(dimension);
        this.checkRefrencedTablesAndColumns();
        this.checkRelationalFilters();
    }

    private void checkForDuplicateAttributes() {
        HashMap hm = new HashMap();
        List<QueryItem> qIs = this.m_RelationalObject.getAllQueryItems();
        ArrayList<Level> levels = new ArrayList<Level>();
        StringBuilder rlevel = new StringBuilder();
        for (QueryItem queryItem : qIs) {
            Level level;
            if (!hm.containsKey(queryItem.getName()) && queryItem.getParent() instanceof Level) {
                level = (Level)queryItem.getParent();
                levels.add(level);
                hm.put(queryItem.getName(), levels);
                levels = new ArrayList();
                continue;
            }
            if (!(queryItem.getParent() instanceof Level)) continue;
            level = (Level)queryItem.getParent();
            levels.addAll((Collection)hm.get(queryItem.getName()));
            levels.add(level);
            hm.put(queryItem.getName(), levels);
            levels = new ArrayList();
        }
        for (Map.Entry entry : hm.entrySet()) {
            List repeatinglevels = (List)entry.getValue();
            if (repeatinglevels.size() <= 1) continue;
            for (Level repLevels : repeatinglevels) {
                rlevel.append(repLevels.getName());
                rlevel.append(", ");
            }
            rlevel.deleteCharAt(rlevel.length() - 2);
            rlevel.deleteCharAt(rlevel.length() - 1);
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DUPLICATE_ATTRIBUTES_IN_DIMENSION, FeedbackMessage.FeedbackSeverity.ERROR, this.m_RelationalObject.getName(), (String)entry.getKey(), rlevel.toString(), (FmBaseObject)this.m_RelationalObject));
            rlevel = new StringBuilder();
        }
    }

    private void checkForWrongLevelTypes(FmRelationalDimension dimension, List<Level> allLevels) {
        if (dimension.getDimensionStyle().equals((Object)DimensionBase.DimensionStyle.regular) && allLevels != null) {
            for (Level level : allLevels) {
                if (level.isAllLevel() || !level.getLevelStyle().isTimeLevel()) continue;
                String levelType = FmMessage.render("BMT_LVL_" + level.getLevelStyle().toString(), level.getSession().getActiveLocale());
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.FOR_REGULAR_DIMENSION_LEVELS_TYPE_IS_WRONG, FeedbackMessage.FeedbackSeverity.ERROR, this.m_RelationalObject.getName(), level.getName(), levelType, (FmBaseObject)this.m_RelationalObject));
            }
        }
    }

    private void checkDefaultHierarchyForCubingServicesCompatibility(RelationalDimension dim) {
        if (this.isCubingServicesCompatible()) {
            RelationalHierarchy defaultHier = dim.getDefaultHierarchy();
            for (RelationalHierarchy hier : dim.getAllHierarchies()) {
                if (hier.equals(defaultHier) || !hier.getName().equals(dim.getName())) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.BAD_HIERARCHY_NAME_WITH_COMPATIBILITY, FeedbackMessage.FeedbackSeverity.ERROR, hier.getName(), this.getContextCube().getName(), dim.getName(), (FmBaseObject)((FmRelationalHierarchy)hier)));
            }
        }
    }
}

