/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmAccessRule;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelativeTimeMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AccessRuleAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.CalculatedMemberAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelativeTimeAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.AccessRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.LevelStyle;
import com.ibm.cognos.fmeng.fmmd.model.MemberUniqueName;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelativeTimeMember;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyAnalyser
extends AnalyserBase<FmRelationalHierarchy> {
    private List<Level> m_Levels;
    private FmRelationalHierarchy m_Obj;
    protected FmPhysicalDefinition m_PhysDef;
    protected FmRelationalObject m_RelationalObject;

    public HierarchyAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public HierarchyAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmRelationalHierarchy obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.m_Obj = obj;
        RelationalDimension dim = obj.getDimension();
        boolean isRollup = false;
        String path = obj.getParent().getID();
        FmMDException.ASSERT(dim instanceof RelationalDimension, "Hierarchy does not belong to the correct kind of dimension.");
        RelationalDimension relDim = dim;
        isRollup = relDim.isRollupDimension();
        if (obj.getParentChild()) {
            List<QueryItem> queryItems = this.m_Obj.getAllQueryItems();
            if (queryItems.size() == 0) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PARENT_CHILD_HIER_HAS_NO_QUERY_ITEMS, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), path, this.m_Obj));
            } else {
                this.checkForParentChildItems(isRollup);
                this.checkForLevelKeyInTableWithOuterJoin();
                if (!isRollup) {
                    this.checkRole(Role.EDefaultRoles.kRoleMemberCaption, FeedbackMessage.FeedbackCode.NO_MEMBER_CAPTION, FeedbackMessage.FeedbackSeverity.ERROR);
                }
                QueryItemAnalyser queryItemAnalyser = new QueryItemAnalyser(this);
                if (queryItems.size() > 0) {
                    for (QueryItem queryItem : queryItems) {
                        queryItemAnalyser.analyse((FmQueryItem)queryItem);
                    }
                }
            }
        } else {
            this.m_Levels = new ArrayList<Level>();
            Level allLev = obj.getAllLevel();
            if (allLev != null) {
                this.m_Levels.add(allLev);
            }
            for (LevelReference levelRef : obj.getLevelReferences()) {
                this.m_Levels.add(levelRef.getLevel());
            }
            this.checkForNoLevels();
            this.checkRootMemberNameAgainstLevels();
            if (!isRollup) {
                this.checkForOneAllLevel();
                this.checkForIgnoredRootMember();
                this.checkForBadAllLevel();
            }
            this.checkForLevelRefOrder(this.m_Levels, obj.getParent());
            this.validateTimeLevelsOrder();
            this.validateUniqueTimeBasedLevels();
            this.validateHierarchyHasRelativeTimeMembers();
            this.validateRelativeTimeMembers();
            this.checkRegularDimHasRelativeTimeMembers(relDim);
            this.validateMultilingualNames(obj);
        }
        this.validateTimeHierarchyAndSecurityRules(dim);
        AccessRuleAnalyser accessAnalyser = new AccessRuleAnalyser(this);
        for (AccessRule accessRule : this.m_Obj.getAccessRules()) {
            accessAnalyser.analyse((FmAccessRule)accessRule);
        }
        if (!isRollup) {
            CalculatedMemberAnalyser calcAnalyser = new CalculatedMemberAnalyser(this);
            for (CalculatedMember calculatedMember : obj.getCalculatedMembers()) {
                calcAnalyser.analyse((FmCalculatedMember)calculatedMember);
            }
            MemberUniqueName memberUniqueName = obj.getDefaultMemberUniqueName();
            if (memberUniqueName != null && !((FmMemberUniqueName)memberUniqueName).isValid()) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_DEFAULT_MEMBER_UNIQUE_NAME, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
            }
        }
    }

    private void checkRegularDimHasRelativeTimeMembers(RelationalDimension dim) {
        if (dim.getDimensionStyle().equals((Object)DimensionBase.DimensionStyle.regular) && this.m_Obj.getHasRelativeTimeMembers()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.REGULAR_DIM_WITH_HAS_HAS_REL_TIME_MEM, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), dim.getName(), this.m_Obj));
        }
    }

    private void checkForLevelKeyInTableWithOuterJoin() {
        QueryItemBase memberCaption;
        ArrayList<QueryItemBase> invalidQIs = new ArrayList<QueryItemBase>();
        QueryItem item = this.m_Obj.getChildItem();
        if (item != null) {
            invalidQIs.add(item);
        }
        if ((item = this.m_Obj.getParentItem()) != null) {
            invalidQIs.add(item);
        }
        if ((memberCaption = this.m_Obj.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption)) != null) {
            invalidQIs.add(memberCaption);
        }
        this.checkForMemberDefinitionFromOptionalTable(invalidQIs, (FmRelationalDimension)this.m_Obj.getDimension(), this.m_Obj);
    }

    private void validateTimeHierarchyAndSecurityRules(DimensionBase dim) {
        boolean found = false;
        List<AccessRule> accessRules = this.m_Obj.getAccessRules();
        if (!accessRules.isEmpty() && this.m_Obj.getHasRelativeTimeMembers()) {
            for (AccessRule accessRule : accessRules) {
                if (accessRule.getAllAccess() || found) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.TIME_HEIR_WITH_ACCESS_RULES, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), dim.getID(), this.m_Obj));
                found = true;
            }
        }
    }

    private void validateHierarchyHasRelativeTimeMembers() {
        for (Level level : this.m_Levels) {
            if (level.isTimeLevel() || !this.m_Obj.getHasRelativeTimeMembers() || level.isAllLevel()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVELS_TYPE_IS_WRONG, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), level.getName(), this.m_Obj));
        }
    }

    private void validateUniqueTimeBasedLevels() {
        HashMap<LevelStyle, Level> levelStyles = new HashMap<LevelStyle, Level>();
        HashMap<Integer, Level> levelOrdinals = new HashMap<Integer, Level>();
        for (Level level : this.m_Levels) {
            LevelStyle lvlStyle = level.getLevelStyle();
            if (!lvlStyle.isUnique()) continue;
            if (levelStyles.containsKey((Object)lvlStyle)) {
                String levelType = FmMessage.render("BMT_LVL_" + lvlStyle.toString(), level.getSession().getActiveLocale());
                Level otherLevel = (Level)levelStyles.get((Object)lvlStyle);
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DUPLICATE_TIME_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, level.getName(), levelType, otherLevel.getName(), this.m_Obj.getID(), (FmBaseObject)this.m_Obj));
                return;
            }
            if (lvlStyle == LevelStyle.time_semesters && levelStyles.containsKey((Object)LevelStyle.time_trimesters)) {
                Level otherLevel = (Level)levelStyles.get((Object)LevelStyle.time_trimesters);
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_TIME_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, level.getName(), otherLevel.getName(), this.m_Obj.getID(), (FmBaseObject)this.m_Obj));
                return;
            }
            if (lvlStyle == LevelStyle.time_trimesters && levelStyles.containsKey((Object)LevelStyle.time_semesters)) {
                Level otherLevel = (Level)levelStyles.get((Object)LevelStyle.time_semesters);
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_TIME_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, level.getName(), otherLevel.getName(), this.m_Obj.getID(), (FmBaseObject)this.m_Obj));
                return;
            }
            levelStyles.put(lvlStyle, level);
            if (levelOrdinals.containsKey(lvlStyle.getOrder())) {
                String levelType = FmMessage.render("BMT_LVL_" + lvlStyle.toString(), level.getSession().getActiveLocale());
                Level otherLevel = (Level)levelOrdinals.get(lvlStyle.getOrder());
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.EQUIVALENT_TIME_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, level.getName(), levelType, otherLevel.getName(), this.m_Obj.getID(), (FmBaseObject)this.m_Obj));
                return;
            }
            levelOrdinals.put(lvlStyle.getOrder(), level);
        }
    }

    private void validateTimeLevelsOrder() {
        int priorOrder = -1;
        for (Level level : this.m_Levels) {
            LevelStyle lvlStyle = level.getLevelStyle();
            if (!lvlStyle.isUnique()) continue;
            if (priorOrder > lvlStyle.getOrder()) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.TIME_LEVELS_ORDER_IS_WRONG, FeedbackMessage.FeedbackSeverity.ERROR, level.getName(), this.m_Obj.getID(), this.m_Obj));
                continue;
            }
            priorOrder = lvlStyle.getOrder();
        }
    }

    private void validateRelativeTimeMembers() {
        List<RelativeTimeMember> relativeTimeMembers = this.m_Obj.getRelativeTimeMembers();
        if (relativeTimeMembers.size() > 0) {
            RelativeTimeAnalyser rtAnalyser = new RelativeTimeAnalyser(this);
            for (RelativeTimeMember rtMember : relativeTimeMembers) {
                rtAnalyser.analyse((FmRelativeTimeMember)rtMember);
            }
        }
    }

    private void checkRootMemberNameAgainstLevels() {
        if (!this.m_Obj.isMultiRoot()) {
            for (Level level : this.m_Levels) {
                String rootMember = this.m_Obj.getRootMember();
                if (rootMember == null || !this.m_Obj.getRootMember().equals(level.getName())) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SAME_LEVEL_AND_ROOT_MEMBER_NAME, FeedbackMessage.FeedbackSeverity.ERROR, level.getName(), this.m_Obj.getID(), this.m_Obj));
            }
        }
    }

    private void checkForLevelRefOrder(List<Level> levels, BaseObject obj) {
        this.m_RelationalObject = (FmRelationalObject)obj;
        this.m_PhysDef = this.m_RelationalObject.getPhysicalDefinition();
        ArrayList<Level> orderedLevels = new ArrayList<Level>(levels.size());
        ArrayList<Level> unMappedLevels = new ArrayList<Level>();
        ArrayList<Level> mappedLevels = new ArrayList<Level>();
        ArrayList<QueryItemMapping> mappings = new ArrayList<QueryItemMapping>();
        HashMap<Integer, List<Table>> hm = new HashMap<Integer, List<Table>>();
        List<Table> tables = this.m_PhysDef.getTables();
        boolean found = false;
        if (tables.size() > 1) {
            List<Table> sortedTables = new ArrayList<Table>();
            hm.putAll(this.m_PhysDef.getSortedTables(tables, sortedTables, hm));
            List leafTables = (List)hm.get(0);
            if (!this.validateLeafTables(leafTables, this.m_PhysDef)) {
                StringBuffer tmp = new StringBuffer();
                for (Table leafTable : leafTables) {
                    if (tmp.length() != 0) {
                        tmp.append(", ");
                    }
                    tmp.append(leafTable.getTableName());
                }
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_HIERARCHY_JOIN_CARDINALITY, FeedbackMessage.FeedbackSeverity.WARNING, this.m_Obj.getName(), tmp.toString(), this.m_Obj));
            }
            if (hm.size() > 1) {
                int key = 0;
                while (key < hm.size()) {
                    sortedTables = (List)hm.get(key);
                    for (Table orderTable : sortedTables) {
                        mappings.addAll(this.m_PhysDef.getQueryItemMappings(orderTable));
                    }
                    for (Level level : levels) {
                        if (level.isAllLevel() && !found) {
                            orderedLevels.add(level);
                            found = true;
                            continue;
                        }
                        if (level.getLevelKeys().isEmpty()) continue;
                        QueryItemBase item = level.getLevelKeys().get(0);
                        QueryItemMapping levelMapping = this.m_PhysDef.findMapping(item);
                        if (levelMapping == null && !unMappedLevels.contains(level)) {
                            unMappedLevels.add(unMappedLevels.size(), level);
                        }
                        for (QueryItemMapping mapping : mappings) {
                            if (!mapping.equals(levelMapping)) continue;
                            mappedLevels.add(mappedLevels.size(), level);
                        }
                    }
                    if (this.m_Obj.isMultiRoot()) {
                        orderedLevels.addAll(0, mappedLevels);
                    } else {
                        orderedLevels.addAll(1, mappedLevels);
                    }
                    mappedLevels = new ArrayList();
                    mappings = new ArrayList();
                    ++key;
                }
                if (!unMappedLevels.isEmpty()) {
                    if (this.m_Obj.isMultiRoot()) {
                        orderedLevels.addAll(0, unMappedLevels);
                    } else {
                        orderedLevels.addAll(1, unMappedLevels);
                    }
                    unMappedLevels = new ArrayList();
                }
                for (Level level : levels) {
                    if (orderedLevels.contains(level)) continue;
                    orderedLevels.add(levels.indexOf(level), level);
                }
                if (!unMappedLevels.isEmpty()) {
                    orderedLevels.addAll(1, unMappedLevels);
                }
            }
            if (levels.size() == orderedLevels.size()) {
                int k = 0;
                while (k < levels.size()) {
                    if (!levels.get(k).equals(orderedLevels.get(k))) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVELS_ORDER_IS_WRONG, FeedbackMessage.FeedbackSeverity.WARNING, levels.get(k).getName(), this.m_Obj.getID(), this.m_Obj));
                    }
                    ++k;
                }
            }
        }
    }

    private void checkForParentChildItems(boolean isRollup) {
        QueryItem childItem;
        String path = this.m_Obj.getParent().getID();
        QueryItem parentItem = this.m_Obj.getParentItem();
        if (parentItem == null && !isRollup) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PARENT_CHILD_HIER_HAS_NO_PARENT_ITEM, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), path, this.m_Obj));
        }
        if ((childItem = this.m_Obj.getChildItem()) == null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PARENT_CHILD_HIER_HAS_NO_CHILD_ITEM, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), path, this.m_Obj));
        }
        if (parentItem != null && childItem != null && parentItem.equals(childItem)) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PARENT_CHILD_HIER_SAME_ITEM, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), path, this.m_Obj));
        }
    }

    private void checkRole(Role.EDefaultRoles role, FeedbackMessage.FeedbackCode code, FeedbackMessage.FeedbackSeverity error) {
        QueryItemBase item = this.m_Obj.getItemWithRole(role);
        String path = this.m_Obj.getParent().getID();
        if (item == null) {
            this.addMessage(new FmFeedbackMessage(code, error, this.m_Obj.getName(), path, this.m_Obj));
        }
    }

    private void checkForBadAllLevel() {
        String path = this.m_Obj.getParent().getID();
        boolean hasAllLevel = false;
        if (this.m_Levels.size() <= 1) {
            return;
        }
        Level level = this.m_Levels.get(0);
        if (level.isAllLevel()) {
            hasAllLevel = true;
        }
        int i = 1;
        while (i < this.m_Levels.size()) {
            Level someLevel = this.m_Levels.get(i);
            if (someLevel.isAllLevel()) {
                if (hasAllLevel) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.HIERARCHY_MULTIPLE_ALL_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, someLevel.getName(), this.m_Obj.getName(), path, (FmBaseObject)this.m_Obj, (FmBaseObject)((FmLevel)someLevel)));
                } else {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.HIERARCHY_BAD_ALL_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, someLevel.getName(), this.m_Obj.getName(), path, (FmBaseObject)this.m_Obj, (FmBaseObject)((FmLevel)someLevel)));
                    hasAllLevel = true;
                }
            }
            ++i;
        }
    }

    private void checkForOneAllLevel() {
        if (this.m_Levels.size() == 1) {
            String path = this.m_Obj.getParent().getID();
            Level level = this.m_Levels.get(0);
            if (level.isAllLevel()) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.HIERARCHY_ONE_ALL_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), path, this.m_Obj));
            }
        }
    }

    private void checkForNoLevels() {
        if (this.m_Levels.size() == 0) {
            String path = this.m_Obj.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.HIERARCHY_NO_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, this.m_Obj.getName(), path, this.m_Obj));
        }
    }

    private void checkForIgnoredRootMember() {
        String rootMember;
        boolean hasAllLevel = false;
        for (Level level : this.m_Levels) {
            if (!level.isAllLevel()) continue;
            hasAllLevel = true;
            break;
        }
        if (!hasAllLevel && (rootMember = this.m_Obj.getRootMember()) != null && !"".equals(rootMember)) {
            String path = this.m_Obj.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.IGNORED_ROOT_MEMBER, FeedbackMessage.FeedbackSeverity.WARNING, this.m_Obj.getName(), path, this.m_Obj));
        }
    }

    private boolean validateLeafTables(List<Table> leafTables, FmPhysicalDefinition physicalDefinition) {
        if (leafTables == null || leafTables.size() <= 1) {
            return true;
        }
        Table leafTable = leafTables.get(0);
        ArrayList<Table> cluster = new ArrayList<Table>();
        cluster.add(leafTable);
        this.find1to1joinedTables(leafTable, leafTables, cluster, physicalDefinition);
        return cluster.size() == leafTables.size();
    }

    private void find1to1joinedTables(Table sourceTable, List<Table> leafTables, List<Table> cluster, FmPhysicalDefinition physicalDefinition) {
        List<Join> joins = physicalDefinition.getJoins(sourceTable);
        for (Join join : joins) {
            if (join.getLeftMaxcard() != Cardinality.ECardinality.one || join.getRightMaxcard() != Cardinality.ECardinality.one) continue;
            Table otherTable = join.getLeftTable();
            if (otherTable.equals(sourceTable)) {
                otherTable = join.getRightTable();
            }
            if (!leafTables.contains(otherTable) || cluster.contains(otherTable)) continue;
            cluster.add(otherTable);
            this.find1to1joinedTables(otherTable, leafTables, cluster, physicalDefinition);
        }
    }
}

