/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelAnalyser
extends AnalyserBase<FmLevel> {
    public LevelAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public LevelAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmLevel obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.checkForLevelKey(obj);
        this.checkForMemberCaption(obj);
        this.checkForLevelKeyInTableWithOuterJoin(obj);
        DimensionBase dim = obj.getDimension();
        boolean isRollup = false;
        if (dim instanceof RelationalDimension) {
            RelationalDimension relDim = (RelationalDimension)dim;
            isRollup = relDim.isRollupDimension();
        }
        List<QueryItem> queryItems = obj.getAllQueryItems();
        if (!obj.isAllLevel()) {
            if (queryItems.size() == 0) {
                String path = obj.getParent().getID();
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVEL_HAS_NO_QUERY_ITEMS, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
            } else {
                if (!isRollup) {
                    this.checkRole(obj, Role.EDefaultRoles.kRoleMemberCaption, FeedbackMessage.FeedbackCode.NO_MEMBER_CAPTION, FeedbackMessage.FeedbackSeverity.ERROR);
                }
                QueryItemAnalyser queryItemAnalyser = new QueryItemAnalyser(this);
                if (queryItems.size() > 0) {
                    for (QueryItem queryItem : queryItems) {
                        queryItemAnalyser.analyse((FmQueryItem)queryItem);
                    }
                }
            }
        }
        this.validateMultilingualNames(obj);
    }

    private void checkForLevelKeyInTableWithOuterJoin(FmLevel obj) {
        DimensionBase dim;
        List<QueryItem> levelKeys = obj.getLevelKeys();
        if (levelKeys.size() == 0) {
            return;
        }
        ArrayList<QueryItemBase> invalidQIs = new ArrayList<QueryItemBase>();
        for (QueryItem levelKey : levelKeys) {
            invalidQIs.add(levelKey);
        }
        QueryItemBase memberCaption = obj.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption);
        if (memberCaption != null) {
            invalidQIs.add(memberCaption);
        }
        if (!((dim = obj.getDimension()) instanceof RelationalDimension)) {
            return;
        }
        this.checkForMemberDefinitionFromOptionalTable(invalidQIs, (FmRelationalDimension)dim, obj);
    }

    private void checkRole(FmLevel obj, Role.EDefaultRoles role, FeedbackMessage.FeedbackCode code, FeedbackMessage.FeedbackSeverity error) {
        QueryItemBase item = obj.getItemWithRole(role);
        if (item == null) {
            String path = obj.getParent().getID();
            this.addMessage(new FmFeedbackMessage(code, error, obj.getName(), path, obj));
        }
    }

    private void checkForLevelKey(FmLevel obj) {
        if (!obj.isAllLevel()) {
            List<QueryItem> keys = obj.getLevelKeys();
            if (keys.size() == 0) {
                String path = obj.getParent().getID();
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_LEVEL_KEY, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
                return;
            }
            for (QueryItem key : keys) {
                if (!key.getHidden()) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.HIDDEN_LEVEL_KEY, FeedbackMessage.FeedbackSeverity.WARNING, key.getName(), obj.getName(), key.getName(), (FmBaseObject)obj));
            }
        }
    }

    private void checkForMemberCaption(FmLevel obj) {
        QueryItemBase memberCaption;
        if (!obj.isAllLevel() && (memberCaption = obj.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption)) != null && memberCaption.getHidden()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.HIDDEN_MEMBER_CAPTION_KEY, FeedbackMessage.FeedbackSeverity.WARNING, memberCaption.getName(), obj.getName(), memberCaption.getName(), (FmBaseObject)obj));
        }
    }
}

