/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemBaseAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.model.AggregateRule;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.SemiAggregate;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.metadata.MdDatabase;
import com.ibm.cognos.fmeng.metadata.MdTable;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureAnalyser
extends QueryItemBaseAnalyserBase<FmMeasure> {
    public MeasureAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public MeasureAnalyser(AnalyserConfig config) {
        super(config);
    }

    private ColumnReference extractSideInfo(Object object) {
        if (object instanceof ColumnReference) {
            ColumnReference cRef = (ColumnReference)object;
            return cRef;
        }
        FmMDException.ASSERT(false, "Unexpected query item in relationship");
        return null;
    }

    private boolean matchConvergentLevelCandidate(ColumnReference ref, Level level) {
        for (QueryItem item : level.getAllQueryItems()) {
            Table table;
            QueryItemMapping mapping = ref.getRelationalObject().findMapping(item);
            if (mapping == null || !(table = mapping.getTable()).getName().equals(ref.getTableName()) || !table.getDataSource().equals(ref.getDataSource()) || !mapping.getColumnName().equals(ref.getColumnName())) continue;
            return true;
        }
        return false;
    }

    private boolean isReferencedInHierarchies(RelationalDimension objRegDim, Level level) {
        List hierarchies = objRegDim.getAllHierarchies();
        for (RelationalHierarchy h : hierarchies) {
            if (!h.references(level)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doAnalysis(FmMeasure obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.checkItem(obj);
        this.checkMeasureForRegularAggrCalculation(obj);
        this.checkSemiAggregatesRules(obj);
        this.checkForExpressionRefersToCalculation(obj);
        this.validateMultilingualNames(obj);
        this.checkForUnknownAggregation(obj);
        this.checkTransactionIdConflicts(obj);
        this.checkForCalculatedMappedMeasure(obj);
    }

    private void checkForCalculatedMappedMeasure(FmMeasure obj) {
        QueryItemMapping mapping;
        RelationalObject ro;
        FmRegularAggregate aggr = obj.getRegularAggregate();
        if (aggr.equals((Object)FmRegularAggregate.calculated) && (ro = obj.getRelationalParent()) != null && (mapping = ro.findMapping(obj)) != null) {
            Cube cube = null;
            BaseObject parent = obj.getParent();
            while (parent != null) {
                if (parent instanceof Cube) {
                    cube = (Cube)parent;
                }
                parent = parent.getParent();
            }
            FmMDException.ASSERT(cube != null, "The measure " + obj.getID() + " does not belong to a cube.");
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_CALCULATED_MAPPED_MEASURE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), cube.getName(), obj));
        }
    }

    private void checkForUnknownAggregation(FmMeasure obj) {
        List<AggregateRule> rules;
        FmRegularAggregate aggr = obj.getRegularAggregate();
        if (aggr.equals((Object)FmRegularAggregate.unknown) && (rules = obj.getAggregateRules()).size() > 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_AGGREGATE_RULES_FOR_UNKNOWN, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
        }
    }

    private void checkSemiAggregatesRules(FmMeasure obj) {
        String path = obj.getParent().getID();
        block0: for (AggregateRule aggrRule : obj.getAggregateRules()) {
            if (aggrRule.getApplyAggregate().equals((Object)SemiAggregate.unsupported) || aggrRule.getApplyAggregate().equals((Object)SemiAggregate.unknown)) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_SEMI_AGGREGATE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), aggrRule.getDimensionBaseRef().getName(), path, (FmBaseObject)obj));
            }
            for (DimensionBase dim : aggrRule.getDimensionRefs()) {
                if (!aggrRule.getApplyAggregate().equals((Object)SemiAggregate.firstPeriod) && !aggrRule.getApplyAggregate().equals((Object)SemiAggregate.lastPeriod) && !aggrRule.getApplyAggregate().equals((Object)SemiAggregate.currentPeriod)) continue;
                if (((RelationalDimension)dim).getParentChild()) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_PC_DIM_SEMI_AGGREGATE, FeedbackMessage.FeedbackSeverity.ERROR, dim.getName(), obj));
                    continue block0;
                }
                if (this.getContextCube() != null) {
                    ConvergentLevelInfo convLevelInfo = new ConvergentLevelInfo();
                    convLevelInfo = this.determineDiffGrainOfDimension(dim, obj);
                    if (convLevelInfo != null && convLevelInfo.m_Inject) {
                        String cubeName = "";
                        BaseObject parent = obj.getParent();
                        while (parent != null) {
                            if (parent instanceof Cube) {
                                cubeName = ((Cube)parent).getName();
                                break;
                            }
                            parent = parent.getParent();
                        }
                        String aggr = FmMessage.render("BMT_AGR_" + aggrRule.getApplyAggregate().toString(), obj.getSession().getActiveLocale());
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INCONSISTENT_GRAIN_FOR_SEMI_AGGREGATE, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), dim.getName(), cubeName, aggr, (FmBaseObject)obj));
                    }
                }
                if (!aggrRule.getApplyAggregate().equals((Object)SemiAggregate.currentPeriod)) continue;
                if (dim.getDimensionStyle().equals((Object)DimensionBase.DimensionStyle.time)) {
                    boolean found = false;
                    for (RelationalHierarchy hier : ((RelationalDimension)dim).getAllHierarchies()) {
                        if (((FmRelationalHierarchy)hier).getHasRelativeTimeMembers()) continue;
                        found = true;
                        break;
                    }
                    if (!found) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_USE_OF_CURRENT_PERIOD, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), dim.getName(), path, (FmBaseObject)obj));
                    continue;
                }
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_USE_OF_CURRENT_PERIOD, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), dim.getName(), path, (FmBaseObject)obj));
            }
        }
    }

    private ConvergentLevelInfo determineDiffGrainOfDimension(DimensionBase dim, FmMeasure obj) {
        RelationalDimension objRegDim = (RelationalDimension)dim;
        FmMeasureDimension objMsrDim = (FmMeasureDimension)obj.getParentMeasureDimension();
        if (objMsrDim == null) {
            return null;
        }
        if (!((RelationalDimension)dim).getParentChild()) {
            List<Table> commonTables = objRegDim.getCommonTables(objMsrDim);
            List<Relationship> dimFactRels = objRegDim.getRelationships(objMsrDim);
            if (commonTables.size() <= 0 && dimFactRels.size() == 1) {
                List<Object> expParts = dimFactRels.get(0).getExpression().getComponents();
                ArrayList<ColumnReference> convergentRefs = new ArrayList<ColumnReference>();
                ConvergentLevelInfo info = new ConvergentLevelInfo();
                int iStart = 0;
                while (iStart < expParts.size() && expParts.get(iStart) instanceof String) {
                    ++iStart;
                }
                int i = iStart;
                while (i + 2 < expParts.size()) {
                    FmMDException.ASSERT(expParts.get(i + 1) instanceof String, "Non-standard relationship expression.");
                    if (expParts.size() > i + 3) {
                        FmMDException.ASSERT(expParts.get(i + 3) instanceof String, "Non-standard relationship expression.");
                    }
                    ColumnReference leftSide = this.extractSideInfo(expParts.get(i));
                    ColumnReference rightSide = this.extractSideInfo(expParts.get(i + 2));
                    if (leftSide.getRelationalObject().equals(objMsrDim)) {
                        convergentRefs.add(rightSide);
                    } else if (rightSide.getRelationalObject().equals(objMsrDim)) {
                        convergentRefs.add(leftSide);
                    }
                    i += 4;
                }
                if (convergentRefs.size() > 0) {
                    i = 0;
                    while (i < convergentRefs.size()) {
                        int j = i + 1;
                        while (j < convergentRefs.size()) {
                            ColumnReference iRef = (ColumnReference)convergentRefs.get(i);
                            ColumnReference jRef = (ColumnReference)convergentRefs.get(j);
                            if (iRef.getTableName().equals(jRef.getTableName()) && iRef.getDataSource().equals(jRef.getDataSource())) break;
                            ++j;
                        }
                        ++i;
                    }
                    HashSet<Object> examinedLevels = new HashSet<Object>();
                    ColumnReference convergentRef = (ColumnReference)convergentRefs.get(0);
                    ArrayList<Level> candidateLevels = new ArrayList<Level>();
                    for (RelationalHierarchy hier : objRegDim.getAllHierarchies()) {
                        Level level = hier.getBottomLevel();
                        for (Object hier2 : objRegDim.getAllHierarchies()) {
                            if (hier.equals(hier2) || !hier2.references(level) || hier2.getBottomLevel().equals(level)) continue;
                            examinedLevels.add(level);
                            break;
                        }
                        if (examinedLevels.contains(level.getInternal())) continue;
                        if (this.matchConvergentLevelCandidate(convergentRef, level)) {
                            candidateLevels.add(level);
                        }
                        examinedLevels.add(level.getInternal());
                    }
                    if (candidateLevels.size() > 0) {
                        for (Level candidateLevel : candidateLevels) {
                            for (ColumnReference ref : convergentRefs) {
                                if (!this.matchConvergentLevelCandidate(ref, candidateLevel)) continue;
                                for (RelationalHierarchy hier : objRegDim.getAllHierarchies()) {
                                    if (this.matchConvergentLevelCandidate(ref, hier.getBottomLevel())) continue;
                                    info.m_Inject = true;
                                }
                                return info;
                            }
                        }
                    }
                    for (Level level : objRegDim.getAllLevels()) {
                        if (level.isAllLevel() || examinedLevels.contains(level.getInternal()) || !this.isReferencedInHierarchies(objRegDim, level) || !this.matchConvergentLevelCandidate(convergentRef, level)) continue;
                        if (objRegDim.getAllLevels().size() > objRegDim.getAllLevels().indexOf(level)) {
                            info.m_Inject = true;
                        }
                        return info;
                    }
                    FMMDSession session = obj.getParentNamespace().getSession();
                    MdDatabase ds = session.findMetadataSource(convergentRef.getDataSource().getCmDataSourceName(), convergentRef.getDataSource().getCatalogName(), convergentRef.getDataSource().getSchemaName());
                    MdTable tableOfInterest = null;
                    if (ds != null) {
                        for (MdTable mdTable : ds.findSchema(convergentRef.getDataSource().getCatalogName(), convergentRef.getDataSource().getSchemaName()).getTables()) {
                            if (!mdTable.getName().equals(convergentRef.getTableName())) continue;
                            tableOfInterest = mdTable;
                            break;
                        }
                    }
                    if (tableOfInterest != null) {
                        info.m_Inject = true;
                        info.m_LevelName = String.valueOf(convergentRef.getTableName()) + "_convergent_level";
                    }
                    return info;
                }
            }
        }
        return null;
    }

    @Override
    protected void checkDatatype(FmQueryItemBase item) {
        boolean isCountAggregate;
        FmMDException.ASSERT(item instanceof FmMeasure, "Item is bad type: " + item.getClass().toString());
        FmMeasure measure = (FmMeasure)item;
        boolean bl = isCountAggregate = measure.getRegularAggregate() == FmRegularAggregate.countDistinct || measure.getRegularAggregate() == FmRegularAggregate.count;
        if (!FmDatatype.isNumeric(measure.getDatatype()).booleanValue() && !isCountAggregate) {
            String path = measure.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNSUPPORTED_DATATYPE_FOR_MEASURE, FeedbackMessage.FeedbackSeverity.ERROR, measure.getName(), path, measure));
        }
    }

    private void checkMeasureForRegularAggrCalculation(FmMeasure meas) {
        if (meas.getRegularAggregate() == FmRegularAggregate.calculated && !meas.getAggregateRules().isEmpty()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SEMI_AGGR_NOT_ALLOWED_FOR_CALC, FeedbackMessage.FeedbackSeverity.ERROR, meas.getName(), meas));
        }
    }

    protected void checkForExpressionRefersToCalculation(FmMeasure obj) {
        Expression expr = obj.getExpression();
        if (expr != null) {
            for (Object component : expr.getComponents()) {
                if (!(component instanceof FmMeasure)) continue;
                FmMeasure subMeas = (FmMeasure)component;
                boolean isCalculated = subMeas.getRegularAggregate() == FmRegularAggregate.calculated;
                boolean isExpressionOnMeasure = false;
                Expression subExpr = subMeas.getExpression();
                if (subExpr != null) {
                    for (Object subComp : subExpr.getComponents()) {
                        if (!(subComp instanceof FmMeasure)) continue;
                        isExpressionOnMeasure = true;
                        break;
                    }
                }
                if (!isCalculated || !isExpressionOnMeasure) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_AGGREGATION_ON_CALCULATION, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), subMeas.getName(), obj));
                return;
            }
        }
    }

    private void checkTransactionIdConflicts(FmMeasure measure) {
        MeasureDimension dim = measure.getParentMeasureDimension();
        if (dim == null || dim.findTransactionIdQueryItem() == null) {
            return;
        }
        if (measure.getRegularAggregate() == FmRegularAggregate.unknown) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.TRANSID_AGGR_CONFLICT, FeedbackMessage.FeedbackSeverity.ERROR, measure.getID(), dim.getName(), measure));
        }
    }

    class ConvergentLevelInfo {
        public boolean m_Inject = false;
        public boolean fact_at_LGrain = false;
        public String m_LevelName;

        ConvergentLevelInfo() {
        }
    }
}

