/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasureDimensionAnalyser
extends RelationalAnalyserBase<FmMeasureDimension> {
    public MeasureDimensionAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public MeasureDimensionAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmMeasureDimension dim) {
        this.init(dim);
        this.checkForInvalidROLAPCharacter(dim);
        this.checkForMultipleTables();
        this.checkJoinAssociations();
        this.checkForUnjoinedTables();
        this.checkForMultipleJoins();
        this.checkForCircularJoins();
        this.checkAmbiguousJoinPath();
        this.checkForNoMeasures(dim);
        this.validateMultilingualNames(dim);
        this.checkRefrencedTablesAndColumns();
        this.checkRelationalFilters();
        this.analyseChildren(dim);
    }

    private void checkForNoMeasures(FmMeasureDimension dim) {
        List<Measure> measures = dim.getAllMeasures();
        if (measures.size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_MEASURES, FeedbackMessage.FeedbackSeverity.ERROR, dim.getName(), dim.getParent().getID(), dim));
        }
    }

    private void checkForMultipleTables() {
        List<Table> tables = this.m_RelationalObject.getTables();
        if (tables.size() > 1) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MEASURE_DIMENSION_W_MULTIPLE_TABLES, FeedbackMessage.FeedbackSeverity.ERROR, this.m_RelationalObject.getName(), this.m_RelationalObject.getParent().getID(), this.m_RelationalObject));
        }
    }
}

