/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.CubeAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.DimensionAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.MeasureDimensionAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.NamespaceAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemSetAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QuerySubjectAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationshipAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.StandaloneCalculationAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.StandaloneFilterAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualCubeAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Calculation;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionParent;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.FilterApplication;
import com.ibm.cognos.fmeng.fmmd.model.Folder;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.PackageBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.SecurityViewDefinition;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageAnalyser
extends AnalyserBase<FmPackage> {
    private PackageBase m_kPackage;

    public PackageAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public PackageAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void analyse(PackageBase kPackage) {
        this.m_kPackage = kPackage;
        this.checkIfPackageHasCubes();
        this.checkPackageContents();
        this.checkSecurityFilterUsage();
    }

    private void checkSecurityFilterUsage() {
        for (SecurityViewDefinition secDef : this.m_kPackage.getSecurityViewDefinitions()) {
            for (RelationalFilter filter : secDef.getSecurityFilters()) {
                if (filter.getFilterApplication().equals((Object)FilterApplication.EFilterApplication.security)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.WRONG_FILTER_USAGE_FOR_SECURITY, FeedbackMessage.FeedbackSeverity.ERROR, filter.getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)filter.getRelationalParent()), (FmBaseObject)((Object)filter), (FmBaseObject)((Object)this.m_kPackage)));
            }
        }
    }

    @Override
    protected void doAnalysis(FmPackage obj) {
        this.setContextPackage(obj);
        this.m_kPackage = obj;
        this.checkIfPackageHasCubes();
        this.checkPackageContents();
        this.checkSecurityFilterUsage();
    }

    private void checkIfPackageHasCubes() {
        if (this.m_kPackage.isEmpty()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PACKAGE_IS_EMPTY, FeedbackMessage.FeedbackSeverity.ERROR, this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
        }
    }

    private void checkPackageContents() {
        ArrayList<RelationalObject> allDim = new ArrayList<RelationalObject>();
        ArrayList<RelationalObject> allQuerySubjects = new ArrayList<RelationalObject>();
        for (TopLevelObject obj : this.m_kPackage.getPackageContents()) {
            if (obj instanceof FmVirtualCube) {
                VirtualCubeAnalyser virtualCubeAnalyser = new VirtualCubeAnalyser(this);
                virtualCubeAnalyser.analyse((FmVirtualCube)obj);
                continue;
            }
            if (obj instanceof FmCube) {
                CubeAnalyser cubeAnalyser = new CubeAnalyser(this);
                cubeAnalyser.analyse((FmCube)obj);
                continue;
            }
            if (obj instanceof FmNamespace) {
                NamespaceAnalyser namespaceAnalyser = new NamespaceAnalyser(this);
                namespaceAnalyser.analyse((FmNamespace)obj);
                allDim.addAll(((FmNamespace)obj).getAllRelationalDimensions());
                for (RelationalObject relationalObject : ((Namespace)obj).getAllRelationalDimensions()) {
                    this.doDMRValidation(relationalObject);
                }
                continue;
            }
            if (obj instanceof FmMeasureDimension) {
                MeasureDimensionAnalyser measureDimensionAnalyser = new MeasureDimensionAnalyser(this);
                measureDimensionAnalyser.analyse((FmMeasureDimension)obj);
                allDim.add((RelationalObject)obj);
                this.doDMRValidation((RelationalObject)obj);
                continue;
            }
            if (obj instanceof FmRelationalDimension) {
                DimensionAnalyser dimensionAnalyser = new DimensionAnalyser(this);
                dimensionAnalyser.analyse((FmRelationalDimension)obj);
                allDim.add((RelationalObject)obj);
                this.doDMRValidation((RelationalObject)obj);
                continue;
            }
            if (obj instanceof FmFolder) {
                allDim.addAll(((Folder)obj).getAllRelationalDimensions());
                for (RelationalObject relationalObject : ((Folder)obj).getAllRelationalDimensions()) {
                    this.doDMRValidation(relationalObject);
                }
                continue;
            }
            if (obj instanceof FmRelationalQuerySubject) {
                QuerySubjectAnalyser querySubjectAnalyser = new QuerySubjectAnalyser(this);
                querySubjectAnalyser.analyse((FmRelationalQuerySubject)obj);
                allQuerySubjects.add((RelationalObject)obj);
                continue;
            }
            if (obj instanceof FmFilter) {
                StandaloneFilterAnalyser standaloneFilterAnalyser = new StandaloneFilterAnalyser(this);
                standaloneFilterAnalyser.analyse((FmBaseObject)((Object)obj));
                this.checkIfFilterOrCalculationIsValid(obj);
                continue;
            }
            if (obj instanceof FmCalculation) {
                StandaloneCalculationAnalyser standaloneCalculationAnalyser = new StandaloneCalculationAnalyser(this);
                standaloneCalculationAnalyser.analyse((FmBaseObject)((Object)obj));
                this.checkIfFilterOrCalculationIsValid(obj);
                continue;
            }
            if (!(obj instanceof FmQuerySubject)) continue;
            QueryItemSetAnalyser queryItemSetAnalyser = new QueryItemSetAnalyser(this);
            queryItemSetAnalyser.analyse((FmQuerySubject)obj);
        }
        this.checkForJoinedDimsAndMeas(allDim);
        this.analyseRelashipsInQuerySubjects(allQuerySubjects);
        this.checkForTimeDimsInPackage(allDim);
    }

    private void checkIfFilterOrCalculationIsValid(TopLevelObject obj) {
        boolean valid = true;
        List<Object> parts = ((ExpressionParent)((Object)obj)).getExpression().getComponents();
        for (Object part : parts) {
            if (part instanceof Calculation || part instanceof Filter) {
                valid = false;
                for (TopLevelObject tlo : this.m_kPackage.getPackageContents()) {
                    if (!tlo.getInternal().equals(((ReportObject)part).getInternal())) continue;
                    valid = true;
                }
            } else if (part instanceof Measure || part instanceof QueryItem) {
                valid = this.checkIfPackageHasReferencedMeasureAndQueryItem(part);
            }
            if (valid) continue;
            if (obj instanceof Filter) {
                if (part instanceof Filter) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.STANDALONE_FILTER_REFERS_TO_ANOTHER_FILTER_THAT_IS_NOT_PART_OF_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), ((Filter)part).getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
                    continue;
                }
                if (part instanceof Measure) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.STANDALONE_FILTER_REFERS_TO_MEASURE_THAT_IS_NOT_PART_OF_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), ((Measure)part).getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
                    continue;
                }
                if (!(part instanceof QueryItem)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.STANDALONE_FILTER_REFERS_TO_QUERYITEM_THAT_IS_NOT_PART_OF_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), ((QueryItem)part).getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
                continue;
            }
            if (part instanceof Calculation) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.STANDALONE_CALCULATION_REFERS_TO_ANOTHER_CALCULATION_THAT_IS_NOT_PART_OF_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), ((Calculation)part).getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
                continue;
            }
            if (part instanceof Measure) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.STANDALONE_CALCULATION_REFERS_TO_MEASURE_THAT_IS_NOT_PART_OF_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), ((Measure)part).getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
                continue;
            }
            if (!(part instanceof QueryItem)) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.STANDALONE_CALCULATION_REFERS_TO_QUERYITEM_THAT_IS_NOT_PART_OF_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), ((QueryItem)part).getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)this.m_kPackage)));
        }
    }

    private boolean checkIfPackageHasReferencedMeasureAndQueryItem(Object part) {
        if (part instanceof Measure) {
            return this.checkIfPackageHasReferencedMeasure((Measure)part);
        }
        return this.checkIfPackageHasReferencedQueryItem((QueryItem)part);
    }

    private boolean checkIfPackageHasReferencedMeasure(Measure m) {
        MeasureDimension mDim = m.getParentMeasureDimension();
        for (TopLevelObject tlo : this.m_kPackage.getPackageContents()) {
            if (!tlo.getInternal().equals(mDim.getInternal())) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfPackageHasReferencedQueryItem(QueryItem qi) {
        BaseObject parent = qi.getParent();
        if (parent instanceof Level) {
            parent = ((Level)parent).getDimension();
        }
        for (TopLevelObject tlo : this.m_kPackage.getPackageContents()) {
            if (!tlo.getInternal().equals(parent.getInternal())) continue;
            return true;
        }
        return false;
    }

    private void checkForTimeDimsInPackage(List<RelationalObject> allDim) {
        for (RelationalObject dim : allDim) {
            if (!(dim instanceof FmRelationalDimension) || !((FmRelationalDimension)dim).isTimeDimension()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.TIME_DIM_IN_PACKAGE, FeedbackMessage.FeedbackSeverity.WARNING, dim.getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)dim)));
        }
    }

    private void analyseRelashipsInQuerySubjects(List<RelationalObject> allQuerySubjects) {
        if (allQuerySubjects.size() > 1) {
            for (RelationalObject querySub1 : allQuerySubjects) {
                int i = allQuerySubjects.indexOf(querySub1) + 1;
                while (i < allQuerySubjects.size()) {
                    RelationalObject querySub2 = allQuerySubjects.get(i);
                    if (!querySub1.getRelationships(querySub2).isEmpty()) {
                        RelationshipAnalyser relAnalyser = new RelationshipAnalyser(this);
                        for (Relationship rel : querySub1.getRelationships(querySub2)) {
                            relAnalyser.analyse((FmRelationship)rel);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void checkForJoinedDimsAndMeas(List<RelationalObject> allDim) {
        boolean found = false;
        ArrayList<RelationalObject> relDims = new ArrayList<RelationalObject>();
        ArrayList<RelationalObject> measDims = new ArrayList<RelationalObject>();
        for (RelationalObject dim : allDim) {
            if (!(dim.getParent() instanceof Section)) continue;
            if (dim instanceof FmRelationalDimension) {
                if (((FmRelationalDimension)dim).getParentChild()) continue;
                relDims.add(dim);
                continue;
            }
            measDims.add(dim);
        }
        for (RelationalObject dim : relDims) {
            found = false;
            for (RelationalObject meas : measDims) {
                if (dim.getRelationships(meas).isEmpty()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_REL_FOUND, FeedbackMessage.FeedbackSeverity.ERROR, dim.getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)dim)));
        }
        for (RelationalObject meas : measDims) {
            found = false;
            for (RelationalObject dim : relDims) {
                if (meas.getRelationships(dim).isEmpty()) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_REL_FOUND, FeedbackMessage.FeedbackSeverity.ERROR, meas.getName(), this.m_kPackage.getName(), (FmBaseObject)((Object)meas)));
        }
        for (RelationalObject meas : measDims) {
            for (RelationalObject dim : relDims) {
                if (meas.getRelationships(dim).isEmpty()) continue;
                RelationshipAnalyser relAnalyser = new RelationshipAnalyser(this);
                for (Relationship rel : meas.getRelationships(dim)) {
                    relAnalyser.analyse((FmRelationship)rel);
                }
            }
        }
    }

    private void checkLevelForDimensionsInPackage(RelationalObject obj) {
        int count = 0;
        if (this.getContextPackage() != null && !((FmRelationalDimension)obj).getParentChild()) {
            block0: for (Level level : ((FmRelationalDimension)obj).getAllLevels()) {
                if (level.getLevelKeys().size() <= 1) continue;
                count = 0;
                List<QueryItem> queryItems = level.getAllQueryItems();
                for (QueryItem levelKey : level.getLevelKeys()) {
                    if (count > true || !queryItems.contains(levelKey) || ++count <= 1) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVEL_MUST_HAVE_ONE_LEVEL_KEY, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), this.m_kPackage.getName(), level.getName(), (FmBaseObject)((Object)obj)));
                    continue block0;
                }
            }
        }
    }

    private void checkParentChildDim(FmRelationalDimension obj) {
        if (obj.getParentChild()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PARENT_CHILD_DIM_IN_PACKAGE, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), this.m_kPackage.getName(), obj));
        }
    }

    private void doDMRValidation(RelationalObject obj) {
        if (obj instanceof FmRelationalDimension) {
            this.checkParentChildDim((FmRelationalDimension)obj);
            this.checkLevelForDimensionsInPackage(obj);
        }
    }
}

