/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapEntry;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMapAnalyser
extends RelationalAnalyserBase<FmParameterMap> {
    public ParameterMapAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public ParameterMapAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmParameterMap obj) {
        List<ParameterMapEntry> entries = obj.getParameterMapEntries();
        if (!obj.isHidden() && entries.isEmpty()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.EMPTY_PM, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
        } else if (!obj.isHidden()) {
            this.checkDefaultValue(obj);
            this.checkMissingKeys(obj);
            this.checkMissingValues(obj);
        }
    }

    private void checkMissingKeys(FmParameterMap obj) {
        List<ParameterMapEntry> entries = obj.getParameterMapEntries();
        for (ParameterMapEntry entry : entries) {
            if (entry.getKey() != null && !entry.getKey().isEmpty()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_KEY_FOR_PM, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
            break;
        }
    }

    private void checkMissingValues(FmParameterMap obj) {
        List<ParameterMapEntry> entries = obj.getParameterMapEntries();
        for (ParameterMapEntry entry : entries) {
            if (entry.getValue() != null && !entry.getValue().isEmpty()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_VALUE_FOR_PM, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
            break;
        }
    }

    private void checkDefaultValue(FmParameterMap obj) {
        if (!obj.isHidden() && obj.getDefaultValue() == null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_DEFAULT_VALUE, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), obj));
        }
    }
}

