/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPackage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.DatasourceAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.NamespaceAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.PackageAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.ParameterMapAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalParameterMapAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.Package;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalParameterMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectAnalyser
extends AnalyserBase<FmProject> {
    public ProjectAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public ProjectAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmProject obj) {
        this.analyseNamespace(obj);
        this.analyseDatasources(obj);
        this.analyseParameterMaps(obj);
        this.analysePackages(obj);
    }

    private void analyseParameterMaps(FmProject obj) {
        ParameterMapAnalyser analyser1 = new ParameterMapAnalyser(this);
        RelationalParameterMapAnalyser analyser = new RelationalParameterMapAnalyser(this);
        for (ParameterMapBase pmap : obj.getParameterMaps()) {
            if (pmap instanceof RelationalParameterMap) {
                analyser.analyse((FmRelationalParameterMap)pmap);
            }
            if (!(pmap instanceof FmParameterMap)) continue;
            analyser1.analyse((FmParameterMap)pmap);
        }
    }

    private void analyseNamespace(FmProject obj) {
        NamespaceAnalyser ns = new NamespaceAnalyser(this);
        ns.analyse((FmNamespace)obj.getRootNamespace());
    }

    private void analyseDatasources(FmProject obj) {
        List<DataSource> dataSources = obj.getProject().getDataSources();
        if (dataSources != null) {
            DatasourceAnalyser analyser = new DatasourceAnalyser(this);
            for (DataSource dataSource : dataSources) {
                analyser.analyse((FmDataSource)dataSource);
            }
        }
    }

    private void analysePackages(FmProject obj) {
        List<Package> ls = obj.getPackages();
        PackageAnalyser analyser = new PackageAnalyser(this);
        for (Package p : ls) {
            analyser.analyse((FmPackage)p);
        }
    }
}

