/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemBaseAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryItemAnalyser
extends QueryItemBaseAnalyserBase<FmQueryItem> {
    public QueryItemAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public QueryItemAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmQueryItem queryItem) {
        this.checkForInvalidROLAPCharacter(queryItem);
        this.checkItem(queryItem);
        this.validateMultilingualNames(queryItem);
        if (queryItem.isMultilingual()) {
            for (QueryItem multilingualAttribute : queryItem.getMultilingualAttributeQueryItems()) {
                FmExpression expr = (FmExpression)multilingualAttribute.getExpression();
                if (expr == null) continue;
                this.testExpressionQueryitem(queryItem, multilingualAttribute, expr);
            }
        }
    }

    @Override
    protected void checkDatatype(FmQueryItemBase item) {
        FmMDException.ASSERT(item instanceof FmQueryItem, "Item is bad type: " + item.getClass().toString());
        if (FmDatatype.isUnsupportedByROLAP(item.getDatatype()).booleanValue() && item.getSession().getClientType().equals((Object)FMMDSession.ClientType.CubeDesigner)) {
            String itemPath = item.getParent().getID();
            String datatype = FmMessage.render("BMT_DTA_" + item.getDatatype().internalValue(), item.getSession().getActiveLocale());
            if (item.getParent() instanceof FmRelationalQuerySubject) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNSUPPORTED_DATATYPE_FOR_QUERY_ITEM, FeedbackMessage.FeedbackSeverity.ERROR, datatype, item.getName(), itemPath, (FmBaseObject)item));
            }
        }
    }
}

