/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryItemBaseAnalyserBase<T extends FmQueryItemBase>
extends AnalyserBase<T> {
    protected abstract void checkDatatype(FmQueryItemBase var1);

    public QueryItemBaseAnalyserBase(AnalyserBase<?> obj) {
        super(obj);
    }

    public QueryItemBaseAnalyserBase(AnalyserConfig config) {
        super(config);
    }

    protected void checkItem(FmQueryItemBase item) {
        String itemPath = item.getParent().getID();
        if (this.isDBItem(item)) {
            if (item.getRelationalParent() != null) {
                if (item.getDatatype() == FmDatatype.UNKNOWN) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_DATATYPE_FOR_DB_ITEM, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                }
                this.checkDatatype(item);
            } else {
                FmMDException.ASSERT(item.getDatatype() != FmDatatype.UNKNOWN, "Bad datatype");
            }
        } else {
            FmExpression expression = (FmExpression)item.getExpression();
            if (expression != null) {
                this.testExpressionQueryitem(item, null, expression);
            } else if (this.isAggregateCube(item)) {
                if (item.getParent() instanceof FmRelationalHierarchy) {
                    FmRelationalHierarchy hier = (FmRelationalHierarchy)item.getParent();
                    if (hier.getParentChild()) {
                        QueryItem childItem = hier.getChildItem();
                        if (childItem != null && childItem.equals(item)) {
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                        }
                    } else {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                    }
                } else {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                }
            } else {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION_AND_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
            }
        }
        FmMDException.ASSERT(item.getRelationalParent() != null || item.getQueryParent() != null, "Bad query item parent");
    }

    public boolean isAggregateCube(FmQueryItemBase item) {
        BaseObject obj = item.getParent();
        while (obj != null) {
            FmCube parentCube;
            if (obj instanceof FmCube && (parentCube = (FmCube)obj).isAggregateCube()) {
                return true;
            }
            obj = obj.getParent();
        }
        return false;
    }

    protected boolean isDBItem(FmQueryItemBase item) {
        String externalName;
        QueryItemMapping mapping;
        RelationalObject roParent = item.getRelationalParent();
        QuerySubjectBase qsParent = item.getQueryParent();
        return roParent != null ? (mapping = roParent.findMapping(item)) != null : qsParent != null && (externalName = item.getExternalName()) != null && !"".equals(externalName);
    }

    protected void testExpressionQueryitem(FmQueryItemBase item, QueryItem multilingualAttribute, FmExpression expression) {
        block16: {
            String itemPath;
            block14: {
                List<Object> objs;
                block18: {
                    RelationalObject ro;
                    block17: {
                        block15: {
                            itemPath = item.getParent().getID();
                            ro = item.getRelationalParent();
                            if (item.getQueryParent() != null) break block14;
                            FmMDException.ASSERT(ro != null, "Unknown relational ancestor for " + item.getID());
                            if (!(ro instanceof RelationalQuerySubject) && this.m_Config.isConnected()) break block15;
                            if (expression.isMacro()) {
                                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNABLE_TO_REWRITE_EXPRESSION, FeedbackMessage.FeedbackSeverity.WARNING, expression.getExpressionText(), itemPath, item));
                                return;
                            }
                            List<Object> objs2 = expression.getComponents();
                            if (objs2.size() == 0) {
                                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION_AND_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                            } else {
                                for (Object obj : objs2) {
                                    if (obj instanceof FmQueryItemBase) {
                                        FmQueryItemBase qiRef = (FmQueryItemBase)obj;
                                        RelationalObject roRef = qiRef.getRelationalParent();
                                        FmMDException.ASSERT(roRef != null, "Unknown relational ancestor for " + qiRef.getID());
                                        if (ro.equals(roRef)) continue;
                                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_REFERENCE_IN_ATTRIBUTE_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, qiRef.getID(), (FmBaseObject)item));
                                        continue;
                                    }
                                    if (obj instanceof String) {
                                        if (!((String)obj).equals("") || objs2.size() != 1) continue;
                                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION_AND_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                                        continue;
                                    }
                                    if (obj instanceof FmUnresolvedReference) {
                                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_OBJECT_IN_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, ((FmUnresolvedReference)obj).getReference(), itemPath, item));
                                        continue;
                                    }
                                    FmMDException.ASSERT(false, "Unexpected object in QueryItemBaseAnalyserBase: " + obj.getClass().toString());
                                }
                            }
                            break block16;
                        }
                        if (!expression.isMacro()) break block17;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNABLE_TO_REWRITE_EXPRESSION, FeedbackMessage.FeedbackSeverity.WARNING, expression.getExpressionText(), itemPath, item));
                        break block16;
                    }
                    objs = expression.getComponents();
                    if (objs.size() == 0) break block18;
                    for (Object obj : objs) {
                        if (obj instanceof String) {
                            if (!((String)obj).equals("") || objs.size() != 1) continue;
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION_AND_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                            continue;
                        }
                        if (obj instanceof FmQueryItemBase) {
                            FmQueryItemBase qiRef = (FmQueryItemBase)obj;
                            RelationalObject roRef = qiRef.getRelationalParent();
                            FmMDException.ASSERT(roRef != null, "Unknown relational ancestor for " + qiRef.getID());
                            if (ro.equals(roRef)) continue;
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_REFERENCE_IN_ATTRIBUTE_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, qiRef.getID(), (FmBaseObject)item));
                            continue;
                        }
                        if (!(obj instanceof FmUnresolvedReference)) continue;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_OBJECT_IN_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, ((FmUnresolvedReference)obj).getReference(), itemPath, item));
                    }
                    break block16;
                }
                if (!objs.isEmpty()) break block16;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_ASSOCIATION_AND_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                break block16;
            }
            List<Object> objs = expression.getComponents();
            if (objs.size() == 0) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
            } else {
                for (Object obj : objs) {
                    if (obj instanceof String) {
                        if (!((String)obj).equals("") || objs.size() != 1) continue;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), itemPath, item));
                        continue;
                    }
                    if (!(obj instanceof FmUnresolvedReference)) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_OBJECT_IN_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, ((FmUnresolvedReference)obj).getReference(), itemPath, item));
                }
            }
        }
    }
}

