/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryItemSetAnalyser
extends AnalyserBase<FmQuerySubject> {
    public QueryItemSetAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public QueryItemSetAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmQuerySubject obj) {
        List<QueryItem> queryItems = obj.getAllQueryItems();
        if (queryItems.size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.QUERY_SUBJECT_HAS_NO_QUERY_ITEMS, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), obj));
        } else {
            QueryItemAnalyser analyser = new QueryItemAnalyser(this);
            for (QueryItem item : queryItems) {
                analyser.analyse((FmQueryItem)item);
            }
        }
        this.checkForUnjoinedRelQuerySubject(obj);
    }

    private void findRelated(RelationalQuerySubject centerSubject, Set<RelationalQuerySubject> relatedSubjects, List<Relationship> allRelationships) {
        for (Relationship rel : allRelationships) {
            if (!(rel instanceof FmRelationship)) continue;
            RelationshipEnd leftEnd = ((FmRelationship)rel).getLeftEnd();
            RelationshipEnd rightEnd = ((FmRelationship)rel).getRightEnd();
            if (centerSubject.equals(leftEnd) && rightEnd instanceof RelationalQuerySubject) {
                if (relatedSubjects.contains(rightEnd)) continue;
                relatedSubjects.add((RelationalQuerySubject)rightEnd);
                this.findRelated((RelationalQuerySubject)rightEnd, relatedSubjects, allRelationships);
                continue;
            }
            if (!centerSubject.equals(rightEnd) || !(leftEnd instanceof RelationalQuerySubject) || relatedSubjects.contains(leftEnd)) continue;
            relatedSubjects.add((RelationalQuerySubject)leftEnd);
            this.findRelated((RelationalQuerySubject)leftEnd, relatedSubjects, allRelationships);
        }
    }

    protected void checkForUnjoinedRelQuerySubject(FmQuerySubject obj) {
        ArrayList<RelationalQuerySubject> relQuerySubjects = new ArrayList<RelationalQuerySubject>();
        HashSet<Object> visitedQuerySubjects = new HashSet<Object>();
        this.getRelQuerySubjectsReferencedInQuery(obj, relQuerySubjects, visitedQuerySubjects);
        if (relQuerySubjects.size() <= 1) {
            return;
        }
        List<Relationship> allRelationships = obj.getProject().getRootNamespace().getAllRelationships();
        HashSet<RelationalQuerySubject> minUnrelatedSubjects = null;
        for (RelationalQuerySubject relQuerySubject : relQuerySubjects) {
            HashSet<RelationalQuerySubject> relatedSubjects = new HashSet<RelationalQuerySubject>();
            relatedSubjects.add(relQuerySubject);
            this.findRelated(relQuerySubject, relatedSubjects, allRelationships);
            HashSet<RelationalQuerySubject> unrelatedSubjects = new HashSet<RelationalQuerySubject>(relQuerySubjects);
            unrelatedSubjects.removeAll(relatedSubjects);
            if (unrelatedSubjects.isEmpty()) {
                return;
            }
            if (minUnrelatedSubjects != null && unrelatedSubjects.size() >= minUnrelatedSubjects.size()) continue;
            minUnrelatedSubjects = unrelatedSubjects;
        }
        for (RelationalQuerySubject relQuerySubject : minUnrelatedSubjects) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.QS_REF_MORE_RQS, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), relQuerySubject.getName(), obj));
        }
    }

    protected void getRelQuerySubjectsReferencedInQuery(FmQuerySubject obj, List<RelationalQuerySubject> relQuerySubjects, HashSet<Object> visitedQuerySubjects) {
        visitedQuerySubjects.add(obj.getInternal());
        for (QueryItem qi : obj.getQueryItems()) {
            for (BaseObject refObj : qi.getReferencedObjects()) {
                if (refObj instanceof FmUnresolvedReference) continue;
                BaseObject parent = refObj.getParent();
                if (parent instanceof FmRelationalQuerySubject) {
                    if (relQuerySubjects.contains(parent)) continue;
                    relQuerySubjects.add((RelationalQuerySubject)parent);
                    continue;
                }
                if (!(parent instanceof FmQuerySubject) || visitedQuerySubjects.contains(obj.getInternal())) continue;
                this.getRelQuerySubjectsReferencedInQuery((FmQuerySubject)parent, relQuerySubjects, visitedQuerySubjects);
            }
        }
    }
}

