/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationshipAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TableDeterminant;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuerySubjectAnalyser
extends RelationalAnalyserBase<FmRelationalQuerySubject> {
    public QuerySubjectAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public QuerySubjectAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmRelationalQuerySubject querySubject) {
        this.checkForInvalidROLAPCharacter(querySubject);
        this.init(querySubject);
        List<QueryItem> queryItems = querySubject.getAllQueryItems();
        if (queryItems.size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.QUERY_SUBJECT_HAS_NO_QUERY_ITEMS, FeedbackMessage.FeedbackSeverity.WARNING, querySubject.getName(), querySubject));
        } else {
            QueryItemAnalyser analyser = new QueryItemAnalyser(this);
            for (QueryItem item : queryItems) {
                analyser.analyse((FmQueryItem)item);
            }
        }
        this.checkJoinAssociations();
        this.checkForUnjoinedTables();
        this.checkForMultipleJoins();
        this.checkForCircularJoins();
        this.checkAmbiguousJoinPath();
        this.checkForFanTrap();
        this.checkRefrencedTablesAndColumns();
        this.checkDeterminantSettings();
        this.checkMissingKeyForDeterminant();
        this.checkDuplicateDeterminant();
        this.checkMissingDeterminantForBlobDataType();
        this.checkDeterminantforColRef();
        this.checkDeterminantforInvalidColRef();
        this.checkRelationalFilters();
        List<Relationship> relationships = this.m_RelationalObject.getRelationships();
        if (relationships != null) {
            RelationshipAnalyser relationshipAnalyzer = new RelationshipAnalyser(this);
            for (Relationship relationship : relationships) {
                relationshipAnalyzer.analyse((FmRelationship)relationship);
            }
        }
    }

    private void checkForFanTrap() {
        List<Table> tables = this.m_PhysDef.getTables();
        if (tables.size() > 1) {
            for (Table someTable : tables) {
                FmTable table = (FmTable)someTable;
                HashMap<FmTable, FmJoin> joinsForThisTable = new HashMap<FmTable, FmJoin>();
                List<FmJoin> joins = table.getJoins();
                for (FmJoin someJoin : joins) {
                    if (someJoin.getLeft().equals(table) && someJoin.getLeftMaxcard() != Cardinality.ECardinality.many && someJoin.getRightMaxcard() == Cardinality.ECardinality.many) {
                        joinsForThisTable.put(someJoin.getRight(), someJoin);
                    }
                    if (!someJoin.getRight().equals(table) || someJoin.getRightMaxcard() == Cardinality.ECardinality.many || someJoin.getLeftMaxcard() != Cardinality.ECardinality.many) continue;
                    joinsForThisTable.put(someJoin.getLeft(), someJoin);
                }
                if (joinsForThisTable.keySet().size() <= 1) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.FAN_TRAP, FeedbackMessage.FeedbackSeverity.WARNING, someTable.getName(), this.m_RelationalObject));
            }
        }
    }

    protected void checkDeterminantforInvalidColRef() {
        for (Table table : this.m_PhysDef.getTables()) {
            MdTable mdTable = table.getPhysicalTable(false);
            if (mdTable == null) continue;
            List<MdColumn> columns = mdTable.getColumns();
            for (TableDeterminant tblDet : table.getTableDeterminants()) {
                ArrayList<String> refCols = new ArrayList<String>();
                refCols.addAll(tblDet.getAttributes());
                refCols.addAll(tblDet.getKeys());
                for (String refCol : refCols) {
                    boolean physicalRefFound = false;
                    for (MdColumn col : columns) {
                        if (!refCol.equals(col.getName())) continue;
                        physicalRefFound = true;
                        break;
                    }
                    if (physicalRefFound) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_COL_REF, FeedbackMessage.FeedbackSeverity.ERROR, tblDet.getName(), table.getName(), this.m_RelationalObject.getName(), refCol, (FmBaseObject)this.m_RelationalObject));
                }
            }
        }
    }
}

