/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackContext;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalFilterAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TableDeterminant;
import com.ibm.cognos.fmeng.fmmd.util.FmRoute;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.genmodel.TableType;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelationalAnalyserBase<T extends FmBaseObject>
extends AnalyserBase<T> {
    protected FmPhysicalDefinition m_PhysDef;
    protected FmRelationalObject m_RelationalObject;

    public RelationalAnalyserBase(AnalyserBase<?> obj) {
        super(obj);
    }

    public RelationalAnalyserBase(AnalyserConfig config) {
        super(config);
    }

    protected void init(RelationalObject obj) {
        this.m_RelationalObject = (FmRelationalObject)obj;
        this.m_PhysDef = this.m_RelationalObject.getPhysicalDefinition();
    }

    protected void checkJoinAssociations() {
        List<Join> joins = this.m_PhysDef.getJoins();
        for (Join join : joins) {
            List<Association> assocs = join.getAssociations();
            Table leftTable = join.getLeftTable();
            Table rightTable = join.getRightTable();
            if (assocs.size() == 0) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_JOIN_ASSOCIATIONS, FeedbackMessage.FeedbackSeverity.ERROR, leftTable.getName(), rightTable.getName(), this.m_RelationalObject.getName(), (FmBaseObject)this.m_RelationalObject));
                continue;
            }
            MdTable leftMdTable = leftTable.getPhysicalTable(false);
            MdTable rightMdTable = rightTable.getPhysicalTable(false);
            if (leftMdTable == null || rightMdTable == null) continue;
            for (Association assoc : assocs) {
                this.checkForColumn(leftMdTable, assoc.getLeftColumn());
                this.checkForColumn(rightMdTable, assoc.getRightColumn());
            }
        }
    }

    private void checkForColumn(MdTable table, String column) {
        MdColumn mdcolumn = table.findColumn(column);
        if (mdcolumn == null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNKNOWN_COLUMN_IN_ASSOCIATION, FeedbackMessage.FeedbackSeverity.ERROR, column, table.getName(), this.m_RelationalObject));
        }
    }

    protected void checkForUnjoinedTables() {
        HashSet<TableType> joinedTables = new HashSet<TableType>();
        List<Table> tables = this.m_PhysDef.getTables();
        if (tables.size() > 1) {
            joinedTables.addAll(this.m_PhysDef.getJoinedTables());
            for (Table someTable : new ArrayList<Table>(this.m_PhysDef.getUnJoinedTables())) {
                FmFeedbackMessage msg = new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNJOINED_TABLE, FeedbackMessage.FeedbackSeverity.ERROR, someTable.getName(), this.m_RelationalObject.getName(), this.m_RelationalObject);
                msg.addNamedParameter("table", someTable.getName());
                msg.addNamedParameter("datasource", someTable.getDataSource());
                this.addMessage(msg);
            }
            int j = 0;
            while (j < tables.size()) {
                FmTable someTable = (FmTable)tables.get(j);
                if (joinedTables.contains(someTable.getTableType())) {
                    int i = j + 1;
                    while (i < tables.size()) {
                        FmTable someTable1 = (FmTable)tables.get(i);
                        if (joinedTables.contains(someTable1.getTableType())) {
                            FmRoutes routes = new FmRoutes(this.m_PhysDef.getSession().m_RoutesGovernor.get(), 7, false);
                            routes.compute(someTable, someTable1);
                            if (routes.size() < 1) {
                                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNJOINED_TABLE_ROUTE, FeedbackMessage.FeedbackSeverity.ERROR, someTable.getName(), someTable1.getName(), this.m_RelationalObject));
                            }
                        }
                        ++i;
                    }
                }
                ++j;
            }
        }
    }

    protected void checkForMultipleJoins() {
        List<Table> tables = this.m_PhysDef.getTables();
        for (Table table1 : tables) {
            for (Table table2 : tables) {
                List<Join> joins;
                if (table1.equals(table2) || (joins = table1.getLeftToRightJoins(table2)).size() <= 1) continue;
                FmFeedbackMessage msg = new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_JOINED_TABLES, FeedbackMessage.FeedbackSeverity.ERROR, table1.getName(), table2.getName(), this.m_RelationalObject);
                FmFeedbackContext context = new FmFeedbackContext();
                context.addContextTable(table1);
                context.addContextTable(table2);
                for (Join join : joins) {
                    context.addContextJoin(join);
                }
                msg.setContext(context);
                this.addMessage(msg);
            }
        }
    }

    protected void checkAmbiguousJoinPath() {
        List<Table> tables = this.m_PhysDef.getTables();
        for (Table table1 : tables) {
            for (Table table2 : tables) {
                FmRoutes<FmTable, FmJoin> routes;
                if (table1.equals(table2) || (routes = this.getRoutesCache().compute((FmTable)table1, (FmTable)table2, false)).size() <= 1) continue;
                FmFeedbackMessage msg = new FmFeedbackMessage(FeedbackMessage.FeedbackCode.AMBIGUOUS_JOIN_PATH, FeedbackMessage.FeedbackSeverity.ERROR, table1.getName(), table2.getName(), this.m_RelationalObject);
                FmFeedbackContext context = new FmFeedbackContext();
                context.addContextTable(table1);
                context.addContextTable(table2);
                context.setRoutes(routes);
                msg.setContext(context);
                this.addMessage(msg);
            }
        }
    }

    protected void checkForCircularJoins() {
        TreeSet<FmTable> identifiedTables = new TreeSet<FmTable>();
        for (Table tableFoo : this.m_PhysDef.getTables()) {
            FmRoutes<FmTable, FmJoin> routes;
            FmTable table = (FmTable)tableFoo;
            if (identifiedTables.contains(table) || (routes = this.getRoutesCache().compute(table, table, false)).size() <= 0) continue;
            for (FmRoute<FmTable, FmJoin> route : routes.getAllRoutes()) {
                for (FmJoin join : route.getJoinList()) {
                    identifiedTables.add(join.getLeft());
                    identifiedTables.add(join.getRight());
                }
            }
            FmFeedbackMessage msg = new FmFeedbackMessage(FeedbackMessage.FeedbackCode.CIRCULAR_JOINS, FeedbackMessage.FeedbackSeverity.ERROR, table.getName(), this.m_RelationalObject);
            FmFeedbackContext cxt = new FmFeedbackContext();
            cxt.setRoutes(routes);
            msg.setContext(cxt);
            this.addMessage(msg);
        }
    }

    protected void checkRefrencedTablesAndColumns() {
        List<Table> tables = this.m_PhysDef.getTables();
        for (Table table : tables) {
            MdTable mdTable = table.getPhysicalTable(false);
            if (mdTable == null) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_REFRENCED_TABLE, FeedbackMessage.FeedbackSeverity.ERROR, table.getTableName(), this.m_RelationalObject.getName(), this.m_RelationalObject));
                continue;
            }
            List<QueryItemMapping> mapppings = table.getQueryItemMappings();
            for (QueryItemMapping mappping : mapppings) {
                MdColumn col = mdTable.findColumn(mappping.getColumnName());
                if (col != null) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_REFRENCED_COLUMN, FeedbackMessage.FeedbackSeverity.ERROR, mappping.getColumnName(), table.getTableName(), this.m_RelationalObject.getName(), (FmBaseObject)this.m_RelationalObject));
            }
        }
    }

    protected void checkRelationalFilters() {
        FmCube cube = this.m_RelationalObject.getCube();
        if (cube != null && cube.isAggregateCube()) {
            return;
        }
        for (RelationalFilter filter : this.m_RelationalObject.getAllFilters()) {
            RelationalFilterAnalyser analyser = new RelationalFilterAnalyser(this);
            analyser.analyse((FmRelationalFilter)filter);
        }
    }

    protected void checkForMultipleJoinsWithOuterJoin() {
        block0: for (Table table : this.m_RelationalObject.getTables()) {
            List<Join> joins = this.m_RelationalObject.getJoins(table);
            if (joins.size() <= 1) continue;
            for (Join join : joins) {
                if (join.getRightTable().equals(table) && join.getRightMincard().equals((Object)Cardinality.ECardinality.zero)) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_JOINS_TO_ATTRIBUTE_TABLE, FeedbackMessage.FeedbackSeverity.ERROR, table.getName(), this.m_RelationalObject.getName(), this.m_RelationalObject));
                    continue block0;
                }
                if (!join.getLeftTable().equals(table) || !join.getLeftMincard().equals((Object)Cardinality.ECardinality.zero)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_JOINS_TO_ATTRIBUTE_TABLE, FeedbackMessage.FeedbackSeverity.ERROR, table.getName(), this.m_RelationalObject.getName(), this.m_RelationalObject));
                continue block0;
            }
        }
    }

    protected void checkMissingKeyForDeterminant() {
        for (Table table : this.m_PhysDef.getTables()) {
            if (table.getTableDeterminants().isEmpty()) continue;
            List<TableDeterminant> dets = table.getTableDeterminants();
            for (TableDeterminant tblDet : dets) {
                if (!tblDet.getKeys().isEmpty()) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_KEY_FOR_DETERMINANT, FeedbackMessage.FeedbackSeverity.ERROR, tblDet.getName(), table.getName(), this.m_RelationalObject.getName(), (FmBaseObject)this.m_RelationalObject));
            }
        }
    }

    protected void checkDuplicateDeterminant() {
        for (Table table : this.m_PhysDef.getTables()) {
            if (table.getTableDeterminants().isEmpty() || table.getTableDeterminants().size() <= 1) continue;
            List<TableDeterminant> dets = table.getTableDeterminants();
            for (TableDeterminant tblDet : dets) {
                int i = dets.indexOf(tblDet) + 1;
                while (i < dets.size()) {
                    TableDeterminant tblDet1 = dets.get(i);
                    if (tblDet.getKeys().size() == tblDet1.getKeys().size()) {
                        int found = 0;
                        block3: for (String key : tblDet.getKeys()) {
                            for (String key1 : tblDet1.getKeys()) {
                                if (!key.equals(key1)) continue;
                                ++found;
                                continue block3;
                            }
                        }
                        if (found != 0 && tblDet.getKeys().size() == found) {
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DUPLICATE_DETERMINANT, FeedbackMessage.FeedbackSeverity.ERROR, tblDet.getName(), tblDet1.getName(), table.getName(), this.m_RelationalObject.getName(), (FmBaseObject)this.m_RelationalObject));
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected void checkDeterminantSettings() {
        for (Table table : this.m_PhysDef.getTables()) {
            if (table.getTableDeterminants().isEmpty()) continue;
            List<TableDeterminant> dets = table.getTableDeterminants();
            for (TableDeterminant tblDet : dets) {
                if (tblDet.isCanGroup() && tblDet.isIdentifiesRow()) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNIQ_GROUPBY_SETTINGS, FeedbackMessage.FeedbackSeverity.WARNING, tblDet.getName(), table.getTableName(), this.m_RelationalObject.getName(), (FmBaseObject)this.m_RelationalObject));
                }
                if (tblDet.isCanGroup() || tblDet.isIdentifiesRow()) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNIQ_GROUPBY_SETTINGS_OFF, FeedbackMessage.FeedbackSeverity.WARNING, tblDet.getName(), table.getTableName(), this.m_RelationalObject.getName(), (FmBaseObject)this.m_RelationalObject));
            }
        }
    }

    protected void checkMissingDeterminantForBlobDataType() {
        block0: for (Table table : this.m_PhysDef.getTables()) {
            if (table.getPhysicalTable(true) == null) continue;
            List<MdColumn> columns = table.getPhysicalTable(true).getColumns();
            for (MdColumn col : columns) {
                if (!FmDatatype.isBlobType(col.getDatatype()).booleanValue()) continue;
                List<TableDeterminant> dets = table.getTableDeterminants();
                if (dets.size() >= 1) continue block0;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_DET_FOR_BLOB, FeedbackMessage.FeedbackSeverity.ERROR, table.getName(), this.m_RelationalObject.getName(), this.m_RelationalObject));
                continue block0;
            }
        }
    }

    protected void checkDeterminantforColRef() {
        for (Table table : this.m_PhysDef.getTables()) {
            if (table.getTableDeterminants().isEmpty()) continue;
            ArrayList<MdColumn> referencedCols = new ArrayList<MdColumn>();
            ArrayList<String> refCols = new ArrayList<String>();
            if (table.getPhysicalTable(true) == null) continue;
            List<MdColumn> columns = table.getPhysicalTable(true).getColumns();
            referencedCols.addAll(columns);
            for (TableDeterminant tblDet : table.getTableDeterminants()) {
                refCols.addAll(tblDet.getAttributes());
                refCols.addAll(tblDet.getKeys());
            }
            for (String refCol : refCols) {
                for (MdColumn col : columns) {
                    if (!refCol.equals(col.getName())) continue;
                    referencedCols.remove(col);
                }
            }
            if (referencedCols.isEmpty()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MISSING_COL_REF, FeedbackMessage.FeedbackSeverity.ERROR, table.getName(), this.m_RelationalObject.getName(), this.m_RelationalObject));
        }
    }
}

