/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalFilterAnalyser
extends AnalyserBase<FmRelationalFilter> {
    public RelationalFilterAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public RelationalFilterAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmRelationalFilter obj) {
        Cube cube = obj.getRelationalParent().getCube();
        if (cube != null && cube.isAggregateCube()) {
            return;
        }
        FmExpression expr = (FmExpression)obj.getExpression();
        boolean isEmpty = this.checkEmptyExpression(obj, expr);
        if (!isEmpty) {
            this.testExpressionFilter(obj, expr);
        }
    }

    protected void testExpressionFilter(FmRelationalFilter item, FmExpression expression) {
        String itemPath = item.getParent().getID();
        RelationalObject ro = item.getRelationalParent();
        FmMDException.ASSERT(ro != null, "Unknown relational ancestor for " + item.getID());
        if (expression.isMacro()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.UNABLE_TO_REWRITE_EXPRESSION, FeedbackMessage.FeedbackSeverity.WARNING, expression.getExpressionText(), itemPath, item));
            return;
        }
        List<Object> objs = expression.getComponents();
        for (Object obj : objs) {
            if (obj instanceof FmQueryItemBase) {
                FmQueryItemBase qiRef = (FmQueryItemBase)obj;
                RelationalObject roRef = qiRef.getRelationalParent();
                FmMDException.ASSERT(roRef != null, "Unknown relational ancestor for " + qiRef.getID());
                if (!(ro instanceof RelationalDimension) || roRef instanceof MeasureDimension || ro.equals(roRef)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_REFERENCE_IN_ATTRIBUTE_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), roRef.getName(), qiRef.getID(), (FmBaseObject)item));
                continue;
            }
            if (obj instanceof String) {
                if (!((String)obj).equals("") || objs.size() != 1) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.EMPTY_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, item.getName(), ro.getName(), item));
                continue;
            }
            if (obj instanceof FmUnresolvedReference) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_OBJECT_IN_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, ((FmUnresolvedReference)obj).getReference(), item.getName(), item));
                continue;
            }
            FmMDException.ASSERT(false, "Unexpected object in QueryItemBaseAnalyserBase: " + obj.getClass().toString());
        }
    }
}

