/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.QueryItemAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.RelationalAnalyserBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationalParameterMapAnalyser
extends RelationalAnalyserBase<FmRelationalParameterMap> {
    public RelationalParameterMapAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public RelationalParameterMapAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmRelationalParameterMap obj) {
        this.init(obj);
        List<QueryItem> queryItems = obj.getAllQueryItems();
        if (queryItems.size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.QUERY_SUBJECT_HAS_NO_QUERY_ITEMS, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), obj));
        } else {
            QueryItemAnalyser analyser = new QueryItemAnalyser(this);
            for (QueryItem item : queryItems) {
                analyser.analyse((FmQueryItem)item);
            }
        }
        this.checkJoinAssociations();
        this.checkForUnjoinedTables();
        this.checkForMultipleJoins();
        this.checkForCircularJoins();
        this.checkAmbiguousJoinPath();
        this.validateMultilingualNames(obj);
        this.checkForMultipleJoinsWithOuterJoin();
        this.checkForInvalidROLAPCharacter(obj);
        this.checkRelationalFilters();
        this.checkForKeyAndValue(obj);
        this.checkDefaultValue(obj);
    }

    private void checkDefaultValue(FmRelationalParameterMap obj) {
        if (obj.getDefaultValue() == null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_DEFAULT_VALUE, FeedbackMessage.FeedbackSeverity.WARNING, obj.getName(), obj));
        }
    }

    private void checkForKeyAndValue(FmRelationalParameterMap obj) {
        if (obj.getKey() == null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_KEY_FOR_PARAMETER_MAP, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
        }
        if (obj.getValue() == null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_VALUE_FOR_PARAMETER_MAP, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
        }
    }
}

