/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmUnresolvedReference;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.RelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipAnalyser
extends AnalyserBase<FmRelationship> {
    public RelationshipAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public RelationshipAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmRelationship obj) {
        FmBaseObject parent = (FmBaseObject)obj.getParent();
        this.checkForInvalidTable(parent, obj);
        this.checkForMultipleTables(parent, obj);
        this.checkExpression(parent, obj);
        this.checkMeasureDimensionCardinality(parent, obj);
        this.checkDimensionRelationshipForForeignKeys(parent, obj);
    }

    private void checkDimensionRelationshipForForeignKeys(FmBaseObject parent, FmRelationship obj) {
        for (Object component : obj.getExpression().getComponents()) {
            MdColumn column;
            ColumnReference colRef;
            if (!(component instanceof ColumnReference) || !((colRef = (ColumnReference)component).getRelationalObject() instanceof RelationalDimension) || (column = colRef.getRelationalObject().getSession().findPhysicalColumn(colRef, false)) == null || !column.isForeignKey()) continue;
            FmRelationalDimension dim = null;
            FmReportObject measDim = null;
            if (obj.getLeftEnd().equals(colRef.getRelationalObject())) {
                dim = (FmRelationalDimension)obj.getLeftEnd();
                measDim = (FmReportObject)((Object)obj.getRightEnd());
            } else {
                dim = (FmRelationalDimension)obj.getRightEnd();
                measDim = (FmReportObject)((Object)obj.getLeftEnd());
            }
            if (measDim.getParent() instanceof Cube) {
                measDim = (FmReportObject)measDim.getParent();
            }
            FmFeedbackMessage msg = new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_FOREIGN_KEY_IN_RELATIONSHIP, FeedbackMessage.FeedbackSeverity.ERROR, measDim.getName(), dim.getName(), colRef.getTableName(), colRef.getColumnName(), (FmBaseObject)measDim, (FmBaseObject)dim);
            msg.addNamedParameter("table", colRef.getTableName());
            msg.addNamedParameter("column", colRef.getColumnName());
            this.addMessage(msg);
        }
    }

    private void checkForMultipleTables(FmBaseObject parent, FmRelationship relationship) {
        HashMap sortedRefs = new HashMap();
        for (Object object : relationship.getExpression().getComponents()) {
            if (!(object instanceof ColumnReference)) continue;
            ColumnReference cRef = (ColumnReference)object;
            RelationalObject relObj = cRef.getRelationalObject();
            List<ColumnReference> refList = null;
            if (sortedRefs.containsKey(relObj)) {
                refList = (List)sortedRefs.get(relObj);
            } else {
                refList = new ArrayList();
                sortedRefs.put(relObj, refList);
            }
            refList.add(cRef);
        }
        for (Map.Entry entry : sortedRefs.entrySet()) {
            RelationalObject obj = (RelationalObject)entry.getKey();
            List colRefs = (List)sortedRefs.get(obj);
            if (colRefs.size() <= 1) continue;
            int i = 0;
            while (i < colRefs.size() - 1) {
                ColumnReference first = (ColumnReference)colRefs.get(i);
                ColumnReference second = (ColumnReference)colRefs.get(i + 1);
                if (!first.getTableName().equals(second.getTableName()) || !first.getDataSource().equals(second.getDataSource())) {
                    if (obj instanceof RelationalQuerySubject) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_TABLES_DIMENSION_JOIN, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), relationship.getOtherSide((FmRelationalObject)obj).getName(), relationship, (FmBaseObject)((FmRelationalObject)obj)));
                    } else {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_TABLES_DIMENSION_JOIN, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), parent.getName(), relationship, (FmBaseObject)((FmRelationalObject)obj)));
                    }
                }
                ++i;
            }
        }
    }

    private void checkForInvalidTable(FmBaseObject parent, FmRelationship someRel) {
        for (Object obj : someRel.getExpression().getComponents()) {
            ColumnReference cRef;
            RelationalObject relObj;
            Table table;
            if (!(obj instanceof ColumnReference) || (table = (relObj = (cRef = (ColumnReference)obj).getRelationalObject()).findTable(cRef.getDataSource(), cRef.getTableName())) != null) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_TABLE_IN_RELATIONSHIP, FeedbackMessage.FeedbackSeverity.ERROR, relObj.getName(), parent.getName(), cRef.getTableName(), (FmBaseObject)someRel));
            break;
        }
    }

    private void checkExpression(FmBaseObject parent, FmRelationship someRel) {
        Expression expression = someRel.getExpression();
        int queryItemCount = 0;
        int columnReferenceCount = 0;
        for (Object obj : expression.getComponents()) {
            if (obj instanceof FmQueryItem) {
                ++queryItemCount;
                continue;
            }
            if (obj instanceof ColumnReference) {
                ++columnReferenceCount;
                continue;
            }
            if (!(obj instanceof FmUnresolvedReference)) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_OBJECT_IN_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, ((FmUnresolvedReference)obj).getReference(), someRel));
        }
        if (queryItemCount == 0 && columnReferenceCount == 0) {
            if (someRel.getLeftEnd() instanceof RelationalQuerySubject && someRel.getRightEnd() instanceof RelationalQuerySubject) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_RELATIONSHIP_EXPRESSION_QUERY_SUBJECT, FeedbackMessage.FeedbackSeverity.ERROR, someRel.getLeftEnd().getName(), someRel.getRightEnd().getName(), (FmBaseObject)((Object)someRel.getLeftEnd())));
            } else if (!someRel.isSelfJoin(true)) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_RELATIONSHIP_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, someRel.getLeftEnd().getName(), someRel.getRightEnd().getName(), parent.getName(), parent));
            }
        } else if (queryItemCount % 2 == 1) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_RELATIONSHIP_EXPRESSION, FeedbackMessage.FeedbackSeverity.ERROR, someRel.getLeftEnd().getName(), someRel.getRightEnd().getName(), parent.getName(), parent));
        }
    }

    private void checkMeasureDimensionCardinality(FmBaseObject parent, FmRelationship someRel) {
        MeasureDimension measDim = null;
        if (someRel.getLeftEnd() instanceof MeasureDimension) {
            measDim = (MeasureDimension)someRel.getLeftEnd();
        } else if (someRel.getRightEnd() instanceof MeasureDimension) {
            measDim = (MeasureDimension)someRel.getRightEnd();
        }
        if (measDim != null && !someRel.isSelfJoin(true)) {
            RelationalDimension dimSide = null;
            Cardinality.ECardinality measSideMin = Cardinality.ECardinality.unknown;
            Cardinality.ECardinality dimSideMin = Cardinality.ECardinality.unknown;
            Cardinality.ECardinality dimSideMax = Cardinality.ECardinality.unknown;
            if (someRel.getLeftEnd().equals(measDim)) {
                dimSide = (RelationalDimension)someRel.getRightEnd();
                measSideMin = someRel.getLeftMincard();
                dimSideMin = someRel.getRightMincard();
                dimSideMax = someRel.getRightMaxcard();
            } else if (someRel.getRightEnd().equals(measDim)) {
                dimSide = (RelationalDimension)someRel.getLeftEnd();
                measSideMin = someRel.getRightMincard();
                dimSideMin = someRel.getLeftMincard();
                dimSideMax = someRel.getLeftMaxcard();
            }
            if (dimSide != null) {
                String dimPath = dimSide.getParent().getID();
                String measDimPath = measDim.getParent().getID();
                if (dimSideMax == Cardinality.ECardinality.many) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_CARDINALITY, FeedbackMessage.FeedbackSeverity.ERROR, dimSide.getName(), measDim.getName(), dimSide.getParent().getID(), measDim.getParent().getID(), parent.getName(), parent));
                }
                if (dimSideMin == Cardinality.ECardinality.zero || measSideMin == Cardinality.ECardinality.zero) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_CARDINALITY, FeedbackMessage.FeedbackSeverity.ERROR, dimSide.getName(), measDim.getName(), dimPath, measDimPath, parent.getName(), parent));
                }
            }
        }
    }
}

