/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelativeTimeMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.RelativeTimeMember;
import java.math.BigInteger;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelativeTimeAnalyser
extends AnalyserBase<FmRelativeTimeMember> {
    private FmRelativeTimeMember m_rtMember = null;

    public RelativeTimeAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public RelativeTimeAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmRelativeTimeMember obj) {
        this.m_rtMember = obj;
        this.validateRelativeTimeMembers(obj);
        this.validateMultilingualNames(obj);
    }

    private void validateRelativeTimeMembers(FmRelativeTimeMember rtMember) {
        if (rtMember.getRelativeTimeMemberStyle() == RelativeTimeMember.RelativeTimeMemberStyle.simple) {
            this.checkLevelStyle(rtMember.getTargetPeriod());
            this.checkLevelStyle(rtMember.getContextPeriod());
            this.checkValidContextPeriod(rtMember.getContextPeriod(), rtMember.getTargetPeriod());
            this.checkTargetAndContextPeriod(rtMember.getTargetPeriod(), rtMember.getContextPeriod());
            this.checkContextPeriodForHighestTargetLevel(rtMember.getTargetPeriod(), rtMember.getContextPeriod());
            this.checkContextPeriodOffset(rtMember.getContextPeriod());
        } else if (rtMember.getRelativeTimeMemberStyle() == RelativeTimeMember.RelativeTimeMemberStyle.periodToDate) {
            this.checkLevelStyle(rtMember.getTargetPeriod());
            this.checkLevelStyle(rtMember.getContextPeriod());
            this.checkTargetAndContextPeriod(rtMember.getTargetPeriod(), rtMember.getContextPeriod());
            this.checkValidContextPeriod(rtMember.getContextPeriod(), rtMember.getTargetPeriod());
            this.checkContextPeriodForHighestTargetLevel(rtMember.getTargetPeriod(), rtMember.getContextPeriod());
            this.checkContextPeriodOffset(rtMember.getContextPeriod());
            if (!this.m_rtMember.isLifeToDate()) {
                this.checkHighestLevel(rtMember.getTargetPeriod());
            }
            if (rtMember.getToDatePeriod() != null) {
                this.checkLevelStyle(rtMember.getToDatePeriod());
                this.checkTargetAndTodatePeriod(rtMember.getTargetPeriod(), rtMember.getToDatePeriod());
            }
        } else if (rtMember.getRelativeTimeMemberStyle() == RelativeTimeMember.RelativeTimeMemberStyle.rollingTotal) {
            this.checkLevelStyle(rtMember.getTargetPeriod());
            this.checkLevelStyle(rtMember.getContextPeriod());
            this.checkValidContextPeriod(rtMember.getContextPeriod(), rtMember.getTargetPeriod());
            this.checkTargetAndContextPeriod(rtMember.getTargetPeriod(), rtMember.getContextPeriod());
            this.checkNumberOfPeriods(this.m_rtMember.getNumberOfPeriods());
            this.checkHighestLevel(rtMember.getTargetPeriod());
            this.checkContextPeriodOffset(rtMember.getContextPeriod());
        }
    }

    private void checkTargetAndContextPeriod(LevelReference target, LevelReference context) {
        if (context == null) {
            return;
        }
        List<LevelReference> levels = target.getHierarchy().getLevelReferences();
        if (levels.indexOf(target) > 0 && levels.indexOf(context) >= levels.indexOf(target)) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_CONTEXT_PERIOD, FeedbackMessage.FeedbackSeverity.ERROR, context.getName(), target.getName(), this.m_rtMember.getName(), (FmBaseObject)this.m_rtMember));
        }
    }

    private void checkContextPeriodForHighestTargetLevel(LevelReference target, LevelReference context) {
        if (target == null) {
            return;
        }
        List<LevelReference> levels = target.getHierarchy().getLevelReferences();
        if (levels.indexOf(target) == 0 && context != null) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_CONTEXT_PERIOD_3, FeedbackMessage.FeedbackSeverity.ERROR, target.getName(), this.m_rtMember.getName(), this.m_rtMember));
        }
    }

    private void checkTargetAndTodatePeriod(LevelReference target, LevelReference toDate) {
        if (target == null || toDate == null) {
            return;
        }
        List<LevelReference> levels = target.getHierarchy().getLevelReferences();
        if (!this.m_rtMember.isLifeToDate() && levels.indexOf(toDate) >= levels.indexOf(target)) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_TODATE_PERIOD, FeedbackMessage.FeedbackSeverity.ERROR, toDate.getName(), target.getName(), this.m_rtMember.getName(), (FmBaseObject)this.m_rtMember));
        }
    }

    private void checkLevelStyle(LevelReference levelReference) {
        if (levelReference != null && !levelReference.getLevel().isTimeLevel()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVELS_TYPE_IS_WRONG, FeedbackMessage.FeedbackSeverity.ERROR, levelReference.getHierarchy().getName(), levelReference.getName(), (FmBaseObject)((Object)levelReference.getHierarchy())));
        }
    }

    private void checkValidContextPeriod(LevelReference context, LevelReference target) {
        List<LevelReference> levels = target.getHierarchy().getLevelReferences();
        if (context == null && levels.indexOf(target) > 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_CONTEXT_PERIOD_2, FeedbackMessage.FeedbackSeverity.ERROR, target.getName(), this.m_rtMember.getName(), this.m_rtMember));
        }
    }

    private void checkHighestLevel(LevelReference target) {
        List<LevelReference> levels = target.getHierarchy().getLevelReferences();
        if (levels.size() == 0) {
            return;
        }
        if (levels.indexOf(target) == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_HIGHEST_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, target.getName(), this.m_rtMember.getName(), this.m_rtMember));
        }
    }

    private void checkNumberOfPeriods(BigInteger value) {
        if (value.intValue() <= 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_NUM_PERIODS, FeedbackMessage.FeedbackSeverity.ERROR, String.valueOf(value), this.m_rtMember.getName(), this.m_rtMember));
        }
    }

    private void checkContextPeriodOffset(LevelReference context) {
        if (context == null && this.m_rtMember.getContextPeriodOffset().intValue() != 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.INVALID_CONTEXT_PERIOD_OFFSET, FeedbackMessage.FeedbackSeverity.ERROR, String.valueOf(this.m_rtMember.getContextPeriodOffset()), this.m_rtMember.getName(), this.m_rtMember));
        }
    }
}

