/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualDimensionAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualMeasureDimensionAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasureDimension;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualCubeAnalyser
extends AnalyserBase<FmVirtualCube> {
    private List<VirtualHierarchy> m_Hiers;
    private List<VirtualHierarchy> m_Hiers1;
    private List<VirtualLevel> m_Levels;
    private FmVirtualCube v_Cube;

    public VirtualCubeAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public VirtualCubeAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmVirtualCube vCube) {
        this.checkForInvalidROLAPCharacter(vCube);
        this.v_Cube = vCube;
        List<VirtualDimensionBase> alldims = vCube.getDimensions();
        this.checkForVirtualDimension(this.v_Cube, alldims);
        this.checkForVirtualMeasureDimension(this.v_Cube, alldims);
        this.checkSourceObjects(this.v_Cube);
        this.checkForDimInSameModelSharingConflict(this.v_Cube);
        this.checkDuplicateSourceDimensions(alldims);
        VirtualDimensionAnalyser dimAnalyser = new VirtualDimensionAnalyser(this);
        VirtualMeasureDimensionAnalyser vMeasAnalyser = new VirtualMeasureDimensionAnalyser(this);
        this.checkForBadCubeName(vCube);
        for (VirtualDimensionBase di : alldims) {
            if (di instanceof FmVirtualDimension) {
                dimAnalyser.analyse((FmVirtualDimension)di);
            }
            if (!(di instanceof FmVirtualMeasureDimension)) continue;
            vMeasAnalyser.analyse((FmVirtualMeasureDimension)di);
        }
        this.validateVirtualCube(alldims);
    }

    public void validateVirtualCube(List<VirtualDimensionBase> dims) {
        for (VirtualDimensionBase dim : dims) {
            if (!(dim instanceof VirtualDimension)) continue;
            List<SourceObject> sdimObjs = dim.getSourceObjects();
            for (SourceObject dimObj : sdimObjs) {
                this.m_Hiers = ((FmVirtualDimension)dim).getHierarchies();
                for (VirtualHierarchy hier : this.m_Hiers) {
                    List<SourceObject> sheirObjs = hier.getSourceObjects();
                    if (sheirObjs == null) continue;
                    for (SourceObject obj1 : sheirObjs) {
                        this.m_Levels = hier.getLevels();
                        int i = dims.indexOf(dim) + 1;
                        while (i < dims.size()) {
                            VirtualDimensionBase dim1 = dims.get(i);
                            this.checkDuplicateSourceHierarchy(dimObj, hier, obj1, dim1, dim);
                            ++i;
                        }
                    }
                }
            }
        }
    }

    public void checkDuplicateSourceHierarchy(SourceObject dimObj, VirtualHierarchy hier, SourceObject obj1, VirtualDimensionBase dim1, VirtualDimensionBase dim) {
        boolean found = false;
        boolean modelSource = false;
        boolean parentSource = false;
        boolean dimSource = false;
        boolean dimCubeSource = false;
        if (dim1 instanceof VirtualDimension) {
            List<SourceObject> sdimObjs1 = dim1.getSourceObjects();
            for (SourceObject dimObj1 : sdimObjs1) {
                this.m_Hiers1 = ((VirtualDimension)dim1).getHierarchies();
                for (VirtualHierarchy hier1 : this.m_Hiers1) {
                    List<SourceObject> sObjs1 = hier1.getSourceObjects();
                    if (sObjs1 == null) continue;
                    for (SourceObject obj2 : sObjs1) {
                        if (obj2 == null) continue;
                        modelSource = obj1.compareSource(obj2);
                        parentSource = obj1.getCubeSource().equals(obj2.getCubeSource());
                        dimCubeSource = dimObj.getCubeSource().equals(dimObj1.getCubeSource());
                        dimSource = obj1.getSourceParent().getSourceName().equals(obj2.getSourceParent().getSourceName());
                        boolean bl = found = modelSource && parentSource && dimCubeSource && dimSource;
                        if (found) {
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_HEIR, FeedbackMessage.FeedbackSeverity.ERROR, obj1.getName(), dim1.getID(), this.v_Cube));
                            found = false;
                            modelSource = false;
                            parentSource = false;
                            dimCubeSource = false;
                            dimSource = false;
                        }
                        this.checkDuplicateSourceLevels(hier1.getLevels(), obj1, obj2, dimObj, dimObj1);
                    }
                }
            }
        }
    }

    public void checkDuplicateSourceDimensions(List<VirtualDimensionBase> dims) {
        boolean found = false;
        boolean modelSource = false;
        for (VirtualDimensionBase dim : dims) {
            if (!(dim instanceof VirtualDimension)) continue;
            List<SourceObject> sdimObjs = dim.getSourceObjects();
            for (SourceObject dimObj : sdimObjs) {
                int i = dims.indexOf(dim) + 1;
                while (i < dims.size()) {
                    VirtualDimensionBase dim1 = dims.get(i);
                    if (dim1 instanceof VirtualDimension) {
                        List<SourceObject> sdimObjs1 = dim1.getSourceObjects();
                        for (SourceObject dimObj1 : sdimObjs1) {
                            modelSource = dimObj.compareSource(dimObj1);
                            boolean bl = found = dimObj.getCubeSource().equals(dimObj1.getCubeSource()) && modelSource;
                            if (!found) continue;
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_DIM, FeedbackMessage.FeedbackSeverity.ERROR, dimObj.getName(), dim.getName(), dim1.getName(), (FmBaseObject)this.v_Cube));
                            found = false;
                            modelSource = false;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public void checkDuplicateSourceLevels(List<VirtualLevel> levels1, SourceObject m_obj1, SourceObject m_obj2, SourceObject m_dimobj1, SourceObject m_dimobj2) {
        boolean found = false;
        boolean modelSource = false;
        boolean cubeSource = false;
        boolean hierDimSource = false;
        boolean hierSource = false;
        boolean hierCubeSource = false;
        for (VirtualLevel level : this.m_Levels) {
            List<SourceObject> slevelObjs = level.getSourceObjects();
            for (SourceObject levelObj : slevelObjs) {
                for (VirtualLevel level1 : levels1) {
                    List<SourceObject> slevelObjs1 = level1.getSourceObjects();
                    for (SourceObject levelObj1 : slevelObjs1) {
                        boolean dimSource1 = m_dimobj1.getCubeSource().equals(m_dimobj2.getCubeSource());
                        hierCubeSource = m_obj1.getCubeSource().equals(m_obj2.getCubeSource());
                        hierDimSource = m_obj1.getSourceParent().getSourceName().equals(m_obj2.getSourceParent().getSourceName());
                        hierSource = m_obj1.getSourceName().equals(m_obj2.getSourceName());
                        modelSource = levelObj.compareSource(levelObj1);
                        cubeSource = levelObj.getCubeSource().equals(levelObj1.getCubeSource());
                        boolean bl = found = hierDimSource && modelSource && cubeSource && hierSource && hierCubeSource && dimSource1;
                        if (!found) continue;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, levelObj.getName(), this.v_Cube.getID(), this.v_Cube));
                        found = false;
                        modelSource = false;
                        cubeSource = false;
                        hierDimSource = false;
                        hierCubeSource = false;
                    }
                }
            }
        }
    }

    private void checkForVirtualDimension(FmVirtualCube cube, List<VirtualDimensionBase> dimensions) {
        for (VirtualDimensionBase dim : dimensions) {
            if (!(dim instanceof FmVirtualDimension)) continue;
            return;
        }
        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_VIRTUAL_DIMENSIONS_FOUND, FeedbackMessage.FeedbackSeverity.ERROR, cube.getName(), cube));
    }

    private void checkForVirtualMeasureDimension(FmVirtualCube cube, List<VirtualDimensionBase> dimensions) {
        VirtualMeasureDimension measDim = cube.getMeasureDimension();
        if (measDim != null) {
            return;
        }
        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_VIRTUAL_MEASURE_DIMENSIONS_FOUND, FeedbackMessage.FeedbackSeverity.ERROR, cube.getName(), cube));
    }

    private void checkForDimInSameModelSharingConflict(FmVirtualCube cube) {
        List<SourceObject> srcObjs = cube.getSourceObjects();
        for (SourceObject srcObj : srcObjs) {
            if (srcObj.isModelSource()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.VIRTUAL_DIMENSION_NONLOCAL_SHARING_CONFLICT, FeedbackMessage.FeedbackSeverity.WARNING, cube.getID(), cube));
            break;
        }
    }
}

