/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualHierarchyAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.TopLevelObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualCube;
import com.ibm.cognos.fmeng.fmmd.model.VirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualDimensionAnalyser
extends AnalyserBase<FmVirtualDimension> {
    private List<VirtualHierarchy> m_Hiers;
    private VirtualHierarchy m_Hiers1;
    private List<VirtualLevel> m_Levels;
    private SourceObject m_obj1;
    private SourceObject m_obj2;
    private FmVirtualDimension v_Dim;

    public VirtualDimensionAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public VirtualDimensionAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmVirtualDimension vDim) {
        this.checkForInvalidROLAPCharacter(vDim);
        this.v_Dim = vDim;
        this.checkSourceObjects(this.v_Dim);
        this.checkForMemberSharingConflict(this.v_Dim);
        List<VirtualHierarchy> hierarchies = vDim.getHierarchies();
        if (hierarchies.size() > 0) {
            this.checkDuplicateSourceHierarchies(hierarchies, vDim);
            VirtualHierarchyAnalyser hierAnalyser = new VirtualHierarchyAnalyser(this);
            for (VirtualHierarchy hier : hierarchies) {
                hierAnalyser.analyse((FmVirtualHierarchy)hier);
            }
        } else {
            String path = vDim.getParent().getID();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_VIRTUAL_HIERARCHIES, FeedbackMessage.FeedbackSeverity.ERROR, vDim.getName(), path, vDim));
        }
    }

    public void checkDuplicateSourceHierarchies(List<VirtualHierarchy> hierarchies, FmVirtualDimension vDim) {
        this.m_Hiers = new ArrayList<VirtualHierarchy>();
        boolean found = false;
        boolean modelSource = false;
        boolean parentSource = false;
        this.m_Hiers = hierarchies;
        if (this.m_Hiers.size() > 1) {
            for (VirtualHierarchy hier : this.m_Hiers) {
                List<SourceObject> sObjs = hier.getSourceObjects();
                if (sObjs == null) continue;
                Iterator<SourceObject> iterator = sObjs.iterator();
                while (iterator.hasNext()) {
                    SourceObject obj1;
                    this.m_obj1 = obj1 = iterator.next();
                    int i = this.m_Hiers.indexOf(hier) + 1;
                    while (i < this.m_Hiers.size()) {
                        this.m_Hiers1 = this.m_Hiers.get(i);
                        List<SourceObject> sObjs1 = this.m_Hiers1.getSourceObjects();
                        if (sObjs1 != null) {
                            Iterator<SourceObject> iterator2 = sObjs1.iterator();
                            while (iterator2.hasNext()) {
                                SourceObject obj2;
                                this.m_obj2 = obj2 = iterator2.next();
                                modelSource = obj1.compareSource(obj2);
                                parentSource = this.m_obj1.getCubeSource().equals(this.m_obj2.getCubeSource());
                                boolean bl = found = modelSource && parentSource;
                                if (found) {
                                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_HEIR, FeedbackMessage.FeedbackSeverity.ERROR, obj1.getName(), vDim.getID(), vDim));
                                    found = false;
                                    modelSource = false;
                                    parentSource = false;
                                }
                                this.checkDuplicateSourceLevels(hier, parentSource);
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void checkDuplicateSourceLevels(VirtualHierarchy hier, boolean hierSource) {
        boolean found = false;
        boolean modelSource = false;
        boolean cubeSource = false;
        boolean dimSource = false;
        boolean levelCubeSource = false;
        this.m_Levels = hier.getLevels();
        List<VirtualLevel> levels1 = this.m_Hiers1.getLevels();
        for (VirtualLevel level : this.m_Levels) {
            List<SourceObject> slevelObjs = level.getSourceObjects();
            for (SourceObject levelObj : slevelObjs) {
                for (VirtualLevel level1 : levels1) {
                    List<SourceObject> slevelObjs1 = level1.getSourceObjects();
                    for (SourceObject levelObj1 : slevelObjs1) {
                        modelSource = levelObj.compareSource(levelObj1);
                        cubeSource = this.m_obj1.getCubeSource().equals(this.m_obj2.getCubeSource());
                        levelCubeSource = levelObj.getCubeSource().equals(levelObj1.getCubeSource());
                        hierSource = this.m_obj1.getSourceName().equals(this.m_obj2.getSourceName());
                        dimSource = this.m_obj1.getSourceParent().equals(this.m_obj2.getSourceParent());
                        boolean bl = found = dimSource && modelSource && cubeSource && hierSource && levelCubeSource;
                        if (!found) continue;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, levelObj.getName(), this.v_Dim.getParent().getID(), this.v_Dim));
                        found = false;
                        modelSource = false;
                        cubeSource = false;
                        dimSource = false;
                        levelCubeSource = false;
                    }
                }
            }
        }
    }

    private void checkForMemberSharingConflict(FmVirtualDimension dim) {
        if (dim.isSharingEnabledOnBaseDimensions() && !dim.leverageSharedMemberCache() && !dim.doNamesMatchWithSourceObjects()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.VIRTUAL_DIMENSION_MEMBER_SHARING_NAME_CONFLICTS, FeedbackMessage.FeedbackSeverity.WARNING, dim.getName(), dim.getID(), dim));
        }
    }

    @Override
    public void checkSourceObjects(FmVirtualObject obj) {
        super.checkSourceObjects(obj);
        List<SourceObject> sources = obj.getSourceObjects();
        if (sources == null) {
            return;
        }
        for (SourceObject source : sources) {
            List<DimensionBase> sourceDimensions;
            String name;
            TopLevelObject modelSource;
            SourceObject sourceParent;
            TopLevelObject sourceDimension;
            if (!source.isModelSource() || (sourceDimension = source.getModelSource()) == null || (sourceParent = source.getSourceParent()) == null || (modelSource = sourceParent.getModelSource()) == null) continue;
            BaseObject parent = obj.getParent();
            String string = name = parent == null ? "" : parent.getName();
            if (modelSource instanceof Cube) {
                sourceDimensions = ((Cube)modelSource).getAllReferencedDimensions();
                if (sourceDimensions.contains(sourceDimension)) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_SOURCE_OBJECTS_DIMENSION, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), modelSource.getName(), name, (FmBaseObject)obj));
                continue;
            }
            if (!(modelSource instanceof VirtualCube) || (sourceDimensions = ((VirtualCube)modelSource).getDimensions()).contains(sourceDimension)) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_SOURCE_OBJECTS_DIMENSION, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), modelSource.getName(), name, (FmBaseObject)obj));
        }
    }
}

