/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualLevelAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.VirtualMemberAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualDimension;
import com.ibm.cognos.fmeng.fmmd.model.VirtualLevel;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMember;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHierarchyAnalyser
extends AnalyserBase<FmVirtualHierarchy> {
    public VirtualHierarchyAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public VirtualHierarchyAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    public void doAnalysis(FmVirtualHierarchy obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.checkSourceObjects(obj);
        this.checkForMemberSharingConflict(obj);
        if (!obj.getParentChild()) {
            List<VirtualLevel> levels = obj.getLevels();
            if (levels.size() == 0) {
                String path = obj.getParent().getID();
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.VIRTUAL_HIER_HAS_NO_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), path, obj));
            } else {
                this.checkDuplicateSourceLevels(levels, obj);
                this.checkForUnsourcedLevels(levels, obj);
                VirtualLevelAnalyser analyser = new VirtualLevelAnalyser(this);
                for (VirtualLevel level : levels) {
                    analyser.analyse((FmVirtualLevel)level);
                }
            }
        }
        VirtualMemberAnalyser analyser = new VirtualMemberAnalyser(this);
        for (VirtualMember member : obj.getVirtualMembers()) {
            analyser.analyse((FmVirtualMember)member);
        }
    }

    private void checkForUnsourcedLevels(List<VirtualLevel> levels, FmVirtualHierarchy obj) {
        for (VirtualLevel level : levels) {
            List<SourceObject> srcs = level.getSourceObjects();
            if (srcs.size() != 0) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_SOURCE_OBJECTS_LEVELS, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj));
            break;
        }
    }

    private void checkDuplicateSourceLevels(List<VirtualLevel> levels, FmVirtualHierarchy hier) {
        boolean found = false;
        boolean modelSource = false;
        boolean cubeSource = false;
        for (VirtualLevel level : levels) {
            List<SourceObject> slevelObjs = level.getSourceObjects();
            for (SourceObject levelObj : slevelObjs) {
                int i = levels.indexOf(level) + 1;
                while (i < levels.size()) {
                    VirtualLevel level1 = levels.get(i);
                    List<SourceObject> slevelObjs1 = level1.getSourceObjects();
                    for (SourceObject slevelObj1 : slevelObjs1) {
                        modelSource = levelObj.compareSource(slevelObj1);
                        cubeSource = levelObj.getCubeSource().equals(slevelObj1.getCubeSource());
                        boolean bl = found = levelObj.getSourceParent().equals(slevelObj1.getSourceParent()) && modelSource && cubeSource;
                        if (!found) continue;
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_LEVEL, FeedbackMessage.FeedbackSeverity.ERROR, levelObj.getName(), hier.getParent().getParent().getID(), hier));
                        found = false;
                        modelSource = false;
                        cubeSource = false;
                    }
                    ++i;
                }
            }
        }
    }

    private void checkForMemberSharingConflict(FmVirtualHierarchy hierarchy) {
        VirtualDimension dim = (VirtualDimension)hierarchy.getParent();
        if (dim.isSharingEnabledOnBaseDimensions() && !dim.leverageSharedMemberCache()) {
            if (!hierarchy.doNamesMatchWithSourceObjects()) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.VIRTUAL_HIERARCHY_MEMBER_SHARING_NAME_CONFLICTS, FeedbackMessage.FeedbackSeverity.WARNING, hierarchy.getName(), hierarchy.getParent().getID(), hierarchy));
            }
            if (hierarchy.getVirtualMembers().size() != 0) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.VIRTUAL_MEMBER_MEMBER_SHARING_CONFLICTS, FeedbackMessage.FeedbackSeverity.WARNING, hierarchy.getName(), hierarchy.getID(), hierarchy));
            }
        }
    }
}

