/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualLevelAnalyser
extends AnalyserBase<FmVirtualLevel> {
    public VirtualLevelAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public VirtualLevelAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmVirtualLevel obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.checkForMemberSharingConflict(obj);
    }

    private void checkForMemberSharingConflict(FmVirtualLevel level) {
        FmVirtualDimension dim = level.getDimension();
        if (dim.isSharingEnabledOnBaseDimensions() && !dim.leverageSharedMemberCache() && !level.doNamesMatchWithSourceObjects()) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.VIRTUAL_LEVEL_MEMBER_SHARING_NAME_CONFLICTS, FeedbackMessage.FeedbackSeverity.WARNING, level.getName(), level.getDimension().getID(), level));
        }
    }
}

