/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProxyMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMeasureAnalyser
extends AnalyserBase<FmVirtualMeasure> {
    private FmVirtualMeasure m_Obj;

    public VirtualMeasureAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public VirtualMeasureAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmVirtualMeasure obj) {
        this.m_Obj = obj;
        List<FmProxyMeasure> objs = this.m_Obj.getProxyMeasures();
        this.checkForInvalidROLAPCharacter(obj);
        this.checkSourceObjects(obj);
        this.checkForAggregateMeasure(objs);
    }

    protected void checkForAggregateMeasure(List<FmProxyMeasure> objs) {
        for (FmProxyMeasure pObj : objs) {
            if (!pObj.getAggregateRules().isEmpty()) {
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.AGGRE_MEASURE_UNEXPECTED_RESULTS, FeedbackMessage.FeedbackSeverity.WARNING, pObj.getName(), pObj.getCubeSource().getSourceName(), this.m_Obj));
            }
            if (!pObj.isNonDistributive()) continue;
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NONDISTRIBUTIVE_MEASURE_UNEXPECTED_RESULTS, FeedbackMessage.FeedbackSeverity.WARNING, pObj.getName(), pObj.getCubeSource().getSourceName(), this.m_Obj));
        }
    }
}

