/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmVirtualMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.SourceObject;
import com.ibm.cognos.fmeng.fmmd.model.VirtualMeasure;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualMeasureDimensionAnalyser
extends AnalyserBase<FmVirtualMeasureDimension> {
    public VirtualMeasureDimensionAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public VirtualMeasureDimensionAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmVirtualMeasureDimension obj) {
        this.checkForInvalidROLAPCharacter(obj);
        this.checkForNoVirtualMeasures(obj);
        this.checkDuplicateSourceMeasures(obj);
        this.checkSourceObjects(obj);
        this.analyseChildren(obj);
    }

    private void checkDuplicateSourceMeasures(FmVirtualMeasureDimension meas) {
        List<VirtualMeasure> measures = meas.getAllMeasures();
        if (measures.size() > 0) {
            boolean found = false;
            boolean modelSource = false;
            for (VirtualMeasure meas1 : measures) {
                if (!(meas1 instanceof VirtualMeasure)) continue;
                List<SourceObject> sMeasObjs = meas1.getSourceObjects();
                for (SourceObject sMeasObj : sMeasObjs) {
                    int i = measures.indexOf(meas1) + 1;
                    while (i < measures.size()) {
                        VirtualMeasure meas2 = measures.get(i);
                        if (meas2 instanceof VirtualMeasure) {
                            List<SourceObject> sMeasObjs2 = meas2.getSourceObjects();
                            for (SourceObject sMeasObj2 : sMeasObjs2) {
                                modelSource = sMeasObj.compareSource(sMeasObj2);
                                boolean bl = found = sMeasObj.getCubeSource().equals(sMeasObj2.getCubeSource()) && modelSource;
                                if (!found) continue;
                                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.MULTIPLE_USE_OF_SOURCE_MEASURES, FeedbackMessage.FeedbackSeverity.ERROR, sMeasObj.getName(), meas.getParent().getID(), meas));
                                found = false;
                                modelSource = false;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
    }

    private void checkForNoVirtualMeasures(FmVirtualMeasureDimension obj) {
        List<VirtualMeasure> measures = obj.getAllMeasures();
        if (measures.size() == 0) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.NO_VIRTUAL_MEASURES, FeedbackMessage.FeedbackSeverity.ERROR, obj.getName(), obj.getParent().getID(), obj));
        }
    }
}

