/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance.DimensionPerformanceAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance.MeasureDimensionPerformanceAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.ColumnReference;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CubePerformanceAnalyser
extends AnalyserBase<FmCube> {
    private FmCube m_Obj;

    public CubePerformanceAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public CubePerformanceAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmCube cube) {
        this.setContextCube(cube);
        this.m_Obj = cube;
        int count = 0;
        DimensionPerformanceAnalyser dimAnalyser = new DimensionPerformanceAnalyser(this);
        MeasureDimensionPerformanceAnalyser measAnalyser = new MeasureDimensionPerformanceAnalyser(this);
        List<RelationalDimensionBase> dimensions = cube.getReferencedDimensions();
        this.checkForKeyFilters(dimensions);
        for (RelationalDimensionBase dim : dimensions) {
            if (dim instanceof FmMeasureDimension) {
                measAnalyser.analyse((FmMeasureDimension)dim);
                continue;
            }
            dimAnalyser.analyse((FmRelationalDimension)dim);
            if (((FmRelationalDimension)dim).getParentChild()) {
                ++count;
                continue;
            }
            this.checkRelationalAndMeasureDimensionJoins((FmRelationalDimension)dim);
            this.checkRelativeTimeHierarchyAndAggregateCubes(cube, dim);
        }
        if (dimensions.size() > 15) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.CUBE_HAS_TOO_MANY_DIMENSIONS, FeedbackMessage.FeedbackSeverity.PERFORMANCE, ((FmBaseObject)cube).getName(), cube));
        }
        if (count > 2) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.CUBE_HAS_TOO_MANY_PARENT_CHILD_DIMENSIONS, FeedbackMessage.FeedbackSeverity.PERFORMANCE, ((FmBaseObject)cube).getName(), cube));
        }
    }

    private void checkForKeyFilters(List<RelationalDimensionBase> dimensions) {
        for (RelationalDimensionBase dim : dimensions) {
            if (!(dim instanceof RelationalDimension)) continue;
            for (RelationalFilter filter : dim.getAllFilters()) {
                if (!filter.getGenerateKeyFilter()) continue;
                this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.KEY_FILTER_ENABLED, FeedbackMessage.FeedbackSeverity.PERFORMANCE, filter.getName(), dim.getName(), (FmBaseObject)((Object)filter)));
            }
        }
    }

    private void checkRelativeTimeHierarchyAndAggregateCubes(FmCube cube, RelationalDimensionBase dim) {
        List<RelationalHierarchy> hierarchies = ((FmRelationalDimension)dim).getAllHierarchies();
        int i = 0;
        while (i < hierarchies.size()) {
            FmRelationalHierarchy hierarchyUnderScrutiny = (FmRelationalHierarchy)hierarchies.get(i);
            if (hierarchyUnderScrutiny.getHasRelativeTimeMembers()) {
                boolean hasAggregateCubes = false;
                int j = 0;
                while (j < this.m_Obj.getAggregateCubes().size()) {
                    hasAggregateCubes = true;
                    List<RelationalDimensionBase> dl = this.m_Obj.getAggregateCubes().get(j).getDimensions();
                    boolean dimensionNotUsed = true;
                    for (RelationalDimensionBase d : dl) {
                        if (!(d instanceof FmRelationalDimension) || !d.getName().equals(dim.getName()) || !((FmRelationalDimension)d).isRollupDimension()) continue;
                        List<RelationalHierarchy> hiers = ((FmRelationalDimension)d).getAllHierarchies();
                        for (RelationalHierarchy hier : hiers) {
                            LevelReference lref;
                            if (!hier.getName().equals(hierarchyUnderScrutiny.getName())) continue;
                            List<LevelReference> lRefs = ((FmRelationalHierarchy)hier).getLevelReferences();
                            Level lvl = hierarchyUnderScrutiny.getBottomLevel();
                            Iterator<LevelReference> iterator = lRefs.iterator();
                            if (!iterator.hasNext() || (lref = iterator.next()).getLevel().equals(lvl)) continue;
                            dimensionNotUsed = false;
                        }
                    }
                    if (dimensionNotUsed) {
                        this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.RELATIVE_TIME_HIERARCHY_WITHOUT_AGRREGATE_CUBES, FeedbackMessage.FeedbackSeverity.PERFORMANCE, hierarchyUnderScrutiny.getName(), this.m_Obj.getName(), cube));
                    }
                    ++j;
                }
                if (!hasAggregateCubes) {
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.RELATIVE_TIME_HIERARCHY_WITHOUT_AGRREGATE_CUBES, FeedbackMessage.FeedbackSeverity.PERFORMANCE, hierarchyUnderScrutiny.getName(), dim.getName(), this.m_Obj.getName(), (FmBaseObject)cube));
                }
            }
            ++i;
        }
    }

    protected void checkRelationalAndMeasureDimensionJoins(FmRelationalDimension objRegDim) {
        FMMDSession m_Session = this.m_Obj.getSession();
        FmMeasureDimension objMsrDim = (FmMeasureDimension)this.m_Obj.getMeasureDimension();
        List<Relationship> dimFactRels = objRegDim.getRelationships(objMsrDim);
        if (dimFactRels.size() == 1) {
            List<Object> expParts = dimFactRels.get(0).getExpression().getComponents();
            boolean foundColumnReferences = false;
            for (Object part : expParts) {
                if (!(part instanceof ColumnReference)) continue;
                foundColumnReferences = true;
                break;
            }
            if (!foundColumnReferences) {
                return;
            }
            ArrayList<ColumnReference> columnRefs = new ArrayList<ColumnReference>();
            int iStart = 0;
            while (iStart < expParts.size() && expParts.get(iStart) instanceof String) {
                ++iStart;
            }
            int i = iStart;
            while (i + 2 < expParts.size()) {
                FmMDException.ASSERT(expParts.get(i + 1) instanceof String, "Non-standard relationship expression.");
                if (expParts.size() > i + 3) {
                    FmMDException.ASSERT(expParts.get(i + 3) instanceof String, "Non-standard relationship expression.");
                }
                ColumnReference leftSide = this.extractSideInfo(expParts.get(i));
                ColumnReference rightSide = this.extractSideInfo(expParts.get(i + 2));
                columnRefs.add(rightSide);
                columnRefs.add(leftSide);
                i += 4;
            }
            if (columnRefs.size() > 0) {
                i = 0;
                while (i < columnRefs.size()) {
                    int j = i + 1;
                    while (j < columnRefs.size()) {
                        ColumnReference iRef = (ColumnReference)columnRefs.get(i);
                        ColumnReference jRef = (ColumnReference)columnRefs.get(j);
                        if (iRef.getColumnName().equals(jRef.getColumnName()) && iRef.getDataSource().equals(jRef.getDataSource())) {
                            FmDatatype type;
                            MdColumn iColumn = m_Session.findPhysicalColumn(iRef, false);
                            if (iColumn == null || (type = iColumn.getDatatype()).compareTo(FmDatatype.INT16) == 0 || type.compareTo(FmDatatype.INT32) == 0 || type.compareTo(FmDatatype.INT64) == 0) break;
                            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.DIMENSION_AND_FACT_JOIN_IS_NOT_INT_OR_LONG, FeedbackMessage.FeedbackSeverity.PERFORMANCE, objRegDim.getName(), objMsrDim.getName(), this.m_Obj.getName(), (FmBaseObject)this.m_Obj));
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
    }

    private ColumnReference extractSideInfo(Object object) {
        if (object instanceof ColumnReference) {
            ColumnReference cRef = (ColumnReference)object;
            return cRef;
        }
        FmMDException.ASSERT(false, "Unexpected query item in relationship");
        return null;
    }
}

