/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance.HierarchyPerformanceAnalyser;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance.LevelPerformanceAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.metadata.MdColumn;
import com.ibm.cognos.fmeng.metadata.MdTable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DimensionPerformanceAnalyser
extends AnalyserBase<FmRelationalDimension> {
    protected FmPhysicalDefinition m_PhysDef;
    protected FmRelationalObject m_RelationalObject;
    protected FmRelationalDimension m_dim;

    public DimensionPerformanceAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public DimensionPerformanceAnalyser(AnalyserConfig config) {
        super(config);
    }

    @Override
    protected void doAnalysis(FmRelationalDimension obj) {
        this.m_dim = obj;
        this.m_RelationalObject = obj;
        this.m_PhysDef = this.m_RelationalObject.getPhysicalDefinition();
        this.checkForSnowFlake();
        this.checkParentChildKeys();
        LevelPerformanceAnalyser lvlAnalyser = new LevelPerformanceAnalyser(this);
        List<Level> allLevels = obj.getAllLevels();
        for (Level level : allLevels) {
            lvlAnalyser.analyse((FmLevel)level);
        }
    }

    protected void checkForSnowFlake() {
        List<Table> tables;
        if (this.m_PhysDef != null && (tables = this.m_PhysDef.getTables()).size() > 1) {
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.SNOWFLAKED_DIMENSION, FeedbackMessage.FeedbackSeverity.PERFORMANCE, ((FmBaseObject)this.m_RelationalObject).getName(), this.m_RelationalObject));
            this.checkJoinBetweenTables();
        }
    }

    protected void checkParentChildKeys() {
        if (this.m_dim.getParentChild()) {
            HierarchyPerformanceAnalyser hierAnalyser = new HierarchyPerformanceAnalyser(this);
            for (RelationalHierarchy h : this.m_dim.getAllHierarchies()) {
                hierAnalyser.analyse((FmRelationalHierarchy)h);
            }
        }
    }

    protected void checkJoinBetweenTables() {
        List<Join> joins = this.m_dim.getJoins();
        for (Join j : joins) {
            List<Association> associations = j.getAssociations();
            for (Association a : associations) {
                String rightColumn = a.getRightColumn();
                Table leftTable = j.getLeftTable();
                Table rightTable = j.getRightTable();
                MdTable table = rightTable.getPhysicalTable(false);
                if (table == null) continue;
                List<MdColumn> mdColumns = table.getColumns();
                for (MdColumn c : mdColumns) {
                    FmDatatype columnType;
                    if (!c.getName().equals(rightColumn) || (columnType = c.getDatatype()).compareTo(FmDatatype.INT16) == 0 || columnType.compareTo(FmDatatype.INT32) == 0 || columnType.compareTo(FmDatatype.INT64) == 0) continue;
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.JOIN_BETWEEN_TABLES_IN_DIMENSION_IS_NOT_INT_OR_LONG, FeedbackMessage.FeedbackSeverity.PERFORMANCE, leftTable.getName(), rightTable.getName(), this.m_dim.getName(), (FmBaseObject)this.m_dim));
                }
            }
        }
    }
}

