/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculatedMember;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance.CalculatedMemberPerformanceAnalyser;
import com.ibm.cognos.fmeng.fmmd.model.CalculatedMember;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HierarchyPerformanceAnalyser
extends AnalyserBase<FmRelationalHierarchy> {
    public HierarchyPerformanceAnalyser(AnalyserConfig config) {
        super(config);
    }

    public HierarchyPerformanceAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    @Override
    protected void doAnalysis(FmRelationalHierarchy hier) {
        List<CalculatedMember> calcMems;
        this.checkParentChildKeys(hier);
        if (!hier.getDimension().isRollupDimension() && (calcMems = hier.getCalculatedMembers()).size() > 0) {
            CalculatedMemberPerformanceAnalyser calcAnalyser = new CalculatedMemberPerformanceAnalyser(this);
            for (CalculatedMember calcMem : calcMems) {
                calcAnalyser.analyse((FmCalculatedMember)calcMem);
            }
        }
    }

    public void checkParentChildKeys(FmRelationalHierarchy h) {
        if (h.getParentChild()) {
            QueryItem parentItem = h.getParentItem();
            QueryItem childItem = h.getChildItem();
            if (parentItem != null && childItem != null) {
                String parent;
                FmDatatype parentType = parentItem.getDatatype();
                FmDatatype childType = childItem.getDatatype();
                if (parentType.compareTo(FmDatatype.INT16) != 0 && parentType.compareTo(FmDatatype.INT32) != 0 && parentType.compareTo(FmDatatype.INT64) != 0) {
                    parent = h.getParent().getName();
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.PARENT_LEVEL_KEY_IS_NOT_INT_OR_LONG, FeedbackMessage.FeedbackSeverity.PERFORMANCE, ((FmBaseObject)((Object)h.getParentItem())).getName(), parent, h));
                }
                if (childType.compareTo(FmDatatype.INT16) != 0 && childType.compareTo(FmDatatype.INT32) != 0 && childType.compareTo(FmDatatype.INT64) != 0) {
                    parent = h.getParent().getName();
                    this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.CHILD_LEVEL_KEY_IS_NOT_INT_OR_LONG, FeedbackMessage.FeedbackSeverity.PERFORMANCE, ((FmBaseObject)((Object)h.getChildItem())).getName(), parent, h));
                }
            }
        }
    }
}

