/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObjectPerformance;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskAnalyseObject.AnalyserConfig;
import com.ibm.cognos.fmeng.fmmd.model.FeedbackMessage;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelPerformanceAnalyser
extends AnalyserBase<FmLevel> {
    FmLevel m_level;

    public LevelPerformanceAnalyser(AnalyserBase<?> obj) {
        super(obj);
    }

    public LevelPerformanceAnalyser(AnalyserConfig config) {
        super(config);
    }

    private void checkLevelKeyTypes() {
        for (QueryItem q : this.m_level.getLevelKeys()) {
            FmDatatype type = q.getDatatype();
            if (type.compareTo(FmDatatype.INT16) == 0 || type.compareTo(FmDatatype.INT32) == 0 || type.compareTo(FmDatatype.INT64) == 0) continue;
            String path = this.m_level.getParent().getParent().getName();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVEL_KEYS_ARE_NOT_INT_OR_LONG, FeedbackMessage.FeedbackSeverity.PERFORMANCE, q.getName(), ((FmBaseObject)this.m_level).getName(), path, (FmBaseObject)this.m_level));
        }
    }

    private void checkForCompositeLevelKeys() {
        List<QueryItem> keys = this.m_level.getLevelKeys();
        if (keys.size() > 1) {
            String parent = this.m_level.getParent().getParent().getName();
            this.addMessage(new FmFeedbackMessage(FeedbackMessage.FeedbackCode.LEVEL_HAS_COMPOSITE_LEVEL_KEYS, FeedbackMessage.FeedbackSeverity.PERFORMANCE, ((FmBaseObject)this.m_level).getName(), parent, this.m_level));
        }
    }

    @Override
    protected void doAnalysis(FmLevel level) {
        this.m_level = level;
        this.checkLevelKeyTypes();
        this.checkForCompositeLevelKeys();
    }
}

