/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSources;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmProject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionParent;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNode;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNodeContainer;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    protected FMMDSession m_OldSession;
    protected FMMDSession m_NewSession;
    protected List<FmMessage> m_Messages = null;

    public Builder(FMMDSession oldSession, FMMDSession newSession, List<FmMessage> messages) {
        this.m_OldSession = oldSession;
        this.m_NewSession = newSession;
        this.m_Messages = messages;
    }

    protected void extractQueryItemChain(FmTreeNodeContainer<ExpressionParent> parent, ExpressionParent qItem) {
        FmTreeNode<ExpressionParent> itemNode = parent.addChild(qItem);
        FmQueryItemBase qiActual = null;
        if (qItem instanceof FmQueryItemBase && ((FmQueryItemBase)qItem).getSourceType() != FmQueryItemBase.ESourceType.kSourceExternal) {
            qiActual = (FmQueryItemBase)qItem;
        }
        if (qiActual != null) {
            FmExpression fmExpression = (FmExpression)qItem.getExpression();
            List<ReportObject> refObjs = fmExpression.getRefObjs(true);
            if (refObjs != null) {
                for (ReportObject refObj : refObjs) {
                    if (refObj instanceof FmQueryItem) {
                        this.extractQueryItemChain(itemNode, (FmQueryItem)refObj);
                        continue;
                    }
                    if (refObj instanceof FmMeasure) {
                        this.extractQueryItemChain(itemNode, (FmMeasure)refObj);
                        continue;
                    }
                    if (refObj instanceof FmCalculation) {
                        this.extractQueryItemChain(itemNode, (FmCalculation)refObj);
                        continue;
                    }
                    if (refObj instanceof FmFilter) {
                        this.extractQueryItemChain(itemNode, (FmFilter)refObj);
                        continue;
                    }
                    if (refObj instanceof FmShortcut) {
                        FmShortcut shortcut = (FmShortcut)refObj;
                        Set<BaseObject> targets = shortcut.getReferencedObjects();
                        for (BaseObject target : targets) {
                            if (target instanceof FmQueryItem) {
                                this.extractQueryItemChain(itemNode, (FmQueryItem)target);
                                continue;
                            }
                            FmEngApplicationLog.getApplicationLog().logWarn(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, "Encountered a refobjViaShortcut while processing the expression in " + qiActual.getID() + ". Ignoring the part referring to: " + target.getID());
                        }
                        continue;
                    }
                    FmMDException.ASSERT(false, "Unidentified object: " + refObj.toString());
                }
            } else {
                String expression = fmExpression.getExpressionText();
                FmMDException.ASSERT(expression != null, "An expression with no refobjs? " + expression);
            }
        }
    }

    protected FmDataSource findOrCopyDataSource(BaseObject srcObj, FmProject destProject, String dsName) {
        DataSource srcDS;
        FmDataSources dataSources = destProject.getDataSourcesFolder();
        FmDataSource ds = dataSources.findDataSource(dsName);
        if (ds == null && (srcDS = srcObj.getProject().findDataSource(dsName)) != null) {
            ds = destProject.createDataSource(srcDS, dsName);
        }
        FmMDException.ASSERT(ds != null, "Couldn't find a data source named " + dsName + ".");
        return ds;
    }
}

