/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmNamespace;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationshipBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.Builder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.DimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.JoinInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.JoinNet;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.MeasureDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.ParameterMapBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.QuerySubjectBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.RegularDimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.SideInfo;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.Dimension;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMap;
import com.ibm.cognos.fmeng.fmmd.model.ParameterMapBase;
import com.ibm.cognos.fmeng.fmmd.model.Project;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationshipEnd;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.ScopeRelationship;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.fmmd.model.Shortcut;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.model.TaskCubeBuilder;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.FmRelationshipHelper;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CubeBuilder
extends Builder {
    private final boolean m_Dump = false;
    private HashMap<Object, DimensionBuilder> m_DimInfo = new HashMap();
    private FmRelationalDimensionBase m_MeasureDimension = null;
    private FmCube m_NewCube = null;
    private JoinNet m_Joins = new JoinNet(this.m_Messages);

    public CubeBuilder(FMMDSession oldSession, FMMDSession newSession) {
        super(oldSession, newSession, new ArrayList<FmMessage>());
        Project newProj = newSession.getProject();
        for (String locale : oldSession.getProject().getSupportedLocales()) {
            if (newProj.hasLocale(locale)) continue;
            newProj.addLocale(locale);
        }
    }

    public List<FmMessage> convertToCube(Section parentSection, List<Dimension> dimensions, String name) {
        ArrayList<Dimension> regDimensions = new ArrayList<Dimension>();
        ArrayList<Dimension> protoMeasureDimension = new ArrayList<Dimension>();
        this.collectDimensions(dimensions, regDimensions, protoMeasureDimension);
        this.collectDimensionsInScope(regDimensions, protoMeasureDimension);
        this.convertDimensionsToCube(parentSection, regDimensions, protoMeasureDimension, name);
        return this.m_Messages;
    }

    private void collectDimensionsInScope(List<Dimension> regDimensions, List<Dimension> protoMeasureDimension) {
        FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, "Collecting dimensions in scope.");
        for (Dimension dim : protoMeasureDimension) {
            List<ScopeRelationship> scopes = dim.getReferencedScopeRelationships();
            for (ScopeRelationship scope : scopes) {
                Dimension end = this.getDimension(scope.getOtherEnd(dim));
                if (end == null) {
                    FmMDException.ASSERT(false, "Why does the scope " + scope.toString() + " not reference " + dim.toString());
                }
                if (regDimensions.contains(end)) continue;
                regDimensions.add(end);
            }
        }
    }

    private Dimension getDimension(ReportObject end) {
        if (end == null) {
            return null;
        }
        if (end instanceof Dimension) {
            return (Dimension)end;
        }
        if (end instanceof Shortcut) {
            Shortcut sc = (Shortcut)end;
            return this.getDimension(sc.getRefobj());
        }
        FmMDException.ASSERT(false, "Unknown end: " + end.toString());
        return null;
    }

    public List<FmMessage> convertToDimension(Section parentSection, List<QuerySubjectBase> dimensions) {
        ArrayList<Dimension> regDimensions = new ArrayList<Dimension>();
        ArrayList<Dimension> protoMeasureDimension = new ArrayList<Dimension>();
        ArrayList<QuerySubject> protoQuerySubjects = new ArrayList<QuerySubject>();
        this.collectDimensions(dimensions, regDimensions, protoMeasureDimension);
        this.collectQuerySubjects(dimensions, protoQuerySubjects);
        this.convertDimensionsToCube(parentSection, regDimensions, protoMeasureDimension, null);
        this.convertQuerySubjectsToDimensions(parentSection, protoQuerySubjects);
        return this.m_Messages;
    }

    public List<FmMessage> convertToCube(Section destSection, Section srcSection) {
        FmSection srcNamespace = (FmSection)srcSection;
        ArrayList<Dimension> regDimensions = new ArrayList<Dimension>();
        ArrayList<Dimension> protoMeasureDimension = new ArrayList<Dimension>();
        this.collectDimensions(srcNamespace.getChildObjects(), regDimensions, protoMeasureDimension);
        if (protoMeasureDimension.size() == 0 && regDimensions.size() == 0) {
            throw new FmMDException("BMT_MD_NOTHING_TO_IMPORT", srcSection.getName());
        }
        this.convertDimensionsToCube(destSection, regDimensions, protoMeasureDimension, null);
        return this.m_Messages;
    }

    public List<FmMessage> convertToMeasureDimensionToCube(Section parentSection, QuerySubjectBase querySubject) {
        this.m_NewCube = (FmCube)parentSection.createCube(querySubject.getName());
        this.m_NewCube.copyCommonProperties(querySubject, this.m_NewCube);
        DimensionBuilder builder = MeasureDimensionBuilder.getBuilder(this.m_NewCube, (FmQuerySubjectBase)querySubject, this.m_Messages, this.m_Joins);
        this.m_MeasureDimension = (FmRelationalDimensionBase)builder.create();
        this.m_DimInfo.put(this.m_MeasureDimension.getInternal(), builder);
        return this.m_Messages;
    }

    private void convertDimensionsToCube(Section destSection, List<Dimension> regDimensions, List<Dimension> protoMeasureDimension, String cubeName) {
        if (protoMeasureDimension.isEmpty()) {
            this.copyDimensions(destSection, regDimensions, null);
        } else {
            regDimensions.addAll(protoMeasureDimension);
            this.copyDimensions(destSection, regDimensions);
        }
        this.m_Joins.dump();
        this.copyParameterMaps();
    }

    private void convertQuerySubjectsToDimensions(Section parentSection, List<QuerySubject> querySubjects) {
        for (QuerySubject qs : querySubjects) {
            DimensionBuilder builder = RegularDimensionBuilder.getBuilder(parentSection, (FmQuerySubject)qs, this.m_Messages, this.m_Joins);
            FmRelationalDimensionBase newDim = (FmRelationalDimensionBase)builder.create();
            this.m_DimInfo.put(newDim.getInternal(), builder);
        }
        this.m_Joins.dump();
        this.copyParameterMaps();
    }

    private void collectDimensions(List<? extends BaseObject> srcObjs, List<Dimension> regDimensions, List<Dimension> protoMeasureDimension) {
        for (BaseObject baseObject : srcObjs) {
            BaseObject actualObj = baseObject;
            if (actualObj.getFmObjectType() == FmObjectType.shortcut) {
                FmShortcut shortcut = (FmShortcut)baseObject;
                Iterator<BaseObject> iterator = shortcut.getReferencedObjects().iterator();
                while (iterator.hasNext()) {
                    BaseObject intermediate;
                    actualObj = intermediate = iterator.next();
                }
            }
            if (actualObj.getFmObjectType() != FmObjectType.dimension) continue;
            FmDimension dimension = (FmDimension)actualObj;
            if (dimension.getDimensionStyle() == DimensionBase.DimensionStyle.measure) {
                protoMeasureDimension.add(dimension);
                continue;
            }
            regDimensions.add((Dimension)actualObj);
        }
    }

    private void collectQuerySubjects(List<? extends BaseObject> srcObjs, List<QuerySubject> regQuerySubjects) {
        for (BaseObject baseObject : srcObjs) {
            BaseObject actualObj = baseObject;
            if (actualObj.getFmObjectType() == FmObjectType.shortcut) {
                FmShortcut shortcut = (FmShortcut)baseObject;
                Iterator<BaseObject> iterator = shortcut.getReferencedObjects().iterator();
                while (iterator.hasNext()) {
                    BaseObject intermediate;
                    actualObj = intermediate = iterator.next();
                }
            }
            if (actualObj.getFmObjectType() != FmObjectType.querySubject) continue;
            regQuerySubjects.add((QuerySubject)actualObj);
        }
    }

    public List<FmMessage> convertToRelational(Section targetSection, Namespace srcNamespace) {
        List<QuerySubject> oldQuerySubjects = srcNamespace.getQuerySubjects();
        this.m_Joins.findOrCreateJoins(srcNamespace.getProject().getRootNamespace().getAllRelationships());
        for (QuerySubject oldQS : oldQuerySubjects) {
            DimensionBuilder builder = QuerySubjectBuilder.getBuilder(targetSection, (FmQuerySubjectBase)((Object)oldQS), this.m_Messages, this.m_Joins);
            builder.create();
        }
        this.copyParameterMaps();
        return this.m_Messages;
    }

    public List<FmMessage> convertToRelational(Section targetSection, List<QuerySubject> oldQuerySubjects) {
        if (oldQuerySubjects == null || oldQuerySubjects.size() == 0) {
            return this.m_Messages;
        }
        this.m_Joins.findOrCreateJoins(oldQuerySubjects.get(0).getProject().getRootNamespace().getAllRelationships());
        for (QuerySubject oldQS : oldQuerySubjects) {
            DimensionBuilder builder = QuerySubjectBuilder.getBuilder(targetSection, (FmQuerySubjectBase)((Object)oldQS), this.m_Messages, this.m_Joins);
            builder.create();
        }
        this.copyParameterMaps();
        return this.m_Messages;
    }

    private void copyParameterMaps() {
        Project newProj = this.m_NewSession.getProject();
        for (ParameterMapBase pMap : this.m_OldSession.getProject().getParameterMaps()) {
            ParameterMapBase tempPMap;
            if (pMap.isHidden() || (tempPMap = newProj.findParameterMap(pMap.getName())) != null) continue;
            if (pMap.isManual() && pMap instanceof ParameterMap) {
                newProj.copyParameterMap((ParameterMap)pMap);
                continue;
            }
            FmParameterMap pm = (FmParameterMap)pMap;
            try {
                DimensionBuilder dimBuilder = ParameterMapBuilder.getBuilder(newProj, pm, this.m_Messages, this.m_Joins);
                dimBuilder.create();
            }
            catch (FmMDException e) {
                FmMessage message = new FmMessage("BMT_FMI_FAILED_IMPORT_PARAMETER_MAP", pm.getName(), e.getLocalizedMessage(this.m_NewSession.getActiveLocale()));
                this.m_Messages.add(message);
                String rendered = message.render(this.m_NewSession.getActiveLocale());
                FmEngApplicationLog.getApplicationLog().logError(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, rendered);
            }
        }
    }

    private void copyDimensions(Section destSection, List<Dimension> regDimensions, Dimension protoMeasureDimension) {
        FmNamespace rootNS = null;
        if (protoMeasureDimension != null) {
            rootNS = (FmNamespace)protoMeasureDimension.getProject().getRootNamespace();
        } else if (regDimensions.size() > 0) {
            rootNS = (FmNamespace)regDimensions.get(0).getProject().getRootNamespace();
        }
        if (rootNS != null) {
            this.m_Joins.findOrCreateJoins(rootNS.getAllRelationships());
            for (BaseObject baseObject : regDimensions) {
                DimensionBuilder builder = RegularDimensionBuilder.getBuilder(destSection, (FmDimension)baseObject, this.m_Messages, this.m_Joins);
                FmRelationalDimensionBase newDim = (FmRelationalDimensionBase)builder.create();
                this.m_DimInfo.put(newDim.getInternal(), builder);
            }
            if (protoMeasureDimension != null) {
                FmMDException.ASSERT(this.m_NewCube != null, "No cube for the measures!");
                DimensionBuilder dimensionBuilder = MeasureDimensionBuilder.getBuilder(this.m_NewCube, (FmDimension)protoMeasureDimension, this.m_Messages, this.m_Joins);
                this.m_MeasureDimension = (FmRelationalDimensionBase)dimensionBuilder.create();
                this.m_DimInfo.put(this.m_MeasureDimension.getInternal(), dimensionBuilder);
                this.createInterDimensionalJoins();
            }
        }
    }

    private void copyDimensions(Section destSection, List<Dimension> dimensions) {
        FmSection rootNS = null;
        if (dimensions.size() > 0) {
            rootNS = (FmNamespace)dimensions.get(0).getProject().getRootNamespace();
        }
        if (rootNS != null) {
            DimensionBuilder builder;
            this.m_Joins.findOrCreateJoins(rootNS.getAllRelationships());
            ArrayList<Dimension> measDims = new ArrayList<Dimension>();
            HashMap<String, FmRelationalDimensionBase> dimMap = new HashMap<String, FmRelationalDimensionBase>();
            for (Dimension srcDim : dimensions) {
                if (srcDim.getDimensionStyle() == DimensionBase.DimensionStyle.regular) {
                    FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, "Creating dimension " + srcDim.getName());
                    builder = RegularDimensionBuilder.getBuilder(destSection, (FmDimension)srcDim, this.m_Messages, this.m_Joins);
                    FmRelationalDimensionBase newDim = (FmRelationalDimensionBase)builder.create();
                    this.m_DimInfo.put(newDim.getInternal(), builder);
                    dimMap.put(srcDim.getID(), newDim);
                }
                if (srcDim.getDimensionStyle() != DimensionBase.DimensionStyle.measure) continue;
                measDims.add(srcDim);
            }
            for (Dimension measDim : measDims) {
                FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, "Creating cube " + measDim.getName());
                this.m_NewCube = (FmCube)destSection.createCube(measDim.getName());
                this.m_NewCube.copyCommonProperties(measDim, destSection);
                builder = MeasureDimensionBuilder.getBuilder(this.m_NewCube, (FmDimension)measDim, this.m_Messages, this.m_Joins);
                this.m_MeasureDimension = (FmRelationalDimensionBase)builder.create();
                this.m_DimInfo.put(this.m_MeasureDimension.getInternal(), builder);
                TaskCubeBuilder cubeBuilder = FmTaskCubeBuilder.getInstance(this.m_NewCube.getSession());
                List<ScopeRelationship> scopes = measDim.getReferencedScopeRelationships();
                for (ScopeRelationship scope : scopes) {
                    FmRelationalDimensionBase newRegDim = (FmRelationalDimensionBase)dimMap.get(scope.getLeftEnd().getID());
                    if (newRegDim == null) continue;
                    FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, "Joining dimension " + newRegDim.getName() + " to cube " + this.m_NewCube.getName());
                    cubeBuilder.addDimension(this.m_NewCube, (RelationalDimension)((Object)newRegDim));
                }
            }
        }
    }

    private void createInterDimensionalJoins() {
        if (this.m_MeasureDimension != null) {
            List<Table> measTables = this.m_MeasureDimension.getPhysicalDefinition().getTables();
            String localeKey = this.m_NewCube.getProject().getDefaultLocale();
            for (Object key : new TreeSet<Object>(this.m_DimInfo.keySet())) {
                FmRelationalDimensionBase dim = (FmRelationalDimensionBase)FmModelFactory.getInstance().get(this.m_NewSession, key);
                boolean bCreated = false;
                boolean bWarningIssued = false;
                this.dumpDimension(dim);
                if (this.m_MeasureDimension.equals(dim)) continue;
                ArrayList<FmRelationship> relationships = new ArrayList<FmRelationship>();
                List<Table> tables = dim.getPhysicalDefinition().getTables();
                for (Table dimTable : tables) {
                    for (Table measTable : measTables) {
                        List<JoinInfo> joinCandidates = this.m_Joins.findJoins(dimTable, measTable, true);
                        for (JoinInfo joinCandidate : joinCandidates) {
                            SideInfo start = joinCandidate.getStartSide();
                            SideInfo end = joinCandidate.getEndSide();
                            FmExpressionBuilder newExpression = (FmExpressionBuilder)BuilderFactory.createExpressionBuilder();
                            int i = 0;
                            while (i < joinCandidate.getOperators().size()) {
                                if (newExpression.getExpressionParts().size() > 0) {
                                    newExpression.addExpressionPart(" and ", null);
                                }
                                this.addColumnReferenceToExpression(dim, start, newExpression, i);
                                newExpression.addExpressionPart(joinCandidate.getOperator(i), null);
                                this.addColumnReferenceToExpression(this.m_MeasureDimension, end, newExpression, i);
                                ++i;
                            }
                            Set<FmRelationshipBase> candidates = FmRelationshipHelper.getCandidateRelationships(this.m_NewCube.getSession(), (RelationshipEnd)dim, (RelationshipEnd)this.m_MeasureDimension, newExpression);
                            if (newExpression.isEmpty() || candidates.size() != 0) continue;
                            if (bCreated) {
                                if (bWarningIssued) continue;
                                this.m_Messages.add(new FmMessage("BMT_FMI_IGNORED_RELATIONSHIP", dim.getName(), this.m_NewCube.getName()));
                                bWarningIssued = true;
                                continue;
                            }
                            String name = String.valueOf(dim.getName()) + " (" + dimTable.getName() + ") <--> " + this.m_MeasureDimension.getName(localeKey);
                            FmRelationship newRel = (FmRelationship)this.m_NewCube.createRelationship(name, (ExpressionBuilder)newExpression, dim, this.m_MeasureDimension);
                            relationships.add(newRel);
                            bCreated = true;
                        }
                    }
                }
            }
        }
    }

    private void addColumnReferenceToExpression(FmRelationalDimensionBase dim, SideInfo start, FmExpressionBuilder newExpression, int i) {
        FmDataSource startDs = this.findOrCopyDataSource(this.m_OldSession.getProject(), dim.getFmProject(), start.getTable().m_DataSourceName);
        FmMDException.ASSERT(start != null, "No side was specified.");
        String tableName = start.getTable().getName();
        if (start.getKeys().get(i) == null) {
            return;
        }
        String columnName = start.getKeys().get(i).getName();
        newExpression.addExpressionPart(startDs, columnName, tableName, dim);
    }

    protected void dumpDimension(FmRelationalDimensionBase dim) {
    }

    public FMMDSession getOldSession() {
        return this.m_OldSession;
    }
}

