/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmCalculation;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmEMDObjectNaming;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilter;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmFilterDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmJoin;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmMeasureDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmModelFactory;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmPhysicalDefinition;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRefobjViaShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalParameterMap;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.QueryItemParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.Builder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.JoinInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.JoinNet;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.KeyInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.SideInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.TableInfo;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.BuilderFactory;
import com.ibm.cognos.fmeng.fmmd.model.DbQuery;
import com.ibm.cognos.fmeng.fmmd.model.Expression;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.model.ExpressionParent;
import com.ibm.cognos.fmeng.fmmd.model.Filter;
import com.ibm.cognos.fmeng.fmmd.model.FilterDefinition;
import com.ibm.cognos.fmeng.fmmd.model.Join;
import com.ibm.cognos.fmeng.fmmd.model.ModelQuery;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalFilter;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.util.FmExpressionBuilder;
import com.ibm.cognos.fmeng.fmmd.util.FmRoutes;
import com.ibm.cognos.fmeng.fmmd.util.FmTree;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNode;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeWalker;
import com.ibm.cognos.fmeng.fmmd.util.SQLParseResult;
import com.ibm.cognos.fmeng.fmmd.util.SQLParser;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectBaseType;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DimensionBuilder
extends Builder {
    private final boolean m_Dump = false;
    private final Pattern m_XmlLangPattern = Pattern.compile("xml\\:lang=\\&quot;[A-Za-z]{2}(-[A-Za-z]{2})?\\&quot;");
    protected FmQuerySubjectBase m_SrcDim;
    protected FmRelationalObject m_DestDim;
    protected FmSection m_NS;
    protected FmReportObject m_NameParent;
    private Map<String, FmTable> m_Tables = new HashMap<String, FmTable>();
    protected Map<Object, FmQueryItemBase> m_OldItemsToNewItems;
    private CopyOnWriteArraySet<QuerySubjectBaseType> m_ContributingQuerySubjects;
    private JoinNet m_Joins;
    protected FmPhysicalDefinition m_PhysDef;

    protected DimensionBuilder(FMMDSession oldSession, FMMDSession newSession, List<FmMessage> messages, JoinNet joins) {
        super(oldSession, newSession, messages);
        this.m_Joins = joins;
        this.m_ContributingQuerySubjects = new CopyOnWriteArraySet();
        this.m_OldItemsToNewItems = new HashMap<Object, FmQueryItemBase>();
        this.m_DestDim = null;
    }

    public FmRelationalObject create() {
        FmRelationalObject obj = this.doCreate();
        for (QuerySubjectBaseType proto : this.m_ContributingQuerySubjects) {
            QuerySubjectBase qs = (QuerySubjectBase)FmModelFactory.getInstance().get(this.m_OldSession, proto);
            List<Object> filters = new ArrayList();
            DbQuery db = qs.getDBQuery();
            if (db != null) {
                filters = db.getFilterDefinitions();
            } else {
                ModelQuery modelQuery = qs.getModelQuery();
                if (modelQuery != null) {
                    filters = modelQuery.getFilterDefinitions();
                }
            }
            for (FilterDefinition filterDefinition : filters) {
                FmFilterDefinition f;
                BaseObject refobj;
                String filterName = filterDefinition.getDisplayName();
                FmEngApplicationLog.getApplicationLog().logInfo(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, "Process embedded filters: " + filterName);
                FmExpression expr = (FmExpression)filterDefinition.getExpression();
                if (expr == null && (refobj = (f = (FmFilterDefinition)filterDefinition).getRefobj()) != null) {
                    Filter fil = (Filter)FmModelFactory.getInstance().get(this.m_OldSession, refobj.getInternal());
                    expr = (FmExpression)fil.getExpression();
                }
                if (expr == null) continue;
                QueryItemParent parent = null;
                if (this.m_DestDim instanceof FmRelationalDimension) {
                    parent = ((FmRelationalDimension)this.m_DestDim).getLastLevel();
                } else if (this.m_DestDim instanceof FmRelationalQuerySubject || this.m_DestDim instanceof FmRelationalParameterMap || this.m_DestDim instanceof FmMeasureDimension) {
                    parent = (QueryItemParent)((Object)this.m_DestDim);
                } else {
                    FmMDException.ASSERT(false, "Attempting to import a filter definition into an unexpected object type: " + this.m_DestDim.getID());
                }
                FmExpressionBuilder builder = new FmExpressionBuilder();
                this.processExpression((QueryItemParentInternal)parent, builder, expr);
                RelationalFilter newFilter = this.m_DestDim.createFilter(filterDefinition.getDisplayName());
                newFilter.setExpression(builder);
            }
        }
        return obj;
    }

    protected abstract FmRelationalObject doCreate();

    protected void dumpDimensionId() {
    }

    private FmQueryItem extractKey(Object keyRef) {
        FmQueryItem key = null;
        if (keyRef instanceof FmQueryItem) {
            key = (FmQueryItem)keyRef;
        } else if (keyRef instanceof FmShortcut) {
            FmShortcut shortcut = (FmShortcut)keyRef;
            key = this.extractKey(shortcut.getRefobj());
        } else {
            FmMDException.ASSERT(false, "Unexpected reference to object in a relationship: " + keyRef.toString());
        }
        return key;
    }

    protected void createJoins() {
        for (QuerySubjectBaseType querySubject : this.m_ContributingQuerySubjects) {
            FmQuerySubjectBase fmQuerySubject = (FmQuerySubjectBase)FmModelFactory.getInstance().get(this.m_SrcDim.getSession(), querySubject);
            for (Relationship rel : this.m_Joins.getRelationships()) {
                FmRelationship someRel = (FmRelationship)rel;
                Object key = null;
                List<Object> list = someRel.getExpression().getComponents(false);
                if (fmQuerySubject.equals(someRel.getLeft())) {
                    key = this.extractKey(list.get(0));
                } else if (fmQuerySubject.equals(someRel.getRight())) {
                    key = this.extractKey(list.get(1));
                }
                if (key == null) continue;
                FmTree<ExpressionParent> qiTree = new FmTree<ExpressionParent>();
                this.extractQueryItemChain(qiTree, (ExpressionParent)key);
                for (FmTreeNode<ExpressionParent> bottomNode : qiTree.getLeafNodes()) {
                    ExpressionParent bottomNodeData = bottomNode.getData();
                    if (bottomNodeData instanceof FmQueryItemBase) {
                        this.findOrCreateTable((FmQueryItemBase)bottomNodeData);
                        continue;
                    }
                    FmMDException.ASSERT(false, "Unexpected item while processing joins: " + ((BaseObject)((Object)bottomNodeData)).getID());
                }
            }
        }
        FmPhysicalDefinition physDef = this.m_DestDim.getPhysicalDefinition();
        List<Table> tables = physDef.getTables();
        if (tables.size() > 1) {
            HashSet<FmTable> joinedTables = new HashSet<FmTable>();
            for (Table leftFoo : tables) {
                for (Table rightFoo : tables) {
                    if (leftFoo == rightFoo) continue;
                    FmTable fmTable = (FmTable)leftFoo;
                    FmTable rightTable = (FmTable)rightFoo;
                    List<JoinInfo> joins = this.m_Joins.findJoins(fmTable.getDataSource(), fmTable.getName(), rightTable.getDataSource(), rightTable.getName());
                    for (JoinInfo relationship : joins) {
                        FmJoin newJoin = physDef.createJoin(relationship.getName(), fmTable, rightTable);
                        newJoin.copyCardinality(relationship);
                        List<KeyInfo> cols = relationship.getAssociations();
                        for (KeyInfo col : cols) {
                            newJoin.createAssociation(col.getLeftColumn().getName(), col.getRightColumn().getName(), col.getOperator());
                        }
                        joinedTables.add(fmTable);
                        joinedTables.add(rightTable);
                    }
                }
            }
            block7: for (Table someTable : tables) {
                if (joinedTables.contains(someTable)) continue;
                TableInfo unjoinedNode = this.m_Joins.findNode(someTable);
                boolean foundRoutes = false;
                for (Table table : joinedTables) {
                    TableInfo joinedNode;
                    foundRoutes = this.attemptCreateJoin(physDef, someTable, unjoinedNode, table, joinedNode = this.m_Joins.findNode(table));
                    if (!foundRoutes) {
                        foundRoutes = this.attemptCreateJoin(physDef, table, joinedNode, someTable, unjoinedNode);
                    }
                    if (foundRoutes) continue block7;
                }
            }
        }
    }

    private boolean attemptCreateJoin(FmPhysicalDefinition physDef, Table leftTable, TableInfo leftTableInfo, Table rightTable, TableInfo rightTableInfo) {
        FmRoutes routes = new FmRoutes(physDef.getSession().m_RoutesGovernor.get(), 1, false);
        routes.compute(leftTableInfo, rightTableInfo);
        if (routes.hasRoutes()) {
            for (JoinInfo someJoin : routes.getShortest().getJoinList()) {
                List<Join> joins;
                SideInfo startSide = someJoin.getStartSide();
                SideInfo endSide = someJoin.getEndSide();
                FmTable startTable = this.m_PhysDef.findTable(startSide.getTable().m_DataSourceName, startSide.getTable().m_TableName);
                FmTable endTable = this.m_PhysDef.findTable(endSide.getTable().m_DataSourceName, endSide.getTable().m_TableName);
                if (endTable == null) {
                    FmDataSource ds = this.findOrCopyDataSource(this.m_SrcDim, this.m_DestDim.getFmProject(), endSide.getTable().m_DataSourceName);
                    endTable = physDef.createTable(ds, endSide.getTable().m_TableName);
                }
                if ((joins = this.m_PhysDef.findJoins(startTable, endTable, true)).size() != 0) continue;
                FmJoin newJoin = physDef.createJoin(String.valueOf(startTable.getName()) + "-->" + endTable.getName(), startTable, endTable);
                newJoin.setLeftMincard(startSide.getMincard());
                newJoin.setLeftMaxcard(startSide.getMaxcard());
                newJoin.setRightMincard(endSide.getMincard());
                newJoin.setRightMaxcard(endSide.getMaxcard());
                int i = 0;
                while (i < someJoin.getOperators().size()) {
                    newJoin.createAssociation(startSide.getKeys().get(i).getName(), endSide.getKeys().get(i).getName(), someJoin.getOperators().get(i));
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    protected void copyDimensionNames() {
        FmMDException.ASSERT(this.m_NameParent != null, "Name parent is not set");
        this.m_PhysDef = this.m_DestDim.getPhysicalDefinition();
        this.m_DestDim.copyNames(this.m_SrcDim, BaseObject.PrefixName.kCopy, (FmBaseObject)this.m_NameParent);
        this.m_DestDim.copyDescriptionAndScreentip(this.m_SrcDim);
    }

    protected FmQueryItemBase createItemFromSourceItem(QueryItemParentInternal parent, FmQueryItemBase srcItem) {
        if (this.m_OldItemsToNewItems.containsKey(srcItem.getInternal())) {
            return this.m_OldItemsToNewItems.get(srcItem.getInternal());
        }
        FmQueryItemBase newQueryItem = null;
        FmTree<ExpressionParent> qiTree = new FmTree<ExpressionParent>();
        this.extractQueryItemChain(qiTree, srcItem);
        Expression expression = this.findFirstSubstantial(qiTree.getRootNode());
        int objCount = this.getObjectCount(expression);
        if (qiTree.isStick() && objCount <= 1) {
            List<FmTreeNode<ExpressionParent>> bottomTier = qiTree.getLeafNodes();
            FmTreeNode<ExpressionParent> bottomNode = bottomTier.get(0);
            ExpressionParent bottomNodeData = bottomNode.getData();
            FmMDException.ASSERT(bottomNodeData instanceof FmQueryItemBase, "Expected a reference to an external column.");
            FmQueryItemBase dbItem = (FmQueryItemBase)bottomNodeData;
            newQueryItem = this.createItem(parent, srcItem, dbItem);
            FmTreeNode<ExpressionParent> node = bottomNode;
            while (node != null) {
                FmMDException.ASSERT(node.getChildren().size() <= 1, "Why is there more than one child here?");
                this.map(node.getData(), newQueryItem);
                node = node.getParent();
            }
            FmTable table = this.findOrCreateTable(dbItem);
            if (table == null || dbItem.getExternalName() == null) {
                Expression subExpr = dbItem.getExpression();
                if (subExpr != null) {
                    ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
                    builder.addExpressionPart(subExpr.getComponents().get(0).toString(), null);
                    newQueryItem.setExpression(builder);
                    FmMessage message = new FmMessage("BMT_FMI_FAILED_TO_EXTRACT_COLUMN", dbItem.getID(), parent.getID());
                    FmEngApplicationLog.getApplicationLog().logWarn(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, message.render(this.m_NewSession.getActiveLocale()));
                    this.m_Messages.add(message);
                }
            } else {
                this.createQueryItemMapping(this.m_PhysDef, newQueryItem, dbItem.getExternalName(), table);
            }
        } else {
            ExpressionBuilder builder = BuilderFactory.createExpressionBuilder();
            newQueryItem = this.createItem(parent, srcItem, srcItem);
            if (expression != null) {
                for (Object obj : expression.getComponents()) {
                    Expression expr;
                    if (obj instanceof String) {
                        builder.addExpressionPart((String)obj, null);
                        continue;
                    }
                    if (obj instanceof FmQueryItemBase) {
                        FmQueryItemBase newItem = this.createItemFromSourceItem(parent, (FmQueryItemBase)obj);
                        builder.addExpressionPart(newItem, null, null);
                        continue;
                    }
                    if (obj instanceof FmRefobjViaShortcut) {
                        FmRefobjViaShortcut refObj = (FmRefobjViaShortcut)obj;
                        FmQueryItemBase newItem = this.createItemFromSourceItem(parent, (FmQueryItemBase)refObj.getRefobj());
                        builder.addExpressionPart(newItem, null, null);
                        continue;
                    }
                    if (obj instanceof FmCalculation) {
                        expr = ((FmCalculation)obj).getExpression();
                        this.processExpression(parent, builder, expr);
                        continue;
                    }
                    if (obj instanceof FmFilter) {
                        expr = ((FmFilter)obj).getExpression();
                        this.processExpression(parent, builder, expr);
                        continue;
                    }
                    FmMDException.ASSERT(false, "What is: " + obj.toString());
                }
            }
            newQueryItem.setExpression(builder);
        }
        return newQueryItem;
    }

    private Expression findFirstSubstantial(FmTreeNode<ExpressionParent> fmTreeNode) {
        List<FmTreeNode<ExpressionParent>> children;
        Expression expression = fmTreeNode.getData().getExpression();
        int objCount = this.getObjectCount(expression);
        if (objCount == 0) {
            return null;
        }
        if (objCount == 1 && (children = fmTreeNode.getChildren()).size() > 0) {
            return this.findFirstSubstantial(children.get(0));
        }
        return expression;
    }

    private int getObjectCount(Expression expression) {
        int objCount = 0;
        if (expression != null) {
            List<Object> components = expression.getComponents();
            for (Object obj : components) {
                if (obj instanceof String) {
                    String text = (String)obj;
                    if ("".equals(text.trim())) continue;
                    ++objCount;
                    continue;
                }
                ++objCount;
            }
        }
        return objCount;
    }

    private void processExpression(QueryItemParentInternal parent, ExpressionBuilder builder, Expression exp) {
        for (Object obj : exp.getComponents()) {
            Expression expr;
            if (obj instanceof String) {
                builder.addExpressionPart((String)obj, null);
                continue;
            }
            if (obj instanceof FmQueryItemBase) {
                FmQueryItemBase newItem = this.createItemFromSourceItem(parent, (FmQueryItemBase)obj);
                builder.addExpressionPart(newItem, null, null);
                continue;
            }
            if (obj instanceof FmRefobjViaShortcut) {
                FmRefobjViaShortcut refObj = (FmRefobjViaShortcut)obj;
                FmQueryItemBase newItem = this.createItemFromSourceItem(parent, (FmQueryItemBase)refObj.getRefobj());
                builder.addExpressionPart(newItem, null, null);
                continue;
            }
            if (obj instanceof FmCalculation) {
                expr = ((FmCalculation)obj).getExpression();
                this.processExpression(parent, builder, expr);
                continue;
            }
            if (!(obj instanceof FmFilter)) continue;
            expr = ((FmFilter)obj).getExpression();
            this.processExpression(parent, builder, expr);
        }
    }

    private void map(ExpressionParent expressionParent, FmQueryItemBase newQI) {
        this.m_OldItemsToNewItems.put(((BaseObject)((Object)expressionParent)).getInternal(), newQI);
        if (expressionParent instanceof FmQueryItemBase) {
            this.m_ContributingQuerySubjects.add((QuerySubjectBaseType)((FmQueryItemBase)((ReportObject)((Object)expressionParent))).getQueryParent().getInternal());
        } else {
            FmMDException.ASSERT(false, "Unexpected mapping: " + ((ReportObject)((Object)expressionParent)).getID());
        }
    }

    private FmTable findOrCreateTable(FmQueryItemBase fmQueryItemBase) {
        FmTable table = null;
        FmQuerySubjectBase qsb = (FmQuerySubjectBase)fmQueryItemBase.getQueryParent();
        DbQuery dbquery = qsb.getDBQuery();
        if (dbquery != null) {
            String sql = dbquery.getSQL();
            if (this.m_Tables.containsKey(sql)) {
                table = this.m_Tables.get(sql);
            } else {
                SQLParser parser = new SQLParser();
                SQLParseResult dst = parser.parse(sql, this.m_Joins.getDatasourceNames());
                if (dst.isSet()) {
                    table = this.m_PhysDef.findTable(dst.m_DataSource, dst.m_Table);
                    if (table == null) {
                        FmDataSource ds = this.findOrCopyDataSource(this.m_SrcDim, this.m_DestDim.getFmProject(), dst.m_DataSource);
                        table = FmTable.createTable(this.m_NewSession, this.m_PhysDef, ds, dst.m_Table);
                    }
                    this.m_Tables.put(sql, table);
                } else {
                    FmMessage message = new FmMessage("BMT_FMI_FAILED_TO_PARSE_SQL", qsb.getID(), this.m_DestDim.getName(), sql);
                    FmEngApplicationLog.getApplicationLog().logWarn(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, message.render(this.m_NewSession.getActiveLocale()));
                    this.m_Messages.add(message);
                }
            }
        }
        return table;
    }

    private FmQueryItemBase createItem(QueryItemParentInternal parent, FmQueryItemBase srcItem, FmQueryItemBase attrSrcItem) {
        FmQueryItemBase newItem = null;
        newItem = this.m_OldItemsToNewItems.get(srcItem.getInternal());
        if (newItem != null) {
            return newItem;
        }
        newItem = this.createItem(parent, srcItem);
        newItem.copyReplicableProperties(srcItem);
        String format = newItem.getFormat();
        if (format != null) {
            Matcher matcher = this.m_XmlLangPattern.matcher(format);
            newItem.setFormat(StringEscapeUtils.unescapeXml((String)matcher.replaceAll("")));
        }
        newItem.copyDatabaseProperties(attrSrcItem);
        newItem.copyDescriptionAndScreentip(srcItem);
        newItem.copyNames(srcItem, BaseObject.PrefixName.kCopy, (FmBaseObject)((Object)parent));
        this.map(srcItem, newItem);
        this.postCreateItem(parent, srcItem, newItem);
        return newItem;
    }

    protected abstract void postCreateItem(QueryItemParentInternal var1, FmQueryItemBase var2, FmQueryItemBase var3);

    protected FmQueryItemBase createItem(QueryItemParentInternal parent, FmQueryItemBase srcItem) {
        String uniqueName = srcItem.getName();
        if (this.m_DestDim instanceof FmRelationalDimension) {
            List<QueryItem> list = ((FmRelationalDimension)this.m_DestDim).getAllQueryItems();
            ArrayList<String> names = new ArrayList<String>();
            for (QueryItem item : list) {
                names.add(item.getName());
            }
            uniqueName = DimensionBuilder.makeUnique(srcItem.getName(), names);
        }
        return FmQueryItem.createQueryItemFrom(this.m_NewSession, null, parent, uniqueName, FmEMDObjectNaming.kMakeUnique);
    }

    private static String makeUnique(String candidateName, List<String> comapreToList) {
        String uniqueName = candidateName;
        int seqNo = 0;
        while (seqNo < comapreToList.size() && comapreToList.contains(uniqueName)) {
            uniqueName = String.valueOf(candidateName) + Integer.toString(++seqNo);
        }
        return uniqueName;
    }

    protected void createQueryItemMapping(FmPhysicalDefinition parent, FmQueryItemBase srcItem, String name, FmTable table) {
        FmMDException.ASSERT(srcItem instanceof FmQueryItem, "Wrong object type for this method: " + srcItem.toString());
        parent.createQueryItemMapping((QueryItemBase)((FmQueryItem)srcItem), name, table);
    }

    public FmTable getTable(FmQuerySubjectBase qs) {
        TableInfo tableInfo = this.m_Joins.findTable(qs.getQuerySubjectBaseType());
        if (tableInfo == null) {
            return null;
        }
        for (Table table : this.m_PhysDef.getTables()) {
            if (!table.getName().equals(tableInfo.m_TableName) || !table.getDataSource().getName().equals(tableInfo.m_DataSourceName)) continue;
            return (FmTable)table;
        }
        return null;
    }

    public String toString() {
        String foo = "<empty>";
        if (this.m_DestDim != null) {
            foo = this.m_DestDim.getName();
        }
        return foo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class QuerySubjectCollector
    implements FmTreeWalker<FmQueryItemBase> {
        private HashSet<QuerySubjectBaseType> m_Collection;

        public QuerySubjectCollector(HashSet<QuerySubjectBaseType> collection) {
            this.m_Collection = collection;
        }

        @Override
        public void doSomething(FmTreeNode<FmQueryItemBase> node) {
            QuerySubjectBase base = node.getData().getQueryParent();
            if (base instanceof FmQuerySubjectBase) {
                this.m_Collection.add(((FmQuerySubjectBase)base).getQuerySubjectBaseType());
            }
        }
    }
}

