/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.ColumnInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.KeyInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.SideInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.TableInfo;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.Cardinality;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.util.FmJoinHelper;
import com.ibm.cognos.fmeng.fmmd.util.JoinBase;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinInfo
implements JoinBase<TableInfo, JoinInfo> {
    private SideInfo m_Left;
    private SideInfo m_Right;
    private String m_SrcName;
    private String m_SrcNamespace;
    private List<Association.EOperator> m_KeyOperators;

    public JoinInfo(TableInfo leftNode, TableInfo rightNode, List<KeyInfo> keyList, Relationship relationship) {
        this.m_Left = new SideInfo(leftNode, relationship.getLeftMincard(), relationship.getLeftMaxcard());
        this.m_Right = new SideInfo(rightNode, relationship.getRightMincard(), relationship.getRightMaxcard());
        this.m_SrcName = relationship.getName();
        this.m_SrcNamespace = relationship.getParentNamespace().getName();
        this.m_KeyOperators = new ArrayList<Association.EOperator>();
        for (KeyInfo key : keyList) {
            this.m_Left.addColumn(key.getLeftColumn());
            this.m_Right.addColumn(key.getRightColumn());
            this.m_KeyOperators.add(key.getOperator());
        }
    }

    @Override
    public TableInfo getLeft() {
        return this.m_Left.getTable();
    }

    @Override
    public Cardinality.ECardinality getLeftMaxcard() {
        return this.m_Left.getMaxcard();
    }

    @Override
    public Cardinality.ECardinality getLeftMincard() {
        return this.m_Left.getMincard();
    }

    @Override
    public TableInfo getRight() {
        return this.m_Right.getTable();
    }

    @Override
    public Cardinality.ECardinality getRightMaxcard() {
        return this.m_Right.getMaxcard();
    }

    @Override
    public Cardinality.ECardinality getRightMincard() {
        return this.m_Right.getMincard();
    }

    public boolean equals(TableInfo leftNode, TableInfo rightNode) {
        return leftNode.equals(this.getLeft()) && rightNode.equals(this.getRight()) || leftNode.equals(this.getRight()) && rightNode.equals(this.getLeft());
    }

    @Override
    public boolean equals(Relationship rel) {
        return this.m_SrcNamespace.equals(rel.getParentNamespace().getName()) && this.m_SrcName.equals(rel.getName());
    }

    @Override
    public boolean equals(JoinInfo right) {
        return this.m_SrcName.equals(right.getName()) && this.m_SrcNamespace.equals(right.getSrcNamespace());
    }

    public List<KeyInfo> getAssociations() {
        ArrayList<KeyInfo> keys = new ArrayList<KeyInfo>();
        List<ColumnInfo> leftCols = this.m_Left.getKeys();
        List<ColumnInfo> rightCols = this.m_Right.getKeys();
        int i = 0;
        while (i < this.m_KeyOperators.size()) {
            keys.add(new KeyInfo(leftCols.get(i), rightCols.get(i), this.m_KeyOperators.get(i)));
            ++i;
        }
        return keys;
    }

    @Override
    public String getName() {
        return this.m_SrcName;
    }

    public String getSrcNamespace() {
        return this.m_SrcNamespace;
    }

    @Override
    public TableInfo getOtherSide(TableInfo table) {
        return new FmJoinHelper<TableInfo, JoinInfo>().getOtherSide(this, table);
    }

    @Override
    public SideInfo getOtherSide(SideInfo side) {
        if (this.m_Left.getTable().equals(side.getTable())) {
            return this.m_Right;
        }
        return this.m_Left;
    }

    public SideInfo getStartSide() {
        if (this.m_Left.getMaxcard() == Cardinality.ECardinality.one && this.m_Right.getMaxcard() == Cardinality.ECardinality.many) {
            return this.m_Left;
        }
        if (this.m_Left.getMaxcard() == Cardinality.ECardinality.many && this.m_Right.getMaxcard() == Cardinality.ECardinality.one) {
            return this.m_Right;
        }
        return this.m_Left;
    }

    public SideInfo getEndSide() {
        return this.getOtherSide(this.getStartSide());
    }

    public List<Association.EOperator> getOperators() {
        return this.m_KeyOperators;
    }

    public String getOperator(int i) {
        switch (this.m_KeyOperators.get(i)) {
            case equals: {
                return "=";
            }
            case notEquals: {
                return "!=";
            }
            case lessThan: {
                return "<";
            }
            case greaterThan: {
                return ">";
            }
            case lessThanOrEquals: {
                return "<=";
            }
            case greaterThanOrEquals: {
                return ">=";
            }
        }
        FmMDException.ASSERT(false, "Invalid operator");
        return "";
    }

    public SideInfo getLeftSide() {
        return this.m_Left;
    }

    public SideInfo getRightSide() {
        return this.m_Right;
    }

    @Override
    public TableInfo getEnd() {
        TableInfo start = this.getStart();
        if (start.equals(this.m_Left.getTable())) {
            return this.m_Right.getTable();
        }
        return this.m_Left.getTable();
    }

    @Override
    public TableInfo getStart() {
        if (FmJoinHelper.isStart(this.m_Left.getMaxcard(), this.m_Right.getMaxcard())) {
            return this.m_Left.getTable();
        }
        if (FmJoinHelper.isStart(this.m_Right.getMaxcard(), this.m_Left.getMaxcard())) {
            return this.m_Right.getTable();
        }
        return this.m_Left.getTable();
    }

    @Override
    public void setLeftMaxcard(Cardinality.ECardinality leftMaxcard) {
        this.m_Left.setMaxcard(leftMaxcard);
    }

    @Override
    public void setLeftMincard(Cardinality.ECardinality leftMincard) {
        this.m_Left.setMincard(leftMincard);
    }

    @Override
    public void setRightMaxcard(Cardinality.ECardinality rightMaxcard) {
        this.m_Right.setMaxcard(rightMaxcard);
    }

    @Override
    public void setRightMincard(Cardinality.ECardinality rightMincard) {
        this.m_Right.setMincard(rightMincard);
    }

    @Override
    public void copyCardinality(Cardinality right) {
        FmJoinHelper.copyCardinality(this, right);
    }

    @Override
    public boolean equals(Cardinality.ECardinality leftMinCard, Cardinality.ECardinality leftMaxCard, Cardinality.ECardinality rightMinCard, Cardinality.ECardinality rightMaxCard) {
        return leftMinCard.equals((Object)this.getLeftMincard()) && leftMaxCard.equals((Object)this.getLeftMaxcard()) && rightMinCard.equals((Object)this.getRightMincard()) && rightMaxCard.equals((Object)this.getRightMaxcard());
    }

    public String toString() {
        StringBuilder foo = new StringBuilder();
        foo.append(this.getName());
        foo.append("\n\t");
        foo.append(this.getLeftSide() == null ? "null" : this.getLeftSide().toString());
        foo.append(" <---> ");
        foo.append(this.getRightSide() == null ? "null" : this.getRightSide().toString());
        foo.append("\nExpression:\n");
        foo.append("\nleftMin: " + this.getLeftMincard().toString() + ", leftMax: " + this.getLeftMaxcard().toString() + ", rightMin: " + this.getRightMincard().toString() + ", rightMax: " + this.getRightMaxcard().toString());
        return foo.toString();
    }
}

