/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmBaseObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmExpression;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationship;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmShortcut;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.ColumnInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.JoinInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.KeyInfo;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.TableInfo;
import com.ibm.cognos.fmeng.fmmd.model.Association;
import com.ibm.cognos.fmeng.fmmd.model.BaseObject;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.DbQuery;
import com.ibm.cognos.fmeng.fmmd.model.ModelQuery;
import com.ibm.cognos.fmeng.fmmd.model.Relationship;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import com.ibm.cognos.fmeng.fmmd.util.FmTree;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNode;
import com.ibm.cognos.fmeng.fmmd.util.FmTreeNodeContainer;
import com.ibm.cognos.fmeng.fmmd.util.SQLParseResult;
import com.ibm.cognos.fmeng.fmmd.util.SQLParser;
import com.ibm.cognos.fmeng.genmodel.QuerySubjectBaseType;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JoinNet {
    private final boolean m_Dump = false;
    List<TableInfo> m_Nodes = new ArrayList<TableInfo>();
    List<JoinInfo> m_Connections = new ArrayList<JoinInfo>();
    private Map<QuerySubjectBaseType, TableInfo> m_TableSubstitutions = new HashMap<QuerySubjectBaseType, TableInfo>();
    private List<Relationship> m_Relationships = null;
    private List<FmMessage> m_Messages = null;
    private Set<String> m_DatasourceNames = new HashSet<String>();

    public JoinNet(List<FmMessage> messages) {
        this.m_Messages = messages;
    }

    public TableInfo findOrCreateNode(FmTable table) {
        String tableName = table.getName();
        String dataSourceName = table.getDataSource().getName();
        TableInfo nodeOfInterest = null;
        for (TableInfo someNode : this.m_Nodes) {
            if (!someNode.equals(dataSourceName, tableName)) continue;
            nodeOfInterest = someNode;
            break;
        }
        if (nodeOfInterest == null) {
            nodeOfInterest = new TableInfo(dataSourceName, tableName);
            this.m_Nodes.add(nodeOfInterest);
        }
        return nodeOfInterest;
    }

    /*
     * Unable to fully structure code
     */
    private JoinInfo findOrCreateJoin(FmRelationship relationship) {
        connectOfInterest = null;
        for (JoinInfo join : this.m_Connections) {
            if (!join.equals(relationship)) continue;
            connectOfInterest = join;
            break;
        }
        if (connectOfInterest != null) {
            return connectOfInterest;
        }
        bBetterParsePassed = true;
        keyList = new ArrayList<KeyInfo>();
        parts = relationship.getExpression().getComponents();
        i = 0;
        ** GOTO lbl35
        {
            ++i;
            do {
                if (parts.get(i) instanceof String) continue block1;
                part1 = null;
                part2 = null;
                part3 = null;
                if (i < parts.size()) {
                    part1 = parts.get(i++);
                }
                if (i < parts.size()) {
                    part2 = parts.get(i++);
                }
                if (i < parts.size()) {
                    part3 = parts.get(i++);
                }
                if (part1 instanceof FmQueryItemBase && part2 instanceof String && part3 instanceof FmQueryItemBase) {
                    leftCol = this.findOrCreateColumn((FmQueryItemBase)part1);
                    rightCol = this.findOrCreateColumn((FmQueryItemBase)part3);
                    op = this.matchOperator((String)part2);
                    key = new KeyInfo(leftCol, rightCol, op);
                    keyList.add(key);
                    continue;
                }
                bBetterParsePassed = false;
                break block1;
lbl35:
                // 2 sources

            } while (i + 2 < parts.size());
        }
        if (!bBetterParsePassed) {
            components = relationship.getExpression().getRefObjs(true);
            leftObj = null;
            keyList = new ArrayList<E>();
            for (ReportObject obj : components) {
                if (leftObj == null) {
                    leftObj = obj;
                    continue;
                }
                if (leftObj instanceof FmQueryItemBase && obj instanceof FmQueryItemBase) {
                    leftCol = this.findOrCreateColumn((FmQueryItemBase)leftObj);
                    rightCol = this.findOrCreateColumn((FmQueryItemBase)obj);
                    key = new KeyInfo(leftCol, rightCol, Association.EOperator.equals);
                    keyList.add(key);
                }
                leftObj = null;
            }
        }
        leftTable = null;
        rightTable = null;
        left = relationship.getLeft();
        right = relationship.getRight();
        if (left != null) {
            leftTable = this.m_TableSubstitutions.get(left.getQuerySubjectBaseType());
        }
        if (right != null) {
            rightTable = this.m_TableSubstitutions.get(right.getQuerySubjectBaseType());
        }
        if (leftTable == null || rightTable == null) {
            return null;
        }
        connectOfInterest = new JoinInfo(leftTable, rightTable, keyList, relationship);
        this.m_Connections.add(connectOfInterest);
        leftTable.addJoin(connectOfInterest);
        rightTable.addJoin(connectOfInterest);
        return connectOfInterest;
    }

    private Association.EOperator matchOperator(String operator) {
        if ("=".equals(operator)) {
            return Association.EOperator.equals;
        }
        if ("<".equals(operator)) {
            return Association.EOperator.lessThan;
        }
        if ("<=".equals(operator)) {
            return Association.EOperator.lessThanOrEquals;
        }
        if (">".equals(operator)) {
            return Association.EOperator.greaterThan;
        }
        if (">=".equals(operator)) {
            return Association.EOperator.greaterThanOrEquals;
        }
        if ("!=".equals(operator)) {
            return Association.EOperator.notEquals;
        }
        return Association.EOperator.none;
    }

    private ColumnInfo findOrCreateColumn(FmQueryItemBase srcItem) {
        SQLParser parser;
        ColumnInfo columnOfInterest = null;
        FmTree<FmQueryItemBase> qiTree = new FmTree<FmQueryItemBase>();
        this.extractQueryItemChain(qiTree, srcItem);
        List<FmTreeNode<FmQueryItemBase>> bottomTier = qiTree.getLeafNodes();
        if (bottomTier.size() > 1) {
            boolean bAllDuplicates = true;
            FmBaseObject prevItem = null;
            for (FmTreeNode<FmQueryItemBase> someBottomItem : bottomTier) {
                if (prevItem != null && !prevItem.equals(someBottomItem.getData())) {
                    bAllDuplicates = false;
                    break;
                }
                prevItem = someBottomItem.getData();
            }
            if (!bAllDuplicates) {
                return null;
            }
        }
        FmTreeNode<FmQueryItemBase> bottomNode = bottomTier.get(0);
        FmQueryItemBase bottomItem = bottomNode.getData();
        FmQuerySubject bottomQS = (FmQuerySubject)bottomItem.getQueryParent();
        SQLParseResult dst = null;
        DbQuery dbquery = bottomQS.getDBQuery();
        String SQL2 = null;
        if (dbquery != null) {
            SQL2 = dbquery.getSQL();
        } else {
            ModelQuery modelQuery = bottomQS.getModelQuery();
            if (modelQuery != null) {
                SQL2 = modelQuery.getSQL();
            }
        }
        if (SQL2 != null && !(dst = (parser = new SQLParser()).parse(SQL2, this.m_DatasourceNames)).isSet()) {
            this.m_Messages.add(new FmMessage("BMT_FMI_UNABLE_TO_PARSE_SQL", SQL2, bottomQS.getID()));
            return null;
        }
        FmMDException.ASSERT(dst != null, "No data source found for db query subject: " + bottomQS.getID());
        TableInfo tableOfInterest = null;
        for (TableInfo table : this.m_Nodes) {
            if (!table.equals(dst.m_DataSource, dst.m_Table)) continue;
            tableOfInterest = table;
            break;
        }
        if (tableOfInterest == null) {
            tableOfInterest = new TableInfo(dst.m_DataSource, dst.m_Table);
            this.m_Nodes.add(tableOfInterest);
        }
        FmTreeNode<FmQueryItemBase> node = bottomNode;
        while (node != null) {
            FmQuerySubjectBase qs = (FmQuerySubjectBase)node.getData().getQueryParent();
            if (node.getChildren().size() <= 1) {
                this.m_TableSubstitutions.put(qs.getQuerySubjectBaseType(), tableOfInterest);
            }
            node = node.getParent();
        }
        columnOfInterest = tableOfInterest.findOrCreateColumn(bottomItem);
        return columnOfInterest;
    }

    public void dump() {
    }

    public TableInfo findNode(Table table) {
        String tableName = table.getName();
        String dataSourceName = table.getDataSource().getName();
        TableInfo nodeOfInterest = null;
        for (TableInfo someNode : this.m_Nodes) {
            if (!someNode.equals(dataSourceName, tableName)) continue;
            nodeOfInterest = someNode;
            break;
        }
        return nodeOfInterest;
    }

    protected void extractQueryItemChain(FmTreeNodeContainer<FmQueryItemBase> parent, FmQueryItemBase qItem) {
        FmTreeNode<FmQueryItemBase> itemNode = parent.addChild(qItem);
        if (qItem.getSourceType() != FmQueryItemBase.ESourceType.kSourceExternal) {
            FmExpression fmExpression = (FmExpression)qItem.getExpression();
            List<ReportObject> refObjs = fmExpression.getRefObjs(true);
            if (refObjs != null) {
                for (ReportObject refObj : refObjs) {
                    if (refObj instanceof FmQueryItem) {
                        this.extractQueryItemChain(itemNode, (FmQueryItem)refObj);
                        continue;
                    }
                    if (!(refObj instanceof FmShortcut)) continue;
                    FmShortcut shortcut = (FmShortcut)refObj;
                    Set<BaseObject> targets = shortcut.getReferencedObjects();
                    for (BaseObject target : targets) {
                        if (target instanceof FmQueryItem) {
                            this.extractQueryItemChain(itemNode, (FmQueryItem)target);
                            continue;
                        }
                        if (target instanceof FmQuerySubject) continue;
                    }
                }
            } else {
                String expression = fmExpression.getExpressionText();
                if (expression != null) {
                    System.out.println("\t" + expression);
                }
            }
        }
    }

    public List<JoinInfo> findJoins(FmDataSource leftDS, String leftName, FmDataSource rightDS, String rightName) {
        ArrayList<JoinInfo> joinList = new ArrayList<JoinInfo>();
        String leftDSName = leftDS.getName();
        String rightDSName = rightDS.getName();
        this.m_DatasourceNames.add(leftDSName);
        this.m_DatasourceNames.add(rightDSName);
        for (JoinInfo candidate : this.m_Connections) {
            TableInfo left = candidate.getLeft();
            TableInfo right = candidate.getRight();
            if (!leftDSName.equals(left.m_DataSourceName) || !leftName.equals(left.m_TableName) || !rightDSName.equals(right.m_DataSourceName) || !rightName.equals(right.m_TableName)) continue;
            joinList.add(candidate);
        }
        return joinList;
    }

    public List<JoinInfo> findJoins(Table start, Table end, boolean bNonDirectional) {
        ArrayList<JoinInfo> joinList = new ArrayList<JoinInfo>();
        String startName = start.getName();
        String startDS = start.getDataSource().getName();
        String endName = end.getName();
        String endDS = end.getDataSource().getName();
        this.m_DatasourceNames.add(startDS);
        this.m_DatasourceNames.add(endDS);
        if (bNonDirectional) {
            for (JoinInfo candidate : this.m_Connections) {
                if (candidate.getLeft().equals(startDS, startName) && candidate.getRight().equals(endDS, endName)) {
                    joinList.add(candidate);
                    continue;
                }
                if (!candidate.getRight().equals(startDS, startName) || !candidate.getLeft().equals(endDS, endName)) continue;
                joinList.add(candidate);
            }
        } else {
            for (JoinInfo candidate : this.m_Connections) {
                if (!candidate.getStartSide().getTable().equals(startDS, startName) || !candidate.getEndSide().getTable().equals(endDS, endName)) continue;
                joinList.add(candidate);
            }
        }
        return joinList;
    }

    public TableInfo findTable(QuerySubjectBaseType querySubjectBaseType) {
        if (this.m_TableSubstitutions.containsKey(querySubjectBaseType)) {
            return this.m_TableSubstitutions.get(querySubjectBaseType);
        }
        return null;
    }

    public void findOrCreateJoins(List<Relationship> relationships) {
        this.m_Relationships = relationships;
        if (relationships.size() > 0) {
            for (DataSource ds : relationships.get(0).getSession().getProject().getDataSources()) {
                this.m_DatasourceNames.add(ds.getName());
            }
        }
        for (Relationship rel : relationships) {
            this.findOrCreateJoin((FmRelationship)rel);
        }
    }

    public List<Relationship> getRelationships() {
        if (this.m_Relationships == null) {
            return new ArrayList<Relationship>();
        }
        return this.m_Relationships;
    }

    public Set<String> getDatasourceNames() {
        return this.m_DatasourceNames;
    }
}

