/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItem;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQueryItemBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmQuerySubjectBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmRelationalObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmReportObject;
import com.ibm.cognos.fmeng.fmmd.impl.model.FmSection;
import com.ibm.cognos.fmeng.fmmd.impl.model.QueryItemParentInternal;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.DimensionBuilder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskDMRtoROLAP.JoinNet;
import com.ibm.cognos.fmeng.fmmd.model.DimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.FmRegularAggregate;
import com.ibm.cognos.fmeng.fmmd.model.FmUsage;
import com.ibm.cognos.fmeng.fmmd.model.Hierarchy;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemParent;
import com.ibm.cognos.fmeng.fmmd.model.Role;
import com.ibm.cognos.fmeng.fmmd.model.Section;
import com.ibm.cognos.fmeng.logging.FmEngApplicationLog;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.utility.FmMDException;
import com.ibm.cognos.fmeng.utility.FmMessage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegularDimensionBuilder
extends DimensionBuilder {
    protected RegularDimensionBuilder(FMMDSession oldSession, FMMDSession newSession, List<FmMessage> messages, JoinNet joins) {
        super(oldSession, newSession, messages, joins);
    }

    public static DimensionBuilder getBuilder(Section newNS, FmQuerySubjectBase qs, List<FmMessage> messages, JoinNet joins) {
        RegularDimensionBuilder db = new RegularDimensionBuilder(qs.getSession(), newNS.getSession(), messages, joins);
        db.m_NS = (FmSection)newNS;
        db.m_SrcDim = qs;
        db.m_NameParent = (FmReportObject)((Object)newNS);
        db.dumpDimensionId();
        return db;
    }

    @Override
    public FmRelationalObject doCreate() {
        FmRelationalDimension destDim = FmRelationalDimension.createRelationalDimension(this.m_NewSession, this.m_NS, this.m_SrcDim.getName(), DimensionBase.DimensionStyle.regular);
        this.m_DestDim = destDim;
        this.copyDimensionNames();
        switch (this.m_SrcDim.getFmObjectType()) {
            case dimension: {
                FmDimension srcDim = (FmDimension)this.m_SrcDim;
                Hierarchy defaultHierarchy = srcDim.getDefaultHierarchy();
                List<Hierarchy> hierarchies = srcDim.getAllHierarchies();
                if (srcDim.getDefaultHierarchy() == null) {
                    FmMessage message = null;
                    if (hierarchies.size() > 0) {
                        message = new FmMessage("BMT_FMI_NO_DEFAULT_HIERARCHY_FIRST", srcDim.getID(), hierarchies.get(0).getID());
                        defaultHierarchy = hierarchies.get(0);
                    } else {
                        message = new FmMessage("BMT_FMI_NO_DEFAULT_HIERARCHY", srcDim.getID());
                    }
                    FmEngApplicationLog.getApplicationLog().logWarn(FmEngApplicationLog.LOGGERS.FM_IMPORT, this.m_NewSession, message.render(this.m_NewSession.getActiveLocale()));
                    this.m_Messages.add(message);
                }
                for (Hierarchy hier : ((FmDimension)this.m_SrcDim).getAllHierarchies()) {
                    String rootMember;
                    String caption;
                    FmHierarchy srcHier = (FmHierarchy)hier;
                    FmMDException.ASSERT(!srcHier.getParentChild(), "Found a DMR parent-child hierarchy. Not supported.");
                    FmRelationalHierarchy newHier = destDim.createHierarchy(hier.getName());
                    newHier.copyCommonProperties(srcHier, destDim);
                    for (String locale : this.m_OldSession.getProject().getSupportedLocales()) {
                        String caption2 = hier.getRootCaption(locale);
                        if (caption2 == null || "".equals(caption2)) continue;
                        newHier.setRootCaption(locale, caption2);
                    }
                    String defaultCaption = newHier.getRootCaption();
                    if ((defaultCaption == null || "".equals(defaultCaption)) && (caption = hier.getRootCaption(this.m_OldSession.getDefaultLocale())) != null && !"".equals(caption)) {
                        newHier.setRootCaption(this.m_NewSession.getDefaultLocale(), caption);
                    }
                    if ((rootMember = hier.getRootMUN()).startsWith("[")) {
                        rootMember = rootMember.substring(1);
                    }
                    if (rootMember.endsWith("]")) {
                        rootMember = rootMember.substring(0, rootMember.length() - 1);
                    }
                    boolean setRootMember = true;
                    for (Level level : hier.getLevels()) {
                        if (!rootMember.equals(level.getName())) continue;
                        setRootMember = false;
                        break;
                    }
                    if (setRootMember) {
                        newHier.setRootMember(rootMember);
                    }
                    if (defaultHierarchy != null && defaultHierarchy.equals(srcHier)) {
                        ((FmRelationalDimension)this.m_DestDim).setDefaultHierarchy(newHier);
                    }
                    for (Level level : hier.getLevels()) {
                        FmQueryItemBase newItem;
                        if (level.isAllLevel()) {
                            newHier.setMultiRoot(false);
                            FmLevel newAllLevel = (FmLevel)newHier.getAllLevel();
                            newAllLevel.copyCommonProperties(level, newHier);
                            continue;
                        }
                        FmLevel newLevel = (FmLevel)FmLevel.createLevelFromLevel(this.m_NewSession, destDim, level);
                        this.copyQueryItems(level, newLevel);
                        FmQueryItemBase itemWithRole = (FmQueryItemBase)level.getItemWithRole(Role.EDefaultRoles.kRoleMemberCaption);
                        if (itemWithRole != null) {
                            newItem = (FmQueryItemBase)this.m_OldItemsToNewItems.get(itemWithRole.getInternal());
                            FmMDException.ASSERT(newItem != null, "Why didn't " + itemWithRole.getID() + " get converted???");
                            newItem.addDefaultRole(Role.EDefaultRoles.kRoleMemberCaption);
                        }
                        if ((itemWithRole = (FmQueryItemBase)level.getItemWithRole(Role.EDefaultRoles.kRoleBusinessKey)) != null) {
                            newItem = (FmQueryItemBase)this.m_OldItemsToNewItems.get(itemWithRole.getInternal());
                            FmMDException.ASSERT(newItem != null, "Why didn't " + itemWithRole.getID() + " get converted???");
                            FmMDException.ASSERT(newItem instanceof FmQueryItem, "How did a non-Query Item get into a level?:" + newItem.getID());
                            newLevel.addLevelKey((QueryItem)((Object)newItem));
                        }
                        newHier.addLevel(newLevel);
                    }
                }
                break;
            }
            case querySubject: {
                FmRelationalHierarchy newHier = destDim.createHierarchy(this.m_SrcDim.getName());
                newHier.setMultiRoot(false);
                newHier.copyCommonProperties(this.m_SrcDim, destDim);
                FmLevel newLevel = FmLevel.createLevel(this.m_NewSession, destDim, this.m_SrcDim.getName());
                newLevel.copyCommonProperties(this.m_SrcDim, newHier);
                this.copyQueryItems(this.m_SrcDim, newLevel);
                newHier.addLevel(newLevel);
                break;
            }
            default: {
                FmMDException.ASSERT(false, "Invalid object for import: " + this.m_SrcDim.getID());
            }
        }
        this.createJoins();
        return (FmRelationalDimensionBase)this.m_DestDim;
    }

    protected void copyQueryItems(QueryItemParent srcQIParent, QueryItemParentInternal destQIParent) {
        for (QueryItem item : srcQIParent.getAllQueryItems()) {
            this.createItemFromSourceItem(destQIParent, (FmQueryItemBase)((Object)item));
        }
    }

    @Override
    protected void postCreateItem(QueryItemParentInternal parent, FmQueryItemBase srcItem, FmQueryItemBase newItem) {
        newItem.setUsage(FmUsage.attribute);
        newItem.setRegularAggregate(FmRegularAggregate.unsupported);
    }
}

