/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.utility.FmMDException;

public class MdlColumn
extends MdlObjectIdTracker {
    private String columnName;
    private String columnID;
    private String origin;
    private int offset;
    private String dataType;
    private int scale;
    private long size;
    private int decimals;
    private String columnClass;
    private int inputScale;
    private String timeArray;
    private String rollup;
    private String colSrcType;
    private int dataSourceObjectId;
    private int columnObjectId;
    private boolean classFound;
    private boolean originFound;
    private boolean timeArrayFound;
    private boolean rollupFound;
    private String[] allowedClasses;
    private String[] allowedOrigins;
    private String[] allowedTimeArrays;
    private String[] allowedRollups;

    public MdlColumn(MdlDataSource ds, String newColName, String newColID, String newOrigin, FmDatatype newStorageType, Integer newScale, Long newSize, Integer newDecimals, String newClass, Integer newInputScale, String newTimeArray, String newRollup, String newColSrcType) throws FmMDException {
        String str;
        int n;
        int n2;
        String[] stringArray;
        block36: {
            block35: {
                block34: {
                    this.columnName = null;
                    this.columnID = null;
                    this.origin = null;
                    this.offset = 0;
                    this.dataType = null;
                    this.scale = 0;
                    this.size = 0L;
                    this.decimals = 0;
                    this.columnClass = null;
                    this.inputScale = 0;
                    this.timeArray = "";
                    this.rollup = null;
                    this.colSrcType = null;
                    this.dataSourceObjectId = 0;
                    this.columnObjectId = 0;
                    this.classFound = false;
                    this.originFound = false;
                    this.timeArrayFound = false;
                    this.rollupFound = false;
                    this.allowedClasses = new String[]{"Default", "Description", "Date", "Quantity", "Ignore", "Member"};
                    this.allowedOrigins = new String[]{"Source", "Generated", "Calculated", "Manual"};
                    this.allowedTimeArrays = new String[]{"Off", "Quarter", "Month", "Month13", "Quarter6", "Month18", "Quarter8", "Month24"};
                    this.allowedRollups = new String[]{"CategoryCount", "Default", "Sum", "Minimum", "Maximum", "Average", "Count", "CountAll", "Any", "None", "External"};
                    this.columnName = newColName;
                    this.columnID = newColID;
                    stringArray = this.allowedOrigins;
                    n2 = this.allowedOrigins.length;
                    n = 0;
                    while (n < n2) {
                        str = stringArray[n];
                        if (str.toLowerCase().contains(newOrigin.toLowerCase())) {
                            this.origin = newOrigin;
                            this.originFound = true;
                            break;
                        }
                        ++n;
                    }
                    if (!this.originFound) {
                        throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_ORIGIN_OPTION", newOrigin);
                    }
                    this.offset = ds.getAssociatedColumns().size();
                    try {
                        this.dataType = this.convertFMStorageTypeToTransformerStorageType(newStorageType);
                    }
                    catch (FmMDException fmMDException) {
                        throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_SCALE_OPTION", newStorageType.toString());
                    }
                    try {
                        if (newScale >= 0) {
                            this.scale = newScale;
                            break block34;
                        }
                        throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_SCALE_OPTION", newScale.toString());
                    }
                    catch (NullPointerException nullPointerException) {
                        this.scale = 0;
                    }
                }
                try {
                    if (newSize >= 0L && newSize <= 255L) {
                        this.size = newSize;
                        break block35;
                    }
                    throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_SIZE_OPTION", newSize.toString());
                }
                catch (NullPointerException nullPointerException) {
                    this.size = 0L;
                }
            }
            try {
                if (newDecimals >= 0) {
                    this.decimals = newDecimals;
                    break block36;
                }
                throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_DECIMALS_OPTION", newDecimals.toString());
            }
            catch (NullPointerException nullPointerException) {
                this.decimals = 0;
            }
        }
        if (FmDatatype.isNumeric(newStorageType).booleanValue()) {
            this.columnClass = "Quantity";
        } else if (FmDatatype.isString(newStorageType).booleanValue()) {
            this.columnClass = "Description";
        } else if (newClass == "") {
            this.columnClass = "Default";
        } else {
            stringArray = this.allowedClasses;
            n2 = this.allowedClasses.length;
            n = 0;
            while (n < n2) {
                str = stringArray[n];
                if (str.toLowerCase().contains(newClass.toLowerCase())) {
                    this.columnClass = newClass;
                    this.classFound = true;
                    break;
                }
                ++n;
            }
            if (this.classFound) {
                throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_CLASS_OPTION", newClass);
            }
        }
        if (newInputScale < 0 || newInputScale > 16) {
            throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_INPUT_SCALE_OPTION", newInputScale.toString());
        }
        this.inputScale = newInputScale;
        if (newTimeArray.equals("") || newTimeArray.equals(null)) {
            this.timeArray = "Off";
            this.timeArrayFound = true;
        } else {
            stringArray = this.allowedTimeArrays;
            n2 = this.allowedTimeArrays.length;
            n = 0;
            while (n < n2) {
                str = stringArray[n];
                if (str.toLowerCase().contains(newTimeArray.toLowerCase())) {
                    this.timeArray = newTimeArray;
                    this.timeArrayFound = true;
                    break;
                }
                ++n;
            }
        }
        if (!this.timeArrayFound) {
            throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_TIME_ARRAY_OPTION", newTimeArray);
        }
        if (newRollup.equals("") || newRollup.equals(null)) {
            this.rollup = "Default";
            this.rollupFound = true;
        } else {
            stringArray = this.allowedRollups;
            n2 = this.allowedRollups.length;
            n = 0;
            while (n < n2) {
                str = stringArray[n];
                if (str.toLowerCase().equals(newRollup.toLowerCase())) {
                    this.rollup = newRollup;
                    this.rollupFound = true;
                    break;
                }
                ++n;
            }
        }
        if (!this.rollupFound) {
            throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_ROLLUP_OPTION", newRollup);
        }
        this.colSrcType = newColSrcType;
        this.dataSourceObjectId = ds.getDataSourceObjectId();
        this.columnObjectId = MdlColumn.getAndIncreaseNextAvailableObjectId();
        ds.associateColumnToDataSource(this.columnObjectId);
    }

    public String getColSrcType() {
        return this.colSrcType;
    }

    public String getColumnClass() {
        return this.columnClass;
    }

    public String getColumnID() {
        return this.columnID;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnObjectId() {
        return this.columnObjectId;
    }

    public int getDataSourceObjectId() {
        return this.dataSourceObjectId;
    }

    public String getDataType() {
        return this.dataType;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public int getInputScale() {
        return this.inputScale;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getOrigin() {
        return this.origin;
    }

    public String getRollup() {
        return this.rollup;
    }

    public int getScale() {
        return this.scale;
    }

    public long getSize() {
        return this.size;
    }

    public String getStorage() {
        return this.dataType;
    }

    public String getTimeArray() {
        return this.timeArray;
    }

    public void setColSrcType(String colSrcType) {
        this.colSrcType = colSrcType;
    }

    public void setColumnClass(String columnClass) {
        this.columnClass = columnClass;
    }

    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public void setInputScale(int inputScale) {
        this.inputScale = inputScale;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
    }

    public void setRollup(String rollup) {
        this.rollup = rollup;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setStorage(String dataType) {
        this.dataType = dataType;
    }

    public void setTimeArray(String timeArray) {
        this.timeArray = timeArray;
    }

    public String convertFMStorageTypeToTransformerStorageType(FmDatatype fmDt) throws FmMDException {
        if (FmDatatype.isNumeric(fmDt).booleanValue()) {
            if (FmDatatype.isDecimal(fmDt).booleanValue()) {
                switch (fmDt) {
                    case DECIMAL: 
                    case FLOAT: 
                    case FLOAT32: 
                    case FLOAT64: {
                        return "Float64";
                    }
                }
            } else if (FmDatatype.isInteger(fmDt).booleanValue()) {
                switch (fmDt) {
                    case INT16: {
                        return "Int16";
                    }
                    case INT32: {
                        return "Int32";
                    }
                    case INT64: {
                        return "Float64";
                    }
                }
            }
        } else if (FmDatatype.isString(fmDt).booleanValue()) {
            switch (fmDt) {
                case CHARACTER: 
                case CHARACTERLENGTH16: 
                case CHARACTERLENGTH32: {
                    return "Character";
                }
                case NCHAR: 
                case NVARCHAR: {
                    return "LongText";
                }
            }
        } else {
            switch (fmDt) {
                case DATE: 
                case TIME: 
                case DATETIME: 
                case TIMEINTERVAL: {
                    return "Text";
                }
                case UNKNOWN: 
                case UNSUPPORTED: 
                case BINARY: 
                case BINARYLENGTH16: 
                case BLOB: 
                case TEXTBLOB: 
                case BLOBARRAY: 
                case DATABASEKEY: 
                case VARBIT: 
                case BIT: 
                case BOOLEAN: 
                case TIMETZ: 
                case TIMESTAMPTZ: 
                case INTERVALYM: {
                    throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_STORAGE_OPTION", fmDt.toString());
                }
            }
        }
        throw new FmMDException("BMT_MD_INVALID_MDL_COLUMN_STORAGE_OPTION", fmDt.toString());
    }

    public String toString() {
        String MdlColumnToString = "";
        MdlColumnToString = String.valueOf(MdlColumnToString) + "Column name: " + this.columnName + " Column ID: " + this.columnID + " Origin: " + this.origin + " Offset: " + this.offset + " Data Type: " + this.dataType + " Scale: " + this.scale + " Size: " + this.size + " Decimals: " + this.decimals + " Class: " + this.columnClass + " Input Scale: " + this.inputScale + " Time Array: " + this.timeArray + " Rollup: " + this.rollup + " ColSrcType: " + this.colSrcType + " DataSourceId: " + this.dataSourceObjectId + " ColumnObjectId: " + this.columnObjectId + "\n";
        return MdlColumnToString;
    }
}

