/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlPackage;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdlDataSource
extends MdlObjectIdTracker {
    private MdlPackage dataSourcePackage;
    private String dataSourceType = "";
    private String sourcePath = "";
    private String dataSource = "";
    private String separator = "";
    private String sourceType = "";
    private String characterSet = "";
    private String decimalSeperator = "";
    private String thousandSeparator = "";
    private boolean columns;
    private String timing = "";
    private boolean autoSummary;
    private boolean setCurrent;
    private boolean serverSource;
    private boolean speed;
    private boolean presummarized;
    private int streamExtractSize = 0;
    private int dataSourceObjectId = 0;
    private int packageObjectId = 0;
    private ArrayList<Integer> associatedColumns;
    private ArrayList<Integer> associatedMeasures;
    private String[] allowedCharacterSets = new String[]{"Default", "ANSI", "OEM", "Unicode", "Multibyte"};
    private String[] allowedSourceTypes = new String[]{"FlatFileClNames", "FlatFile", "DataSource", "Access", "AccessQuery", "ExcelCrosstab", "ExcelDatabase", "PowerHousePortable", "FixedASCII", "FixedASCIINoCrlf", "Dictionary", "CognosSourceQuery", "package", "report"};
    private String[] allowedTimings = new String[]{"PopNoCreateNo, PopYesCreateNo, PopNoCreateDefault, PopYesCreateDefault, PopNoCreateYes, PopYesCreateYes"};

    public MdlDataSource(String newSourcePath, String newContentStoreDataSourceConnection, boolean isAutoSummaryEnabled) {
        this.sourcePath = newSourcePath;
        String delims = "[']+";
        String[] tokens = this.sourcePath.split(delims);
        this.dataSourcePackage = new MdlPackage(tokens[tokens.length - 2], newContentStoreDataSourceConnection);
        this.packageObjectId = this.dataSourcePackage.getPackageObjectId();
        this.dataSourceObjectId = MdlDataSource.getAndIncreaseNextAvailableObjectId();
        this.associatedColumns = new ArrayList();
        this.associatedMeasures = new ArrayList();
        delims = "[/\\[]";
        tokens = this.sourcePath.split(delims);
        this.sourceType = tokens[tokens.length - 2];
        this.dataSource = String.valueOf(this.dataSourcePackage.getPackageName()) + "~1";
        this.separator = ",";
        this.sourceType = "CognosSourceQuery";
        this.characterSet = "Default";
        this.decimalSeperator = ".";
        this.thousandSeparator = ",";
        this.columns = true;
        this.timing = "PopYesCreateDefault";
        this.autoSummary = isAutoSummaryEnabled;
        this.setCurrent = true;
        this.serverSource = false;
        this.speed = false;
        this.presummarized = false;
        this.streamExtractSize = 0;
    }

    public void associateColumnToDataSource(int newColumnId) {
        this.associatedColumns.add(newColumnId);
    }

    public void associateMeasureToDataSource(int newMeasureId) {
        this.associatedMeasures.add(newMeasureId);
    }

    public ArrayList<Integer> getAssociatedColumns() {
        return this.associatedColumns;
    }

    public ArrayList<Integer> getAssociatedMeasures() {
        return this.associatedMeasures;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public String getCognosPackageConnection() {
        return this.dataSourcePackage.getCognosPackageConnection();
    }

    public String getCognosPackageConnectionSignon() {
        return this.dataSourcePackage.getCognosPackageConnectionSignon();
    }

    public String getCognosPackageDatasourceConnection() {
        return this.dataSourcePackage.getCognosPackageDatasourceConnection();
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public int getDataSourceObjectId() {
        return this.dataSourceObjectId;
    }

    public MdlPackage getDataSourcePackage() {
        return this.dataSourcePackage;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public String getDecimalSeperator() {
        return this.decimalSeperator;
    }

    public MdlPackage getPackage() {
        return this.dataSourcePackage;
    }

    public String getPackageFullyQualifiedPath() {
        return this.dataSourcePackage.getFullyQualifiedPath();
    }

    public String getPackageName() {
        return this.dataSourcePackage.getPackageName();
    }

    public int getPackageObjectId() {
        return this.packageObjectId;
    }

    public String getPackageReportSource() {
        return this.dataSourcePackage.getPackageReportSource();
    }

    public String getPackageSourcePath() {
        return this.dataSourcePackage.getSourcePath();
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public int getStreamExtractSize() {
        return this.streamExtractSize;
    }

    public String getThousandSeparator() {
        return this.thousandSeparator;
    }

    public String getTiming() {
        return this.timing;
    }

    public boolean hasAssociatedColumns() {
        return this.associatedColumns.size() > 0;
    }

    public boolean hasAssociatedMeasures() {
        return this.associatedMeasures.size() > 0;
    }

    public boolean isAutoSummary() {
        return this.autoSummary;
    }

    public boolean isAutoSummaryEnabled() {
        return this.autoSummary;
    }

    public boolean isCognosPackageAlwaysUseTransformerSignonEnabled() {
        return this.dataSourcePackage.isCognosPackageAlwaysUseTransformerSignon();
    }

    public boolean isCognosPackagePowercubeSource() {
        return this.dataSourcePackage.isCognosPackagePowercubeSource();
    }

    public boolean isColumns() {
        return this.columns;
    }

    public boolean isColumnsEnabled() {
        return this.columns;
    }

    public boolean isPresummarized() {
        return this.presummarized;
    }

    public boolean isServerSource() {
        return this.serverSource;
    }

    public boolean isServerSourceEnabled() {
        return this.serverSource;
    }

    public boolean isSetCurrent() {
        return this.setCurrent;
    }

    public boolean isSetCurrentEnabled() {
        return this.setCurrent;
    }

    public boolean isSpeed() {
        return this.speed;
    }

    public boolean isSpeedEnabled() {
        return this.speed;
    }

    public void setAllowedCharacterSets(String[] allowedCharacterSets) {
        this.allowedCharacterSets = allowedCharacterSets;
    }

    public void setAssociatedColumns(ArrayList<Integer> associatedColumns) {
        this.associatedColumns = associatedColumns;
    }

    public void setAssociatedMeasures(ArrayList<Integer> associatedMeasures) {
        this.associatedMeasures = associatedMeasures;
    }

    public void setAutoSummary(boolean autoSummary) {
        this.autoSummary = autoSummary;
    }

    public void setCharacterSet(String characterSet) {
        boolean characterSetFound = false;
        String[] stringArray = this.allowedCharacterSets;
        int n = this.allowedCharacterSets.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(characterSet.toLowerCase())) {
                this.characterSet = characterSet;
                characterSetFound = true;
                break;
            }
            ++n2;
        }
        if (!characterSetFound) {
            throw new FmMDException("BMT_MD_INVALID_CHARACTER_SET_OPTION_IN_MDL_DATA_SOURCE", characterSet);
        }
    }

    public void setColumns(boolean columns) {
        this.columns = columns;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setDataSourcePackage(MdlPackage dataSourcePackage) {
        this.dataSourcePackage = dataSourcePackage;
    }

    public void setDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void setDecimalSeperator(String decimalSeperator) {
        this.decimalSeperator = decimalSeperator;
    }

    public void setPackageObjectId(int packageObjectId) {
        this.packageObjectId = packageObjectId;
    }

    public void setPresummarized(boolean presummarized) {
        this.presummarized = presummarized;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setServerSource(boolean serverSource) {
        this.serverSource = serverSource;
    }

    public void setSetCurrent(boolean setCurrent) {
        this.setCurrent = setCurrent;
    }

    public void setSourcePath(String sourcePath) {
        this.sourcePath = sourcePath;
    }

    public void setSourceType(String sourceType) {
        boolean sourceTypeFound = false;
        String[] stringArray = this.allowedSourceTypes;
        int n = this.allowedSourceTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(sourceType.toLowerCase())) {
                this.sourceType = sourceType;
                sourceTypeFound = true;
                break;
            }
            ++n2;
        }
        if (!sourceTypeFound) {
            throw new FmMDException("BMT_MD_INVALID_SOURCE_TYPE_OPTION_IN_MDL_DATA_SOURCE", sourceType);
        }
    }

    public void setSpeed(boolean speed) {
        this.speed = speed;
    }

    public void setStreamExtractSize(int streamExtractSize) {
        this.streamExtractSize = streamExtractSize;
    }

    public void setThousandSeparator(String thousandSeparator) {
        this.thousandSeparator = thousandSeparator;
    }

    public void setTiming(String timing) {
        boolean timingFound = false;
        String[] stringArray = this.allowedTimings;
        int n = this.allowedTimings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(timing.toLowerCase())) {
                this.timing = timing;
                timingFound = true;
                break;
            }
            ++n2;
        }
        if (!timingFound) {
            throw new FmMDException("BMT_MD_INVALID_TIMING_OPTION_IN_MDL_DATA_SOURCE", timing);
        }
    }

    public String toString() {
        String MdlDataSourceToString = "";
        MdlDataSourceToString = String.valueOf(MdlDataSourceToString) + "DataSource: " + this.dataSource + " SourcePath: " + this.sourcePath + " DataSource Type: " + this.dataSourceType + " DataSourceObjectId: " + this.dataSourceObjectId + " Next Available ObjectId: " + nextAvailableObjectId + " #of associated measures: " + this.associatedMeasures.size() + " #of associated columns: " + this.associatedColumns.size() + " PackageObjectId: " + this.packageObjectId + " SourceType: " + this.sourceType + " Separator: " + this.separator + " CharacterSet: " + this.characterSet + " DecimalSeparator: " + this.decimalSeperator + " ThousandSeparator: " + this.thousandSeparator + " Columns: " + this.columns + " Timing: " + this.timing + " AutoSummary: " + this.autoSummary + " SetCurrent: " + this.setCurrent + " ServerSource: " + this.serverSource + " Speed: " + this.speed + " Presummarized: " + this.presummarized + " StreamExtractSize: " + this.streamExtractSize + "\n";
        return MdlDataSourceToString;
    }
}

