/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDrill;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlHolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlRoot;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlView;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdlDimension
extends MdlObjectIdTracker {
    private int dimensionObjectId = 0;
    private String dimensionName = null;
    private ArrayList<MdlDrill> drillStack;
    private MdlRoot root;
    private String dimensionType = null;
    private boolean newCategoryLock = false;
    private boolean excludeAutoPartitioning = false;
    private int dimDefaultCategory = 0;
    private MdlHolder referenceMdlHolder;
    private ArrayList<MdlView> viewStack;
    private String[] allowedDimensionTypes = new String[]{"Regular", "Date", "NonStandard"};

    public MdlDimension(String newDimensionName, MdlHolder mdlHolder) {
        this.dimensionObjectId = MdlDimension.getAndIncreaseNextAvailableObjectId();
        this.dimensionName = newDimensionName;
        this.root = new MdlRoot(newDimensionName);
        this.drillStack = new ArrayList();
        this.drillStack.add(new MdlDrill(newDimensionName));
        this.dimensionType = "Regular";
        this.newCategoryLock = false;
        this.excludeAutoPartitioning = false;
        this.dimDefaultCategory = 0;
        this.referenceMdlHolder = mdlHolder;
        this.viewStack = new ArrayList();
        this.viewStack.add(new MdlView("All Categories", "All"));
        this.viewStack.add(new MdlView("Omit Dimension", "Omit"));
    }

    public MdlDrill addDrill(String newDrillName) {
        this.drillStack.add(new MdlDrill(this.dimensionName));
        return null;
    }

    public MdlLevel addLevel() {
        return this.drillStack.get(0).addLevel(new MdlLevel(this.referenceMdlHolder));
    }

    public MdlLevel addLevel(String newLevelName) {
        return this.drillStack.get(0).addLevel(new MdlLevel(newLevelName, this.referenceMdlHolder));
    }

    public MdlLevel addLevel(MdlDrill destinationDrill) {
        for (MdlDrill md : this.drillStack) {
            if (!md.equals(destinationDrill)) continue;
            return md.addLevel(new MdlLevel(this.referenceMdlHolder));
        }
        return null;
    }

    public int getDimDefaultCategory() {
        return this.dimDefaultCategory;
    }

    public String getDimensionName() {
        return this.dimensionName;
    }

    public int getDimensionObjectId() {
        return this.dimensionObjectId;
    }

    public String getDimensionType() {
        return this.dimensionType;
    }

    public ArrayList<MdlDrill> getDrillStack() {
        return this.drillStack;
    }

    public MdlHolder getReferenceMdlHolder() {
        return this.referenceMdlHolder;
    }

    public MdlRoot getRoot() {
        return this.root;
    }

    public ArrayList<MdlView> getViewStack() {
        return this.viewStack;
    }

    public boolean isExcludeAutoPartitioning() {
        return this.excludeAutoPartitioning;
    }

    public void setDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
    }

    public void setDimensionType(String dimensionType) {
        boolean dimensionTypeFound = false;
        String[] stringArray = this.allowedDimensionTypes;
        int n = this.allowedDimensionTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(dimensionType.toLowerCase())) {
                this.dimensionType = dimensionType;
                dimensionTypeFound = true;
                break;
            }
            ++n2;
        }
        if (!dimensionTypeFound) {
            throw new FmMDException("BMT_MD_INVALID_DIMENSION_TYPE_OPTION_IN_MDL_DIMENSION", dimensionType);
        }
    }

    public void setNewCategoryLock(boolean newCategoryLock) {
        this.newCategoryLock = newCategoryLock;
    }

    public void setExcludeAutoPartitioning(boolean excludeAutoPartitioning) {
        this.excludeAutoPartitioning = excludeAutoPartitioning;
    }

    public void setDimDefaultCategory(int dimDefaultCategory) {
        this.dimDefaultCategory = dimDefaultCategory;
    }

    public boolean isNewCategoryLock() {
        return this.newCategoryLock;
    }
}

