/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdlDrill
extends MdlObjectIdTracker {
    private int drillObjectId = 0;
    private String drillName = null;
    private String inclusion = null;
    private boolean isFiltered = false;
    private boolean isSuppressed = false;
    private boolean isPrimaryDrill = false;
    private boolean isHidingValue = false;
    private ArrayList<MdlLevel> levelStack;
    private String[] allowedInclusion = new String[]{"Default", "Generate", "Suppress", "Retain", "Filtered"};

    public MdlDrill(MdlColumn referenceColumn) {
        this.drillObjectId = MdlDrill.getAndIncreaseNextAvailableObjectId();
        this.drillName = "By " + referenceColumn.getColumnName();
        this.inclusion = "Suppress";
        this.isFiltered = false;
        this.isSuppressed = true;
        this.isPrimaryDrill = false;
        this.isHidingValue = false;
        this.levelStack = new ArrayList();
    }

    public MdlDrill(String newDrillName) {
        this.drillObjectId = MdlDrill.getAndIncreaseNextAvailableObjectId();
        this.drillName = "By " + newDrillName;
        this.inclusion = "Suppress";
        this.isFiltered = false;
        this.isSuppressed = true;
        this.isPrimaryDrill = false;
        this.isHidingValue = false;
        this.levelStack = new ArrayList();
    }

    public MdlLevel addLevel(MdlLevel newLevel) {
        this.levelStack.add(newLevel);
        return this.levelStack.get(this.levelStack.size() - 1);
    }

    public String getDrillName() {
        return this.drillName;
    }

    public int getDrillObjectId() {
        return this.drillObjectId;
    }

    public String getInclusion() {
        return this.inclusion;
    }

    public ArrayList<MdlLevel> getLevelStack() {
        return this.levelStack;
    }

    public boolean isFiltered() {
        return this.isFiltered;
    }

    public boolean isHidingValue() {
        return this.isHidingValue;
    }

    public boolean isPrimaryDrill() {
        return this.isPrimaryDrill;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public void setDrillName(String drillName) {
        this.drillName = drillName;
    }

    public void setInclusion(String inclusion) {
        boolean inclusionFound = false;
        String[] stringArray = this.allowedInclusion;
        int n = this.allowedInclusion.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(inclusion.toLowerCase())) {
                this.inclusion = inclusion;
                inclusionFound = true;
                break;
            }
            ++n2;
        }
        if (!inclusionFound) {
            throw new FmMDException("BMT_MD_INVALID_INCLUSION_OPTION_IN_MDL_DRILL", inclusion);
        }
    }

    public void setFiltered(boolean isFiltered) {
        this.isFiltered = isFiltered;
    }

    public void setSuppressed(boolean isSuppressed) {
        this.isSuppressed = isSuppressed;
    }

    public void setPrimaryDrill(boolean isPrimaryDrill) {
        this.isPrimaryDrill = isPrimaryDrill;
    }

    public void setHidingValue(boolean isHidingValue) {
        this.isHidingValue = isHidingValue;
    }

    public void setLevelStack(ArrayList<MdlLevel> levelStack) {
        this.levelStack = levelStack;
    }
}

