/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.FmObjectType;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlHolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlPowerCube;
import com.ibm.cognos.fmeng.fmmd.model.Cube;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.fmmd.model.Level;
import com.ibm.cognos.fmeng.fmmd.model.LevelReference;
import com.ibm.cognos.fmeng.fmmd.model.Measure;
import com.ibm.cognos.fmeng.fmmd.model.MeasureDimension;
import com.ibm.cognos.fmeng.fmmd.model.Namespace;
import com.ibm.cognos.fmeng.fmmd.model.Package;
import com.ibm.cognos.fmeng.fmmd.model.Property;
import com.ibm.cognos.fmeng.fmmd.model.QueryItem;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimension;
import com.ibm.cognos.fmeng.fmmd.model.RelationalDimensionBase;
import com.ibm.cognos.fmeng.fmmd.model.RelationalHierarchy;
import com.ibm.cognos.fmeng.fmmd.model.ReportObject;
import com.ibm.cognos.fmeng.fmmd.model.TaskROLAPtoDMR;
import com.ibm.cognos.fmeng.platform.FMMDSession;
import com.ibm.cognos.fmeng.platform.ProjectFactory;
import java.util.ArrayList;
import java.util.List;

public class MdlExportPowerCube {
    private String m_packagePath = "";
    private MdlHolder m_mdl = new MdlHolder();

    public void exportPCube(Cube cube, FMMDSession session, String cubeFilePath) throws Exception {
        FMMDSession dmrSession = FMMDSession.createFMMDSession(session);
        dmrSession.create(ProjectFactory.createInMemoryProject());
        Namespace rootNS = dmrSession.getProject().getRootNamespace();
        TaskROLAPtoDMR task = session.getTaskROLAPtoDMR();
        task.convertFromCube(rootNS, cube, false);
        ArrayList<ReportObject> includeObjects = new ArrayList<ReportObject>();
        includeObjects.add(rootNS);
        Package pkg = dmrSession.getProject().createPackage(cube.getName(), "", "", new ArrayList<String>(), includeObjects, new ArrayList<ReportObject>(), new ArrayList<ReportObject>(), null);
        pkg.setUseV5DataServer(true);
        String cmPath = "/content";
        pkg.publishToCM(cmPath, null);
        this.m_packagePath = String.valueOf(cmPath) + "/package[@name=\"" + cube.getName() + "\"]";
        List<RelationalDimensionBase> dimensions = cube.getAllReferencedDimensions();
        MeasureDimension measureDim = cube.getMeasureDimension();
        this.m_mdl.setModel(cube.getName(), "10.1", false, "OrderUsePreference", false, "windows-1252");
        List<DataSource> dataSources = dmrSession.getProject().getDataSources();
        dataSources.size();
        MdlDataSource ds = this.m_mdl.addDataSource(this.m_packagePath, dataSources.get(0).getCmDataSourceName(), true);
        int i = 0;
        while (i < dimensions.size()) {
            if (dimensions.get(i).getFmObjectType() != FmObjectType.measureDimension) {
                this.addDimension(ds, (RelationalDimension)dimensions.get(i));
            } else {
                this.addMeasureDim(ds, measureDim);
            }
            ++i;
        }
        MdlPowerCube mpc = this.m_mdl.addPowerCube(String.valueOf(cube.getName()) + "_cubeSource", cubeFilePath);
        this.m_mdl.generateMDLFile(String.valueOf(cubeFilePath) + cube.getName());
        this.m_mdl.generatePowerCube(mpc);
        Property prop = cube.createCustomProperty("CreateLWMAggrCube");
        prop.setType(Property.PropType.BOOLEAN_TYPE);
        prop.setValue("true");
    }

    private void addDimension(MdlDataSource ds, RelationalDimension dim) throws Exception {
        MdlDimension mdlDim = this.m_mdl.addDimension(dim.getName());
        ArrayList<String> addedColumnNames = new ArrayList<String>();
        List hierarchies = dim.getAllHierarchies();
        int h = 0;
        while (h < hierarchies.size()) {
            List<LevelReference> levelRefs = ((RelationalHierarchy)hierarchies.get(h)).getLevelReferences();
            int l = 0;
            while (l < levelRefs.size()) {
                Level level = levelRefs.get(l).getLevel();
                List<QueryItem> queryItems = level.getLevelKeys();
                MdlColumn column = null;
                int q = 0;
                while (q < queryItems.size()) {
                    if (!addedColumnNames.contains(queryItems.get(q).getName())) {
                        column = this.addDataSourceColumn(ds, queryItems.get(q));
                        addedColumnNames.add(queryItems.get(q).getName());
                    }
                    ++q;
                }
                if (column != null) {
                    MdlLevel mdlLevel = mdlDim.addLevel(level.getName());
                    mdlLevel.setColumn(column, "Role_Source", "Type_Query");
                }
                ++l;
            }
            ++h;
        }
    }

    private void addMeasureDim(MdlDataSource ds, MeasureDimension measureDim) throws Exception {
        List<Measure> measures = measureDim.getAllMeasures();
        int i = 0;
        while (i < measures.size()) {
            QueryItemBase qi = measures.get(i);
            MdlColumn column = this.addDataSourceColumn(ds, qi);
            this.m_mdl.addMeasure(column);
            ++i;
        }
    }

    private MdlColumn addDataSourceColumn(MdlDataSource ds, QueryItemBase queryItem) throws Exception {
        String id = this.generateId(queryItem);
        String name = queryItem.getName();
        FmDatatype dataType = queryItem.getDatatype();
        Integer scale = queryItem.getScale();
        Long size = queryItem.getSize();
        return this.m_mdl.addColumn(ds, name, id, "Source", dataType, scale, size, 0, "", 0, "Off", "Sum", "None");
    }

    private String generateId(QueryItemBase queryItem) {
        StringBuffer id = new StringBuffer(queryItem.getID());
        int i1 = id.indexOf("].[");
        int i2 = id.indexOf("].[", i1 + 3);
        StringBuffer newId = new StringBuffer("[Business View");
        newId.append(id.substring(i1, i2));
        newId.append("].[");
        newId.append(queryItem.getName());
        newId.append("]");
        return newId.toString();
    }
}

