/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDrill;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlHolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlLevel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlPowerCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlTransformerModel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlView;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;

public class MdlGenerator {
    public String filePathWithFileName = "";
    private String fileName = "";
    private String filePathWithoutFileName = "";
    private ArrayList<MdlDataSource> dsStack;
    private ArrayList<MdlDimension> dimStack;
    private ArrayList<MdlMeasure> measureStack;
    private MdlTransformerModel tfModel;
    private MdlHolder mdlHolder;
    private boolean tfModelAlreadyPrinted = false;
    static boolean m_dump = false;

    public void initializeFromHolder(MdlHolder referenceMdlHolder) {
        this.dsStack = referenceMdlHolder.getDataSourceStack();
        this.dimStack = referenceMdlHolder.getDimensionStack();
        this.measureStack = referenceMdlHolder.getMeasureStack();
        this.tfModel = referenceMdlHolder.getTransformerModel();
        this.mdlHolder = referenceMdlHolder;
        this.tfModelAlreadyPrinted = false;
    }

    public boolean generateMDLFile(String newFilePathWithFileName, MdlHolder referenceMdlHolder) throws IOException {
        this.dsStack = referenceMdlHolder.getDataSourceStack();
        this.dimStack = referenceMdlHolder.getDimensionStack();
        this.measureStack = referenceMdlHolder.getMeasureStack();
        this.tfModel = referenceMdlHolder.getTransformerModel();
        this.mdlHolder = referenceMdlHolder;
        this.tfModelAlreadyPrinted = false;
        this.filePathWithFileName = newFilePathWithFileName;
        if (m_dump) {
            System.out.println("Generating MDL File...");
        }
        if (this.appendToFile(this.filePathWithFileName)) {
            if (m_dump) {
                System.out.println("MDL File \"" + this.filePathWithFileName + ".mdl\" was successfully generated!");
            }
            return true;
        }
        throw new FmMDException("BMT_MD_MDL_FILE_NOT_GENERATED_FILENAME_FROM_PROGRAM", String.valueOf(newFilePathWithFileName) + ".mdl");
    }

    public boolean appendToFile(String newFileNameAndPath) {
        this.filePathWithFileName = newFileNameAndPath;
        this.filePathWithoutFileName = this.filePathWithFileName.substring(0, this.filePathWithFileName.lastIndexOf(File.separator));
        this.fileName = String.valueOf(this.filePathWithFileName.substring(this.filePathWithFileName.lastIndexOf(File.separator) + 1, this.filePathWithFileName.length())) + ".mdl";
        File directoryToCheck = new File(this.filePathWithoutFileName);
        if (directoryToCheck.exists()) {
            if (m_dump) {
                System.out.println("Directory \"" + this.filePathWithoutFileName + "\" exists.");
            }
        } else {
            if (m_dump) {
                System.out.println("Directory \"" + this.filePathWithoutFileName + "\" does not exist.");
            }
            if (new File(this.filePathWithoutFileName).mkdirs()) {
                if (m_dump) {
                    System.out.println("Creating directory: \t\"" + this.filePathWithoutFileName + "\"");
                    System.out.println("Directory created: \t\"" + this.filePathWithoutFileName + "\"");
                }
            } else {
                throw new FmMDException("BMT_MD_MDL_FILE_DIRECTORY_NOT_CREATED", this.filePathWithoutFileName);
            }
        }
        this.mdlHolder.setLastUsedMdlFileNameAndPath(this.filePathWithFileName);
        this.mdlHolder.setLastUsedMdlFileName(this.fileName);
        this.mdlHolder.setLastUsedMdlFilePath(this.filePathWithoutFileName);
        try {
            File mdlFile = new File(String.valueOf(this.filePathWithFileName) + ".mdl");
            if (!mdlFile.exists()) {
                System.out.println("File " + mdlFile.toString() + " does not exist");
                System.out.println("Creating file " + mdlFile.toString());
                mdlFile.createNewFile();
                System.out.println("File " + mdlFile.toString() + " successfully created and in use");
            } else if (mdlFile.exists()) {
                System.out.println("File " + mdlFile.toString() + " already exists");
                File oldMdlFile = new File(String.valueOf(mdlFile.toString()) + ".old");
                System.out.println("Renaming file " + mdlFile.toString() + " to " + oldMdlFile.toString());
                if (oldMdlFile.exists()) {
                    System.out.println("A file with the same name already exists " + oldMdlFile.toString());
                    System.out.println("Deleting file with same name: " + oldMdlFile.toString());
                    System.out.println("File " + oldMdlFile.toString() + " has been deleted: " + oldMdlFile.delete());
                }
                if (mdlFile.renameTo(oldMdlFile)) {
                    System.out.println("File Successfully renamed to " + oldMdlFile.toString());
                    mdlFile = new File(String.valueOf(this.filePathWithFileName) + ".mdl");
                    System.out.println("New file name in use: " + mdlFile.toString());
                    mdlFile.createNewFile();
                    System.out.println("File " + mdlFile.toString() + " successfully created and in use");
                }
            }
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(mdlFile), "UTF8"));
            System.out.println("Building MDL File:\t" + this.fileName);
            System.out.println("Adding model");
            out.write("\n");
            out.write("Name \"" + this.tfModel.getModelName() + "\" ModelCodePage \"" + this.tfModel.getModelCodePage() + "\" AutoAccess " + this.tfModel.isAutoAccessEnabled() + " UpdateCycle " + this.tfModel.getUpdateCycle() + " \n");
            out.write("ModelStamp " + this.tfModel.getModelStamp() + " Version \"" + this.tfModel.getModelVersion() + "\" ModelCategoryOrderDefault " + this.tfModel.getModelCategoryOrderDefault() + " \n");
            out.write("ModelOrderedByDefault " + this.tfModel.isModelOrderedByDefault());
            out.write("\n");
            System.out.println("Adding cognos package sources");
            for (MdlDataSource mds : this.dsStack) {
                out.write("\n");
                out.write("CognosSource " + mds.getPackageObjectId() + " \"" + mds.getPackageName() + "\" SourceType Package SourcePath \"" + mds.getPackageSourcePath() + "\" \n");
                out.write("PackageTimeStamp \"" + mds.getPackageFullyQualifiedPath() + "\" \n");
                out.write("\n");
                System.out.println("Adding transformer model");
                if (this.tfModelAlreadyPrinted) continue;
                out.write("\n");
                out.write("CognosPackageDatasourceConnection " + this.tfModel.getTransformerModelObjectId() + " \"" + mds.getCognosPackageDatasourceConnection() + "\" PackageReportSource " + mds.getPackageObjectId() + " \n");
                out.write("\"" + mds.getPackageReportSource() + "\" CognosPackageConnection \"" + mds.getCognosPackageConnection() + "\" CognosPackageConnectionSignon \"" + mds.getCognosPackageConnectionSignon() + "\" \n");
                out.write("CognosPackageAlwaysUseTransformerSignon " + mds.isCognosPackageAlwaysUseTransformerSignonEnabled() + " CognosPackagePowercubeSource " + mds.isCognosPackagePowercubeSource() + " \n");
                out.write("\n");
                this.tfModelAlreadyPrinted = true;
            }
            out.write("\n");
            System.out.println("Adding data sources");
            for (MdlDataSource mds : this.dsStack) {
                out.write("DataSource " + mds.getDataSourceObjectId() + " \"" + mds.getDataSource() + "\" Separator \"" + mds.getSeparator() + "\" SourceType " + mds.getSourceType() + " \n");
                out.write("CharacterSet " + mds.getCharacterSet() + " DecimalSep \"" + mds.getDecimalSeperator() + "\" Thousandsep \"" + mds.getThousandSeparator() + "\" Columns " + mds.isColumnsEnabled() + " Timing " + mds.getTiming() + " \n");
                out.write("PackageReportSource " + mds.getPackageObjectId() + " \"" + mds.getPackageReportSource() + "\" AutoSummary " + mds.isAutoSummaryEnabled() + " SetCurrent " + mds.isSetCurrentEnabled() + " \n");
                out.write("ServerSource " + mds.isServerSourceEnabled() + " Speed " + mds.isSpeedEnabled() + " Presummarized " + mds.isPresummarized() + " StreamExtractSize " + mds.getStreamExtractSize() + " \n");
                out.write("\n");
                System.out.println("Adding columns");
                for (Integer ac : mds.getAssociatedColumns()) {
                    MdlColumn mc = this.mdlHolder.getColumnByColumnObjectId(ac);
                    out.write("OrgName " + mc.getColumnObjectId() + " \"" + mc.getColumnID() + "\" Origin " + mc.getOrigin() + " \n");
                    out.write("Offset " + mc.getOffset() + " Column \"" + mc.getColumnName() + "\" Storage " + mc.getStorage() + " Scale " + mc.getScale() + " Size " + mc.getSize() + " Decimals " + mc.getDecimals() + " \n");
                    out.write("Class " + mc.getColumnClass() + " ");
                    out.write("InputScale " + mc.getInputScale() + " TimeArray " + mc.getTimeArray() + " ");
                    out.write("Rollup " + mc.getRollup() + " ");
                    out.write("ColSrcType " + mc.getColSrcType() + " \n");
                    out.write("\n");
                }
            }
            out.write("\n");
            System.out.println("Adding dimensions");
            for (MdlDimension mdim : this.dimStack) {
                out.write("Dimension " + mdim.getDimensionObjectId() + " \"" + mdim.getDimensionName() + "\" DimType " + mdim.getDimensionType() + " NewCatsLock " + mdim.isNewCategoryLock() + " ExcludeAutoPartitioning " + mdim.isExcludeAutoPartitioning() + " \n");
                out.write("DimDefaultCategory " + mdim.getDimDefaultCategory() + " \n\n");
                out.write("Categories \n");
                out.write("Root " + mdim.getRoot().getRootObjectId() + " \"" + mdim.getRoot().getRootName() + "\" Inclusion " + mdim.getRoot().getInclusion() + " Lastuse " + mdim.getRoot().getLastUse() + " Filtered " + mdim.getRoot().isFiltered() + " \n");
                out.write("Suppressed " + mdim.getRoot().isSuppressed() + " Sign " + mdim.getRoot().isSign() + " HideValue " + mdim.getRoot().isHideValue() + " IsKeyOrphanage " + mdim.getRoot().isKeyOrphanage() + " IsTruncated " + mdim.getRoot().isTruncated() + " \n");
                out.write("Blanks " + mdim.getRoot().isBlanks() + " \n");
                System.out.println("Adding Drills to dimension");
                for (MdlDrill mdr : mdim.getDrillStack()) {
                    out.write("Drill " + mdr.getDrillObjectId() + " \"" + mdr.getDrillName() + "\" Inclusion " + mdr.getInclusion() + " Filtered " + mdr.isFiltered() + " Suppressed " + mdr.isSuppressed() + " \n");
                    out.write("PrimaryDrill " + mdr.isPrimaryDrill() + " HideValue " + mdr.isHidingValue() + " \n");
                    System.out.println("Adding levels to drill");
                    for (MdlLevel ml : mdr.getLevelStack()) {
                        out.write("Levels " + ml.getLevelObjectId() + " \"" + ml.getLevelName() + "\" Blanks \"" + ml.getBlanks() + "\" DateFunction " + ml.getDateFunction() + " Generate " + ml.getGenerate() + " \n");
                        out.write("RefreshLabel " + ml.isRefreshLabel() + " RefreshDescription " + ml.isRefreshDescription() + " RefreshShortName " + ml.isRefreshShortName() + " NewCatsLock " + ml.isNewCategoryLock() + " \n");
                        out.write("Timerank " + ml.getTimeRank() + " UniqueCategories " + ml.isUniqueCategories() + " UniqueMove " + ml.isUniqueMove() + " Associations " + ml.getAssociationsObjectId() + " \"" + ml.getAssociationName() + "\" \n");
                        out.write("AssociationType " + ml.getAssociationType() + " AssociationRole " + ml.getAssociationRole() + " AssociationReferenced \"" + ml.getAssociationReferenced() + "\" \n");
                        out.write("\n\n\n");
                    }
                }
                System.out.println("Adding map drills");
                out.write("\n");
                out.write("MapDrills \n");
                for (MdlDrill mdr : mdim.getDrillStack()) {
                    out.write("MapDrill " + mdr.getDrillObjectId() + " \n");
                }
                System.out.println("Adding views");
                out.write("\n");
                for (MdlView mv : mdim.getViewStack()) {
                    out.write("ViewName " + mv.getViewObjectId() + " \"" + mv.getViewName() + "\" Type " + mv.getViewType() + " ViewCustomView " + mv.getViewCustomView() + " \n");
                }
            }
            System.out.println("Adding measures");
            for (MdlMeasure mm : this.measureStack) {
                out.write("Measure " + mm.getMeasureObjectId() + " \"" + mm.getMeasureName() + "\" Rollup " + mm.getRollup() + " IgnoreMissingValue " + mm.isIgnoreMissingValue() + " Storage " + mm.getStorageType() + " \n");
                out.write("OutPutScale " + mm.getOutputScale() + " Decimals " + mm.getDecimals() + " ReverseSign " + mm.isReverseSign() + " IsCurrency " + mm.isReverseSign() + " IsFolder " + mm.isFolder() + " \n");
                out.write("DrillThrough " + mm.isDrillThrough() + " EndList Associations " + mm.getEndListAssociationsID() + " \"" + mm.getEndListAssociations() + "\" AssociationType " + mm.getAssociationType() + " \n");
                out.write("AssociationRole " + mm.getAssociationRole() + " AssociationReferenced \"" + mm.getAssociationReferenced() + "\" \n");
                out.write("\n\n");
            }
            System.out.println("Adding powercubes");
            for (MdlPowerCube mpc : this.mdlHolder.getPowerCubeStack()) {
                out.write("\n\n");
                out.write("Cube " + mpc.getPowerCubeObjectId() + " \"" + mpc.getPowerCubeName() + "\" EncryptedPW \"" + mpc.getEncryptedPW() + "\" Status " + mpc.getStatus() + " CubeCreation " + mpc.getCubeCreation() + " Optimize " + mpc.getOptimize() + " \n");
                out.write("ConsolidatedRecords " + mpc.getConsolidatedRecords() + " PartitionSize " + mpc.getPartitionSize() + " PassesNumber " + mpc.getPassesNumber() + " Compress " + mpc.isCompress() + " \n");
                out.write("IncrementalUpdate " + mpc.isIncrementalUpdate() + " ServerCube " + mpc.isServerCube() + " CubeStamp " + mpc.getCubeStamp() + " CubeCycle " + mpc.getCubeCycle() + " BlockParentTotals " + mpc.isBlockParentTotals() + " \n");
                out.write("Caching " + mpc.isCaching() + " UseAlternateFileName " + mpc.isUseAlternateFileName() + " DeployType " + mpc.getDeployType() + " \n");
                out.write("DeployLocations " + mpc.getDeployLocationsString() + " EndList CognosConnectionDataSourceName " + mpc.getCognosConnectionDataSourceName() + " \n");
                out.write("DeployCleanupEnabled " + mpc.isDeployCleanupEnabled() + " DeployCleanupNumberOfCubes " + mpc.getDeployCleanupNumberOfCubes() + " DrillThrough " + mpc.isDrillThrough() + " " + mpc.getDrillThroughLocations() + " EndList \n");
                out.write("DataSourceSignon " + mpc.isDataSourceSignon() + " PackageName \"" + mpc.getPackageName() + "\" PublishEnable " + mpc.isPublishEnable() + " PublishStatus " + mpc.getPublishStatus() + " PublishAllowNullSuppression " + mpc.isPublishAllowNullSuppression() + " \n");
                out.write("PublishAllowMultiEdgeSuppression " + mpc.isPublishAllowMultiEdgeSuppression() + " PublishAllowAccessToSuppressionOptions " + mpc.isPublishAllowAccessToSuppressionOptions() + " \n");
                out.write("MDCFile \"" + mpc.getMDCFile() + "\" \n");
            }
            out.write("\n");
            System.out.println("Adding dimension views");
            for (MdlDimension md : this.dimStack) {
                out.write("DimensionView " + md.getDimensionObjectId() + " \"All Categories\" \n");
            }
            out.write("\n");
            System.out.println("Adding measure includes");
            for (MdlMeasure mm : this.measureStack) {
                out.write("MeasureInclude " + mm.getMeasureObjectId() + " Yes \n");
            }
            out.write("\n");
            out.write("\n\n");
            System.out.println("Adding measure allocations");
            for (MdlMeasure mm : this.measureStack) {
                out.write("AllocationAdd Measure " + mm.getMeasureObjectId() + " Type Default \n");
            }
            out.write("\n\n");
            out.close();
            return true;
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            return false;
        }
    }
}

