/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDimension;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlGenerator;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlMeasure;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlPowerCube;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlTransformerModel;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.StreamProcessor;
import com.ibm.cognos.fmeng.fmmd.model.FmDatatype;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdlHolder {
    private ArrayList<MdlDataSource> dataSourceStack;
    private ArrayList<MdlDimension> dimensionStack;
    private ArrayList<MdlMeasure> measureStack;
    private ArrayList<MdlColumn> columnStack;
    private ArrayList<MdlPowerCube> powerCubeStack;
    private MdlGenerator mdlGen = new MdlGenerator();
    private MdlTransformerModel transformerModel;
    private boolean isModelSet = false;
    private String lastUsedMdlFileNameAndPath = null;
    private String lastUsedMdlFileName = null;
    private String lastUsedMdlFilePath = null;

    public MdlHolder() {
        this.dimensionStack = new ArrayList();
        this.dataSourceStack = new ArrayList();
        this.measureStack = new ArrayList();
        this.columnStack = new ArrayList();
        this.powerCubeStack = new ArrayList();
    }

    public MdlColumn addColumn(MdlDataSource ds, String newColName, String newColId, String newOrigin, FmDatatype newStorageType, int newScale, Long newSize, int newDecimals, String newClass, int newInputScale, String isTimeArrayOn, String newRollup, String newColSrcType) throws FmMDException {
        for (MdlColumn mc : this.columnStack) {
            if (!mc.getColumnID().equals(newColId)) continue;
            throw new FmMDException("BMT_MD_DUPLICATE_COLUMN_IN_MDL", newColName, ds.getDataSource());
        }
        this.columnStack.add(new MdlColumn(ds, newColName, newColId, newOrigin, newStorageType, newScale, newSize, newDecimals, newClass, newInputScale, isTimeArrayOn, newRollup, newColSrcType));
        return this.columnStack.get(this.columnStack.size() - 1);
    }

    public MdlDataSource addDataSource(String newSourcePath, String newContentStoreDataSourceConnection, boolean autoSummaryEnabled) {
        for (MdlDataSource mds : this.dataSourceStack) {
            if (!mds.getSourcePath().equals(newSourcePath)) continue;
            throw new FmMDException("BMT_MD_DUPLICATE_DATA_SOURCE_PATH_IN_MDL", newSourcePath);
        }
        this.dataSourceStack.add(new MdlDataSource(newSourcePath, newContentStoreDataSourceConnection, autoSummaryEnabled));
        return this.dataSourceStack.get(this.dataSourceStack.size() - 1);
    }

    public MdlDimension addDimension(String newDimensionName) {
        this.dimensionStack.add(new MdlDimension(newDimensionName, this));
        return this.dimensionStack.get(this.dimensionStack.size() - 1);
    }

    public MdlMeasure addMeasure(MdlColumn referenceColumn) {
        for (MdlColumn mc : this.columnStack) {
            if (!mc.equals(referenceColumn)) continue;
            this.measureStack.add(new MdlMeasure(mc, this.getDataSourceByObjectId(mc.getDataSourceObjectId())));
            return this.measureStack.get(this.measureStack.size() - 1);
        }
        throw new FmMDException("BMT_MD_MDL_MEASURE_ADDITION_COLUMN_NOT_PART_OF_MODEL", referenceColumn.getColumnName());
    }

    public MdlPowerCube addPowerCube(String newPowerCubeName, String newPowerCubePhysicalPath) {
        for (MdlPowerCube mpc : this.powerCubeStack) {
            if (!mpc.getPowerCubeName().equals(newPowerCubeName)) continue;
            throw new FmMDException("BMT_MD_DUPLICATE_POWERCUBE_IN_MDL", newPowerCubeName);
        }
        this.powerCubeStack.add(new MdlPowerCube(newPowerCubeName, newPowerCubePhysicalPath));
        return this.powerCubeStack.get(this.powerCubeStack.size() - 1);
    }

    public boolean checkExistingColumn(MdlColumn columnToCheck) {
        for (MdlColumn mc : this.columnStack) {
            if (!mc.equals(columnToCheck)) continue;
            return true;
        }
        return false;
    }

    public boolean generateMDLFile(String newFileName) throws IOException {
        try {
            this.mdlGen.generateMDLFile(newFileName, this);
            return true;
        }
        catch (FmMDException fmMDException) {
            throw new FmMDException("BMT_MD_MDL_FILE_NOT_GENERATED_FILENAME_FROM_PROGRAM", newFileName);
        }
    }

    public boolean generatePowerCube(MdlPowerCube mpc) {
        int publishCubeSuccess;
        int generateCubeSuccess;
        block13: {
            generateCubeSuccess = 0;
            publishCubeSuccess = 0;
            try {
                for (File f : mpc.getDeployLocations()) {
                    if (f.exists() && MdlGenerator.m_dump) {
                        System.out.println("Powercube deployment directory " + f.toString() + " exists.");
                        continue;
                    }
                    if (MdlGenerator.m_dump) {
                        System.out.println("Powercube deployment directory " + f.toString() + " does not exist.");
                    }
                    if (f.mkdirs()) {
                        if (!MdlGenerator.m_dump) continue;
                        System.out.println("Creating powercube deployment directory: \t\"" + f.toString() + "\"");
                        System.out.println("Powercube deployment directory created: \t\"" + f.toString() + "\"");
                        continue;
                    }
                    throw new FmMDException("BMT_MD_MDL_FILE_DIRECTORY_NOT_CREATED", f.toString());
                }
                System.out.println("Generating powercube...");
                String generateCubeCommand = "cogtr -n2 -c -s -m\"" + this.lastUsedMdlFileNameAndPath + "\"";
                System.out.println("------------------------------------------------------------------");
                System.out.println("Running command: " + generateCubeCommand);
                Process generateCube = Runtime.getRuntime().exec(generateCubeCommand);
                StreamProcessor cubeGenerationExecErrorStreamThread = new StreamProcessor(generateCube.getErrorStream(), "ERROR");
                StreamProcessor cubeGenerationExecOutputStreamThread = new StreamProcessor(generateCube.getInputStream(), "OUTPUT");
                cubeGenerationExecErrorStreamThread.start();
                cubeGenerationExecOutputStreamThread.start();
                generateCubeSuccess = generateCube.waitFor();
                System.out.println("Process exit value: " + generateCubeSuccess);
                System.out.println("------------------------------------------------------------------");
                if (generateCubeSuccess != 0) {
                    System.out.println("Errors occured during the generation of the powercube. " + mpc.getPowerCubeName() + " was NOT been successfully generated. (Check the corresponding Transformer log file)");
                    throw new FmMDException("BMT_MD_POWERCUBE_NOT_GENERATED", mpc.getPowerCubeName());
                }
                System.out.println("Powercube " + mpc.getPowerCubeName() + " has been successfully generated.");
                if (generateCubeSuccess == 0) {
                    System.out.println("Publishing powercube...");
                    String publishCubeCommand = "cogtr -n2 -ju " + mpc.getPowerCubeName() + " -m\"" + this.lastUsedMdlFileNameAndPath + "\"";
                    System.out.println("------------------------------------------------------------------");
                    System.out.println("Running command: \t" + publishCubeCommand);
                    Process publishCube = Runtime.getRuntime().exec(publishCubeCommand);
                    StreamProcessor cubePublishingExecErrorStreamThread = new StreamProcessor(publishCube.getErrorStream(), "ERROR");
                    StreamProcessor cubePublishingExecOutputStreamThread = new StreamProcessor(publishCube.getInputStream(), "OUTPUT");
                    cubePublishingExecErrorStreamThread.start();
                    cubePublishingExecOutputStreamThread.start();
                    publishCubeSuccess = publishCube.waitFor();
                    System.out.println("Process exit value: " + publishCubeSuccess);
                    System.out.println("------------------------------------------------------------------");
                    if (publishCubeSuccess != 0) {
                        System.out.println("Errors occured during the publishing of the powercube. " + mpc.getPowerCubeName() + " was NOT successfully published. (Check the corresponding Transformer log file)");
                        throw new FmMDException("BMT_MD_POWERCUBE_NOT_PUBLISHED", mpc.getPowerCubeName());
                    }
                } else {
                    System.out.println("Powercube publishing aborted. Powercube " + mpc.getPowerCubeName() + " was not generated for publishing.");
                    throw new FmMDException("BMT_MD_POWERCUBE_NOT_PUBLISHED_ABORTED", mpc.getPowerCubeName());
                }
                System.out.println("Powercube " + mpc.getPowerCubeName() + " has been successfully published.");
                System.out.println("Checking if MDC file was generated in Effective Cube Path: " + mpc.getEffectiveCubePath());
                if (!new File(mpc.getMDCFile()).exists()) {
                    System.out.println("MDC File " + mpc.getMDCFile() + "was NOT successfully generated in the effective path " + mpc.getEffectiveCubePath());
                    throw new FmMDException("BMT_MD_MDC_POWERCUBE_FILE_NOT_GENERATED", mpc.getPowerCubeName(), mpc.getEffectiveCubePath());
                }
                System.out.println("MDC File has successfully generated");
                if (generateCubeSuccess != 0 || publishCubeSuccess != 0) break block13;
                System.out.println("Powercube " + mpc.getPowerCubeName() + " has been successfully generated and published.");
                return true;
            }
            catch (Exception exception) {
                throw new FmMDException("BMT_MD_POWERCUBE_NOT_GENERATED_OR_PUBLISHED", mpc.getPowerCubeName());
            }
        }
        if (generateCubeSuccess != 0 && publishCubeSuccess != 0) {
            System.out.println("Powercube " + mpc.getPowerCubeName() + " was NOT successfully generated and published.");
            throw new FmMDException("BMT_MD_POWERCUBE_NOT_GENERATED_OR_PUBLISHED", mpc.getPowerCubeName());
        }
        return false;
    }

    public MdlColumn getColumn(String nameOfColumnToGet) {
        for (MdlColumn mc : this.columnStack) {
            if (!mc.getColumnName().equals(nameOfColumnToGet)) continue;
            return mc;
        }
        if (MdlGenerator.m_dump) {
            System.out.println("Specified new column name \"" + nameOfColumnToGet + "\" does not exist. Please specify an existing unique column name.");
        }
        return null;
    }

    public MdlColumn getColumnByColumnId(String columnIdToSearch) {
        for (MdlColumn mc : this.columnStack) {
            if (!mc.getColumnID().equals(columnIdToSearch)) continue;
            return mc;
        }
        return null;
    }

    public MdlColumn getColumnByColumnObjectId(int columnObjectId) {
        for (MdlColumn mc : this.columnStack) {
            if (mc.getColumnObjectId() != columnObjectId) continue;
            return mc;
        }
        return null;
    }

    public ArrayList<MdlColumn> getColumnStack() {
        return this.columnStack;
    }

    public MdlDataSource getDataSource(int index) {
        return this.dataSourceStack.get(index);
    }

    public MdlDataSource getDataSource(String dataSourcePath) {
        for (MdlDataSource mds : this.dataSourceStack) {
            if (!mds.getSourcePath().equals(dataSourcePath)) continue;
            return mds;
        }
        if (MdlGenerator.m_dump) {
            System.out.println("Specified new data source path \"" + dataSourcePath + "\" does not exist. Please specify an existing data source path name.");
        }
        return null;
    }

    public MdlDataSource getDataSourceByObjectId(int ObjectIdOfDataSourceToGet) {
        for (MdlDataSource mds : this.dataSourceStack) {
            if (mds.getDataSourceObjectId() != ObjectIdOfDataSourceToGet) continue;
            return mds;
        }
        if (MdlGenerator.m_dump) {
            System.out.println("Specified data source object id " + ObjectIdOfDataSourceToGet + " is not linked to any data source. Please specify an existing data source object id.");
        }
        return null;
    }

    public ArrayList<MdlDataSource> getDataSourceStack() {
        return this.dataSourceStack;
    }

    public MdlDimension getDimension(int dimensionToGet) {
        return this.dimensionStack.get(dimensionToGet);
    }

    public ArrayList<MdlDimension> getDimensionStack() {
        return this.dimensionStack;
    }

    public String getLastUsedMdlFileName() {
        return this.lastUsedMdlFileName;
    }

    public String getLastUsedMdlFileNameAndPath() {
        return this.lastUsedMdlFileNameAndPath;
    }

    public String getLastUsedMdlFilePath() {
        return this.lastUsedMdlFilePath;
    }

    public MdlGenerator getMdlGen() {
        return this.mdlGen;
    }

    public MdlGenerator getMdlGenerator() {
        return this.mdlGen;
    }

    public ArrayList<MdlMeasure> getMeasureStack() {
        return this.measureStack;
    }

    public ArrayList<MdlPowerCube> getPowerCubeStack() {
        return this.powerCubeStack;
    }

    public MdlTransformerModel getTransformerModel() {
        return this.transformerModel;
    }

    public String getTransformerModelName() {
        return this.transformerModel.getModelName();
    }

    public int getTransformerModelObjectId() {
        return this.transformerModel.getTransformerModelObjectId();
    }

    public boolean hasColumns() {
        return !this.columnStack.isEmpty();
    }

    public boolean hasDimensions() {
        return !this.dimensionStack.isEmpty();
    }

    public boolean isModelSet() {
        return this.isModelSet;
    }

    public void setLastUsedMdlFileName(String newMdlFileName) {
        this.lastUsedMdlFileName = String.valueOf(newMdlFileName) + ".mdl";
    }

    public void setLastUsedMdlFileNameAndPath(String newMdlFileNameAndPath) {
        this.lastUsedMdlFileNameAndPath = String.valueOf(newMdlFileNameAndPath) + ".mdl";
    }

    public void setLastUsedMdlFilePath(String newLastUsedMdlFilePath) {
        this.lastUsedMdlFilePath = newLastUsedMdlFilePath;
    }

    public MdlTransformerModel setModel(String newModelName, String newModelVersion, boolean newAutoAccess, String newModelCategoryOrderDefault, boolean newModelOrderedByDefault, String newModelCodePage) {
        if (!this.isModelSet) {
            this.transformerModel = new MdlTransformerModel(newModelName, newModelVersion, newAutoAccess, newModelCategoryOrderDefault, newModelOrderedByDefault, newModelCodePage);
            return this.transformerModel;
        }
        throw new FmMDException("BMT_MD_DUPLICATE_TRANSFORMER_MODEL_IN_MDL", newModelName);
    }
}

