/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlHolder;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.utility.FmMDException;

public class MdlLevel
extends MdlObjectIdTracker {
    private String levelName = null;
    private int levelObjectId = 0;
    private String blanks = null;
    private String dateFunction = null;
    private String generate = null;
    private boolean refreshLabel = false;
    private boolean refreshDescription = false;
    private boolean refreshShortName = false;
    private boolean newCategoryLock = false;
    private int timeRank = 0;
    private boolean uniqueCategories = false;
    private boolean uniqueMove = false;
    private int associationsObjectId = 0;
    private String associationName = null;
    private String associationType = null;
    private String associationRole = null;
    private String associationReferenced = null;
    private MdlHolder referenceMdlHolder;
    private boolean addedWithName = false;
    private String[] allowedGenerateDate = new String[]{"Default", "All", "Need"};
    private String[] allowedDateFunctions = new String[]{"None", "Year", "LunarYear", "Quarter", "LunarQuarter", "Month", "LunarMonth", "LunarMonth445", "LunarMonth454", "LunarMonth544", "Week", "Day"};
    private String[] allowedAssociationRoles = new String[]{"Role_Catcode", "Role_Description", "Role_Drillthrough", "Role_Label", "Role_Orderby", "Role_Source", "Role_Tag"};
    private String[] allowedAssociationTypes = new String[]{"Type_PowerCube", "Type_Query"};

    public MdlLevel(MdlHolder mdlHolder) {
        this.referenceMdlHolder = mdlHolder;
        this.levelName = "";
        this.levelObjectId = MdlLevel.getAndIncreaseNextAvailableObjectId();
        this.blanks = "( Blank )";
        this.dateFunction = "None";
        this.generate = "None";
        this.refreshLabel = false;
        this.refreshDescription = false;
        this.refreshShortName = false;
        this.newCategoryLock = false;
        this.timeRank = 0;
        this.uniqueCategories = false;
        this.uniqueMove = false;
        this.addedWithName = false;
        this.associationsObjectId = MdlLevel.getAndIncreaseNextAvailableObjectId();
    }

    public MdlLevel(String newLevelName, MdlHolder mdlHolder) {
        this.referenceMdlHolder = mdlHolder;
        this.levelName = newLevelName;
        this.levelObjectId = MdlLevel.getAndIncreaseNextAvailableObjectId();
        this.blanks = "( Blank )";
        this.dateFunction = "None";
        this.generate = "None";
        this.refreshLabel = false;
        this.refreshDescription = false;
        this.refreshShortName = false;
        this.newCategoryLock = false;
        this.timeRank = 0;
        this.uniqueCategories = false;
        this.uniqueMove = false;
        this.addedWithName = true;
        this.associationsObjectId = MdlLevel.getAndIncreaseNextAvailableObjectId();
    }

    public String getAssociationName() {
        return this.associationName;
    }

    public String getAssociationReferenced() {
        return this.associationReferenced;
    }

    public String getAssociationRole() {
        return this.associationRole;
    }

    public int getAssociationsObjectId() {
        return this.associationsObjectId;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public String getBlanks() {
        return this.blanks;
    }

    public String getDateFunction() {
        return this.dateFunction;
    }

    public String getGenerate() {
        return this.generate;
    }

    public String getLevelName() {
        return this.levelName;
    }

    public int getLevelObjectId() {
        return this.levelObjectId;
    }

    public MdlHolder getReferenceMdlHolder() {
        return this.referenceMdlHolder;
    }

    public int getTimeRank() {
        return this.timeRank;
    }

    public boolean isNewCategoryLock() {
        return this.newCategoryLock;
    }

    public boolean isRefreshDescription() {
        return this.refreshDescription;
    }

    public boolean isRefreshLabel() {
        return this.refreshLabel;
    }

    public boolean isRefreshShortName() {
        return this.refreshShortName;
    }

    public boolean isUniqueCategories() {
        return this.uniqueCategories;
    }

    public boolean isUniqueMove() {
        return this.uniqueMove;
    }

    public void setAssociationName(String associationName) {
        this.associationName = associationName;
    }

    public void setAssociationReferenced(String associationReferenced) {
        this.associationReferenced = associationReferenced;
    }

    public void setAssociationRole(String associationRole) {
        boolean associationRoleFound = false;
        String[] stringArray = this.allowedAssociationRoles;
        int n = this.allowedAssociationRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(associationRole.toLowerCase())) {
                this.associationRole = associationRole;
                associationRoleFound = true;
                break;
            }
            ++n2;
        }
        if (!associationRoleFound) {
            throw new FmMDException("BMT_MD_INVALID_ASSOCIATION_ROLE_OPTION_IN_MDL_LEVEL", associationRole);
        }
    }

    public void setAssociationType(String associationType) {
        boolean associationTypeFound = false;
        String[] stringArray = this.allowedAssociationTypes;
        int n = this.allowedAssociationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(associationType.toLowerCase())) {
                this.associationType = associationType;
                associationTypeFound = true;
                break;
            }
            ++n2;
        }
        if (!associationTypeFound) {
            throw new FmMDException("BMT_MD_INVALID_ASSOCIATION_TYPE_OPTION_IN_MDL_LEVEL", associationType);
        }
    }

    public void setBlanks(String blanks) {
        this.blanks = blanks;
    }

    public void setColumn(MdlColumn referenceColumn, String newAssociationRole, String newAssociationType) {
        if (this.referenceMdlHolder.checkExistingColumn(referenceColumn)) {
            this.associationName = referenceColumn.getColumnName();
            this.setAssociationRole(newAssociationRole);
            this.setAssociationType(newAssociationType);
            this.associationReferenced = referenceColumn.getColumnName();
            if (!this.addedWithName) {
                this.levelName = referenceColumn.getColumnName();
            }
        }
    }

    public void setDateFunction(String dateFunction) {
        boolean dateFunctionFound = false;
        String[] stringArray = this.allowedDateFunctions;
        int n = this.allowedDateFunctions.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(dateFunction.toLowerCase())) {
                this.dateFunction = dateFunction;
                dateFunctionFound = true;
                break;
            }
            ++n2;
        }
        if (!dateFunctionFound) {
            throw new FmMDException("BMT_MD_INVALID_DATE_OPTION_IN_MDL_LEVEL", dateFunction);
        }
    }

    public void setGenerate(String generate) {
        boolean generateDateFound = false;
        String[] stringArray = this.allowedGenerateDate;
        int n = this.allowedGenerateDate.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(generate.toLowerCase())) {
                this.generate = generate;
                generateDateFound = true;
                break;
            }
            ++n2;
        }
        if (!generateDateFound) {
            throw new FmMDException("BMT_MD_INVALID_GENERATE_DATE_OPTION_IN_MDL_LEVEL", generate);
        }
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public void setNewCategoryLock(boolean newCategoryLock) {
        this.newCategoryLock = newCategoryLock;
    }

    public void setReferenceMdlHolder(MdlHolder referenceMdlHolder) {
        this.referenceMdlHolder = referenceMdlHolder;
    }

    public void setRefreshDescription(boolean refreshDescription) {
        this.refreshDescription = refreshDescription;
    }

    public void setRefreshLabel(boolean refreshLabel) {
        this.refreshLabel = refreshLabel;
    }

    public void setRefreshShortName(boolean refreshShortName) {
        this.refreshShortName = refreshShortName;
    }

    public void setTimeRank(int timeRank) {
        this.timeRank = timeRank;
    }

    public void setUniqueCategories(boolean uniqueCategories) {
        this.uniqueCategories = uniqueCategories;
    }

    public void setUniqueMove(boolean uniqueMove) {
        this.uniqueMove = uniqueMove;
    }
}

