/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlDataSource;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.utility.FmMDException;

public class MdlMeasure
extends MdlObjectIdTracker {
    private int measureObjectId = 0;
    private String measureName = null;
    private String rollup = null;
    private boolean ignoreMissingValue = false;
    private String storageType = null;
    private int outputScale = 0;
    private int decimals = 0;
    private boolean reverseSign = false;
    private boolean isCurrency = false;
    private boolean isFolder = false;
    private boolean drillThrough = false;
    private int endListAssociationsID = 0;
    private String endListAssociations = null;
    private String associationType = null;
    private String associationRole = null;
    private String associationReferenced = null;
    private String[] allowedAssociationRoles = new String[]{"Role_Catcode", "Role_Description", "Role_Drillthrough", "Role_Label", "Role_Orderby", "Role_Source", "Role_Tag"};
    private String[] allowedAssociationTypes = new String[]{"Type_PowerCube", "Type_Query"};

    public MdlMeasure(MdlColumn referenceColumn, MdlDataSource referenceDataSource) {
        this.measureObjectId = MdlMeasure.getAndIncreaseNextAvailableObjectId();
        this.measureName = referenceColumn.getColumnName();
        this.rollup = referenceColumn.getRollup();
        this.ignoreMissingValue = false;
        this.storageType = referenceColumn.getStorage();
        this.outputScale = 0;
        this.decimals = referenceColumn.getDecimals();
        this.reverseSign = false;
        this.isCurrency = false;
        this.isFolder = false;
        this.drillThrough = false;
        this.endListAssociationsID = MdlMeasure.getAndIncreaseNextAvailableObjectId();
        this.endListAssociations = referenceColumn.getColumnName();
        this.associationType = "Type_Query";
        this.associationRole = "Role_Source";
        this.associationReferenced = referenceColumn.getColumnName();
        referenceDataSource.associateMeasureToDataSource(this.measureObjectId);
    }

    public String getAssociationReferenced() {
        return this.associationReferenced;
    }

    public String getAssociationRole() {
        return this.associationRole;
    }

    public String getAssociationType() {
        return this.associationType;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public String getEndListAssociations() {
        return this.endListAssociations;
    }

    public int getEndListAssociationsID() {
        return this.endListAssociationsID;
    }

    public String getMeasureName() {
        return this.measureName;
    }

    public int getMeasureObjectId() {
        return this.measureObjectId;
    }

    public int getOutputScale() {
        return this.outputScale;
    }

    public String getRollup() {
        return this.rollup;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public boolean isCurrency() {
        return this.isCurrency;
    }

    public boolean isDrillThrough() {
        return this.drillThrough;
    }

    public boolean isFolder() {
        return this.isFolder;
    }

    public boolean isIgnoreMissingValue() {
        return this.ignoreMissingValue;
    }

    public boolean isReverseSign() {
        return this.reverseSign;
    }

    public void setAssociationReferenced(String associationReferenced) {
        this.associationReferenced = associationReferenced;
    }

    public void setAssociationRole(String associationRole) {
        boolean associationRoleFound = false;
        String[] stringArray = this.allowedAssociationRoles;
        int n = this.allowedAssociationRoles.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(associationRole.toLowerCase())) {
                this.associationRole = associationRole;
                associationRoleFound = true;
                break;
            }
            ++n2;
        }
        if (!associationRoleFound) {
            throw new FmMDException("BMT_MD_INVALID_ASSOCIATION_ROLE_OPTION_IN_MDL_MEASURE", associationRole);
        }
    }

    public void setAssociationType(String associationType) {
        boolean associationTypeFound = false;
        String[] stringArray = this.allowedAssociationTypes;
        int n = this.allowedAssociationTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(associationType.toLowerCase())) {
                this.associationType = associationType;
                associationTypeFound = true;
                break;
            }
            ++n2;
        }
        if (!associationTypeFound) {
            throw new FmMDException("BMT_MD_INVALID_ASSOCIATION_TYPE_OPTION_IN_MDL_MEASURE", associationType);
        }
    }

    public void setCurrency(boolean isCurrency) {
        this.isCurrency = isCurrency;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public void setDrillThrough(boolean drillThrough) {
        this.drillThrough = drillThrough;
    }

    public void setEndListAssociations(String endListAssociations) {
        this.endListAssociations = endListAssociations;
    }

    public void setEndListAssociationsID(int endListAssociationsID) {
        this.endListAssociationsID = endListAssociationsID;
    }

    public void setFolder(boolean isFolder) {
        this.isFolder = isFolder;
    }

    public void setIgnoreMissingValue(boolean ignoreMissingValue) {
        this.ignoreMissingValue = ignoreMissingValue;
    }

    public void setMeasureName(String measureName) {
        this.measureName = measureName;
    }

    public void setOutputScale(int outputScale) {
        this.outputScale = outputScale;
    }

    public void setReverseSign(boolean reverseSign) {
        this.reverseSign = reverseSign;
    }

    public void setRollup(String rollup) {
        this.rollup = rollup;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public String toString() {
        String MdlMeasureToString = "";
        MdlMeasureToString = String.valueOf(MdlMeasureToString) + "Measure Name: " + this.measureName + " MeasureObjectId: " + this.measureObjectId + " Rollup: " + this.rollup + " IgnoreMissingValue: " + this.ignoreMissingValue + " Storage: " + this.storageType + " OutputScale: " + this.outputScale + " Decimals: " + this.decimals + " ReverseSign: " + this.reverseSign + " isCurrency: " + this.isCurrency + " isFolder: " + this.isFolder + " DrillThrough: " + this.drillThrough + " EndListAssociationsId: " + this.endListAssociationsID + " EndListAssociations: " + this.endListAssociations + " AssociationsType: " + this.associationType + " AssociationsRole: " + this.associationRole + " AssociationReferenced: " + this.associationReferenced + "\n";
        return MdlMeasureToString;
    }
}

