/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MdlPowerCube
extends MdlObjectIdTracker {
    private int powerCubeObjectId = 0;
    private String powerCubeName = null;
    private String effectiveCubePath = null;
    private String encryptedPW = null;
    private String status = null;
    private String cubeCreation = null;
    private String optimize = null;
    private int consolidatedRecords = 0;
    private int partitionSize = 0;
    private int passesNumber = 0;
    private boolean compress = false;
    private boolean incrementalUpdate = false;
    private boolean serverCube = false;
    private int cubeStamp = 0;
    private int cubeCycle = 0;
    private boolean blockParentTotals = false;
    private boolean caching = false;
    private boolean useAlternateFileName = false;
    private String deployType = null;
    private ArrayList<File> deployLocations = null;
    private boolean drillThrough = false;
    private String drillThroughLocations = null;
    private String cognosConnectionDataSourceName = null;
    private boolean dataSourceSignon = false;
    private String packageName = null;
    private boolean publishEnable = false;
    private String publishStatus = null;
    private boolean publishAllowNullSuppression = false;
    private boolean publishAllowMultiEdgeSuppression = false;
    private boolean publishAllowAccessToSuppressionOptions = false;
    private String cubeFileName = null;
    private String MDCFile = null;
    private boolean deployCleanupEnabled = false;
    private int deployCleanupNumberOfCubes = 0;
    private String[] allowedStatus = new String[]{"New", "OK", "Inactive", "Warnings", "Invalid", "Failed", "Busy", "Missing"};
    private String[] allowedCubeCreation = new String[]{"Default", "Implicit", "On", "Off"};
    private String[] allowedOptimize = new String[]{"Default, Categories, Datapasses, DirectCreate, PriorMarking, or AutoPartition"};
    private String[] allowedDeployTypes = new String[]{"DeployNone", "DeploySwapTogether", "DeploySwapSingle", "DeployToAllLocationsAutomatic"};

    public MdlPowerCube(String newPowerCubeName, String newCubePath) {
        this.powerCubeObjectId = MdlPowerCube.getAndIncreaseNextAvailableObjectId();
        this.powerCubeName = newPowerCubeName;
        this.effectiveCubePath = newCubePath;
        this.encryptedPW = "";
        this.status = "New";
        this.cubeCreation = "On";
        this.optimize = "Default";
        this.consolidatedRecords = 10000000;
        this.partitionSize = 500000;
        this.passesNumber = 5;
        this.compress = false;
        this.incrementalUpdate = false;
        this.serverCube = false;
        this.cubeStamp = 0;
        this.cubeCycle = 0;
        this.blockParentTotals = false;
        this.caching = false;
        this.useAlternateFileName = false;
        this.deployType = "DeployToAllLocationsAutomatic";
        this.deployLocations = new ArrayList();
        this.deployLocations.add(new File(String.valueOf(this.effectiveCubePath) + "cubeVersionControl"));
        this.drillThrough = false;
        this.drillThroughLocations = "";
        this.cognosConnectionDataSourceName = "\"" + this.powerCubeName + "\"";
        this.dataSourceSignon = false;
        this.packageName = this.powerCubeName;
        this.publishEnable = true;
        this.publishStatus = "None";
        this.publishAllowNullSuppression = true;
        this.publishAllowMultiEdgeSuppression = true;
        this.publishAllowAccessToSuppressionOptions = true;
        this.cubeFileName = String.valueOf(this.powerCubeName) + ".mdc";
        this.setMDCFile(String.valueOf(this.effectiveCubePath) + this.cubeFileName);
        this.deployCleanupEnabled = true;
        this.deployCleanupNumberOfCubes = 1;
    }

    public String[] getAllowedCubeCreation() {
        return this.allowedCubeCreation;
    }

    public String[] getAllowedDeployTypes() {
        return this.allowedDeployTypes;
    }

    public String[] getAllowedOptimize() {
        return this.allowedOptimize;
    }

    public String[] getAllowedStatus() {
        return this.allowedStatus;
    }

    public String getCognosConnectionDataSourceName() {
        return this.cognosConnectionDataSourceName;
    }

    public int getConsolidatedRecords() {
        return this.consolidatedRecords;
    }

    public String getCubeCreation() {
        return this.cubeCreation;
    }

    public int getCubeCycle() {
        return this.cubeCycle;
    }

    public String getCubeFileName() {
        return this.cubeFileName;
    }

    public int getCubeStamp() {
        return this.cubeStamp;
    }

    public int getDeployCleanupNumberOfCubes() {
        return this.deployCleanupNumberOfCubes;
    }

    public String getDeployLocationsString() {
        String allDeployLocations = "";
        for (File f : this.deployLocations) {
            allDeployLocations = String.valueOf(allDeployLocations) + "\"" + f.toString() + "\" ";
        }
        return allDeployLocations;
    }

    public ArrayList<File> getDeployLocations() {
        return this.deployLocations;
    }

    public String getDeployType() {
        return this.deployType;
    }

    public String getDrillThroughLocations() {
        if (this.drillThroughLocations.equals("")) {
            return this.drillThroughLocations;
        }
        return "\"" + this.drillThroughLocations + "\"";
    }

    public String getEffectiveCubePath() {
        return this.effectiveCubePath;
    }

    public String getEncryptedPW() {
        return this.encryptedPW;
    }

    public String getMDCFile() {
        return this.MDCFile;
    }

    public String getOptimize() {
        return this.optimize;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public int getPartitionSize() {
        return this.partitionSize;
    }

    public int getPassesNumber() {
        return this.passesNumber;
    }

    public String getPowerCubeName() {
        return this.powerCubeName;
    }

    public int getPowerCubeObjectId() {
        return this.powerCubeObjectId;
    }

    public String getPublishStatus() {
        return this.publishStatus;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isBlockParentTotals() {
        return this.blockParentTotals;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public boolean isDataSourceSignon() {
        return this.dataSourceSignon;
    }

    public boolean isDeployCleanupEnabled() {
        return this.deployCleanupEnabled;
    }

    public boolean isDrillThrough() {
        return this.drillThrough;
    }

    public boolean isIncrementalUpdate() {
        return this.incrementalUpdate;
    }

    public boolean isPublishAllowAccessToSuppressionOptions() {
        return this.publishAllowAccessToSuppressionOptions;
    }

    public boolean isPublishAllowMultiEdgeSuppression() {
        return this.publishAllowMultiEdgeSuppression;
    }

    public boolean isPublishAllowNullSuppression() {
        return this.publishAllowNullSuppression;
    }

    public boolean isPublishEnable() {
        return this.publishEnable;
    }

    public boolean isServerCube() {
        return this.serverCube;
    }

    public boolean isUseAlternateFileName() {
        return this.useAlternateFileName;
    }

    public void setAllowedCubeCreation(String[] allowedCubeCreation) {
        this.allowedCubeCreation = allowedCubeCreation;
    }

    public void setAllowedDeployTypes(String[] allowedDeployTypes) {
        this.allowedDeployTypes = allowedDeployTypes;
    }

    public void setAllowedOptimize(String[] allowedOptimize) {
        this.allowedOptimize = allowedOptimize;
    }

    public void setAllowedStatus(String[] allowedStatus) {
        this.allowedStatus = allowedStatus;
    }

    public void setBlockParentTotals(boolean blockParentTotals) {
        this.blockParentTotals = blockParentTotals;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public void setCognosConnectionDataSourceName(String cognosConnectionDataSourceName) {
        this.cognosConnectionDataSourceName = cognosConnectionDataSourceName;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public void setConsolidatedRecords(int consolidatedRecords) {
        this.consolidatedRecords = consolidatedRecords;
    }

    public void setCubeCreation(String cubeCreation) {
        boolean cubeCreationFound = false;
        String[] stringArray = this.allowedCubeCreation;
        int n = this.allowedCubeCreation.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(cubeCreation.toLowerCase())) {
                this.cubeCreation = cubeCreation;
                cubeCreationFound = true;
                break;
            }
            ++n2;
        }
        if (!cubeCreationFound) {
            throw new FmMDException("BMT_MD_INVALID_CUBE_CREATION_OPTION_IN_MDL_POWERCUBE", cubeCreation);
        }
    }

    public void setCubeCycle(int cubeCycle) {
        this.cubeCycle = cubeCycle;
    }

    public void setCubeFileName(String newCubeFileName) {
        this.cubeFileName = String.valueOf(this.cubeFileName) + ".mdc";
    }

    public void setCubeStamp(int cubeStamp) {
        this.cubeStamp = cubeStamp;
    }

    public void setDataSourceSignon(boolean dataSourceSignon) {
        this.dataSourceSignon = dataSourceSignon;
    }

    public void setDeployCleanupEnabled(boolean deployCleanupEnabled) {
        this.deployCleanupEnabled = deployCleanupEnabled;
    }

    public void setDeployCleanupNumberOfCubes(int deployCleanupNumberOfCubes) {
        this.deployCleanupNumberOfCubes = deployCleanupNumberOfCubes;
    }

    public void addDeployLocations(String deployLocation) {
        if (deployLocation.toLowerCase().compareTo(this.effectiveCubePath) == 0) {
            throw new FmMDException("BMT_MD_CONFLICTING_DEPLOY_LOCATION_OPTION_IN_MDL_POWERCUBE", deployLocation, this.effectiveCubePath, String.valueOf(this.effectiveCubePath) + File.separator + "cubeVersionControl" + File.separator);
        }
        boolean deployLocationExists = false;
        for (File f : this.deployLocations) {
            if (!f.toString().toLowerCase().contains(deployLocation.toLowerCase())) continue;
            deployLocationExists = true;
            break;
        }
        if (deployLocationExists) {
            throw new FmMDException("BMT_MD_DUPLICATE_DEPLOY_LOCATION_OPTION_IN_MDL_POWERCUBE", deployLocation);
        }
        if (!deployLocationExists) {
            this.deployLocations.add(new File(deployLocation));
        }
    }

    public void setDeployType(String deployType) {
        boolean deployTypeFound = false;
        String[] stringArray = this.allowedDeployTypes;
        int n = this.allowedDeployTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(deployType.toLowerCase())) {
                this.deployType = deployType;
                deployTypeFound = true;
                break;
            }
            ++n2;
        }
        if (!deployTypeFound) {
            throw new FmMDException("BMT_MD_INVALID_DEPLOY_TYPE_OPTION_IN_MDL_POWERCUBE", deployType);
        }
    }

    public void setDrillThrough(boolean drillThrough) {
        this.drillThrough = drillThrough;
    }

    public void setDrillThrough(boolean drillThrough, String drillThroughLocations) {
        this.drillThrough = drillThrough;
        if (drillThrough) {
            this.setDrillThroughLocations(drillThroughLocations);
        } else {
            this.setDrillThroughLocations("");
        }
    }

    public void setDrillThroughLocations(String drillThroughLocations) {
        this.drillThroughLocations = drillThroughLocations;
    }

    public void setEffectiveCubePath(String effectiveCubePath) {
        this.effectiveCubePath = effectiveCubePath;
    }

    public void setEncryptedPW(String encryptedPW) {
        this.encryptedPW = encryptedPW;
    }

    public void setIncrementalUpdate(boolean incrementalUpdate) {
        this.incrementalUpdate = incrementalUpdate;
    }

    public void setMDCFile(String mDCFile) {
        this.MDCFile = mDCFile;
    }

    public void setOptimize(String optimize) {
        boolean optimizeFound = false;
        String[] stringArray = this.allowedOptimize;
        int n = this.allowedOptimize.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(optimize.toLowerCase())) {
                this.optimize = optimize;
                optimizeFound = true;
                break;
            }
            ++n2;
        }
        if (!optimizeFound) {
            throw new FmMDException("BMT_MD_INVALID_OPTIMIZE_OPTION_IN_MDL_POWERCUBE", optimize);
        }
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setPartitionSize(int partitionSize) {
        this.partitionSize = partitionSize;
    }

    public void setPassesNumber(int passesNumber) {
        this.passesNumber = passesNumber;
    }

    public void setPowerCubeName(String powerCubeName) {
        this.powerCubeName = powerCubeName;
    }

    public void setPowerCubeObjectId(int powerCubeObjectId) {
        this.powerCubeObjectId = powerCubeObjectId;
    }

    public void setPublishAllowAccessToSuppressionOptions(boolean publishAllowAccessToSuppressionOptions) {
        this.publishAllowAccessToSuppressionOptions = publishAllowAccessToSuppressionOptions;
    }

    public void setPublishAllowMultiEdgeSuppression(boolean publishAllowMultiEdgeSuppression) {
        this.publishAllowMultiEdgeSuppression = publishAllowMultiEdgeSuppression;
    }

    public void setPublishAllowNullSuppression(boolean publishAllowNullSuppression) {
        this.publishAllowNullSuppression = publishAllowNullSuppression;
    }

    public void setPublishEnable(boolean publishEnable) {
        this.publishEnable = publishEnable;
    }

    public void setPublishStatus(String publishStatus) {
        this.publishStatus = publishStatus;
    }

    public void setServerCube(boolean serverCube) {
        this.serverCube = serverCube;
    }

    public void setStatus(String status) {
        boolean statusFound = false;
        String[] stringArray = this.allowedStatus;
        int n = this.allowedStatus.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(status.toLowerCase())) {
                this.status = status;
                statusFound = true;
                break;
            }
            ++n2;
        }
        if (!statusFound) {
            throw new FmMDException("BMT_MD_INVALID_STATUS_OPTION_IN_MDL_POWERCUBE", status);
        }
    }

    public void setUseAlternateFileName(boolean useAlternateFileName) {
        this.useAlternateFileName = useAlternateFileName;
    }
}

