/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlColumn;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskExportToMdl.MdlObjectIdTracker;
import com.ibm.cognos.fmeng.utility.FmMDException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class MdlRoot
extends MdlObjectIdTracker {
    private int rootObjectId = 0;
    private String rootName = null;
    private String inclusion = null;
    private Calendar lastUseCal;
    private String lastUse = null;
    private boolean filtered = false;
    private boolean suppressed = false;
    private boolean sign = false;
    private boolean hideValue = false;
    private boolean isKeyOrphanage = false;
    private boolean isTruncated = false;
    private boolean blanks = false;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private String[] allowedInclusion = new String[]{"Default", "Generate", "Suppress", "Retain", "Filtered"};

    public MdlRoot(MdlColumn referenceColumn) {
        this.rootObjectId = MdlRoot.getAndIncreaseNextAvailableObjectId();
        this.rootName = referenceColumn.getColumnName();
        this.inclusion = "Generate";
        this.lastUseCal = Calendar.getInstance();
        this.lastUse = this.sdf.format(this.lastUseCal.getTime());
        this.filtered = false;
        this.suppressed = false;
        this.sign = false;
        this.hideValue = false;
        this.isKeyOrphanage = false;
        this.isTruncated = false;
        this.blanks = false;
    }

    public MdlRoot(String newRootName) {
        this.rootObjectId = MdlRoot.getAndIncreaseNextAvailableObjectId();
        this.rootName = newRootName;
        this.inclusion = "Generate";
        this.lastUseCal = Calendar.getInstance();
        this.lastUse = this.sdf.format(this.lastUseCal.getTime());
        this.filtered = false;
        this.suppressed = false;
        this.sign = false;
        this.hideValue = false;
        this.isKeyOrphanage = false;
        this.isTruncated = false;
        this.blanks = false;
    }

    public String getInclusion() {
        return this.inclusion;
    }

    public String getLastUse() {
        return this.lastUse;
    }

    public Calendar getLastUseCal() {
        return this.lastUseCal;
    }

    public String getRootName() {
        return this.rootName;
    }

    public int getRootObjectId() {
        return this.rootObjectId;
    }

    public SimpleDateFormat getSdf() {
        return this.sdf;
    }

    public boolean isBlanks() {
        return this.blanks;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public boolean isHideValue() {
        return this.hideValue;
    }

    public boolean isKeyOrphanage() {
        return this.isKeyOrphanage;
    }

    public boolean isSign() {
        return this.sign;
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public boolean isTruncated() {
        return this.isTruncated;
    }

    public void setRootName(String rootName) {
        this.rootName = rootName;
    }

    public void setInclusion(String inclusion) {
        boolean inclusionFound = false;
        String[] stringArray = this.allowedInclusion;
        int n = this.allowedInclusion.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.toLowerCase().contains(inclusion.toLowerCase())) {
                this.inclusion = inclusion;
                inclusionFound = true;
                break;
            }
            ++n2;
        }
        if (!inclusionFound) {
            throw new FmMDException("BMT_MD_INVALID_INCLUSION_OPTION_IN_MDL_ROOT", inclusion);
        }
    }

    public void setLastUse(String lastUse) {
        this.lastUse = lastUse;
    }

    public void setFiltered(boolean filtered) {
        this.filtered = filtered;
    }

    public void setSuppressed(boolean suppressed) {
        this.suppressed = suppressed;
    }

    public void setSign(boolean sign) {
        this.sign = sign;
    }

    public void setHideValue(boolean hideValue) {
        this.hideValue = hideValue;
    }

    public void setKeyOrphanage(boolean isKeyOrphanage) {
        this.isKeyOrphanage = isKeyOrphanage;
    }

    public void setTruncated(boolean isTruncated) {
        this.isTruncated = isTruncated;
    }

    public void setBlanks(boolean blanks) {
        this.blanks = blanks;
    }
}

