/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLFetcher;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLTableFM;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.QuerySubject;
import com.ibm.cognos.fmeng.fmmd.util.SQLParseResult;
import com.ibm.cognos.fmeng.fmmd.util.SQLParser;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLFetcherFM
extends DDLFetcher {
    private List<QuerySubject> m_dbQSList = null;
    private Iterator<QuerySubject> m_it;

    public DDLFetcherFM(List<QuerySubject> qsList) {
        this.m_dbQSList = qsList;
    }

    @Override
    public void start() {
        this.m_it = this.m_dbQSList.iterator();
    }

    @Override
    public void end() {
    }

    @Override
    public boolean hasNext() {
        return this.m_it.hasNext();
    }

    @Override
    public DDLTable next() {
        QuerySubject dbQS = this.m_it.next();
        String tableName = dbQS.getName();
        DataSource ds = dbQS.getDBQuery().getDataSources().get(0);
        String schemaName = ds.getSchemaName();
        String sql = dbQS.getDBQuery().getSQL();
        boolean foundTableName = false;
        if (sql.contains(tableName)) {
            foundTableName = true;
        } else {
            SQLParser parser = new SQLParser();
            HashSet<String> datasourceNames = new HashSet<String>();
            for (DataSource dsToAdd : dbQS.getSession().getProject().getDataSources()) {
                datasourceNames.add(dsToAdd.getName());
            }
            SQLParseResult results = parser.parse(sql, datasourceNames);
            if (results.isSet()) {
                tableName = results.m_Table;
                foundTableName = true;
            }
        }
        return new DDLTableFM(foundTableName, tableName, schemaName, dbQS);
    }
}

