/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL;

import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLFetcher;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLTable;
import com.ibm.cognos.fmeng.fmmd.impl.model.taskGenerateDDL.DDLTableRO;
import com.ibm.cognos.fmeng.fmmd.model.DataSource;
import com.ibm.cognos.fmeng.fmmd.model.QueryItemMapping;
import com.ibm.cognos.fmeng.fmmd.model.RelationalObject;
import com.ibm.cognos.fmeng.fmmd.model.Table;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DDLFetcherRO
extends DDLFetcher {
    private List<RelationalObject> m_roList;
    private LinkedHashMap<String, DDLTableRO> m_tableList;
    private Iterator<String> m_it;

    public DDLFetcherRO(List<RelationalObject> roList) {
        this.m_roList = roList;
    }

    @Override
    public void start() {
        this.m_tableList = new LinkedHashMap();
        for (RelationalObject ro : this.m_roList) {
            for (Table table : ro.getTables()) {
                DataSource ds = table.getDataSource();
                String fullName = String.valueOf(ds.getCmDataSourceName()) + table.getTableName();
                DDLTableRO ddlTable = this.m_tableList.get(fullName);
                if (ddlTable == null) {
                    ddlTable = new DDLTableRO(true, table.getTableName(), ds.getSchemaName());
                    this.m_tableList.put(fullName, ddlTable);
                }
                for (QueryItemMapping qim : ro.getQueryItemMappings(table)) {
                    ddlTable.addColumn(qim.getColumnName(), qim.getQueryItem());
                }
            }
        }
        this.m_it = this.m_tableList.keySet().iterator();
    }

    @Override
    public void end() {
    }

    @Override
    public boolean hasNext() {
        return this.m_it.hasNext();
    }

    @Override
    public DDLTable next() {
        return this.m_tableList.get(this.m_it.next());
    }
}

